/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.StructureErode;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.world.features.NBTFeature;
import org.betterx.betterend.world.features.NBTFeatureConfig;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class CrashedShipFeature
extends NBTFeature<NBTFeatureConfig> {
    private static final StructureProcessor REPLACER = new StructureProcessor(){

        public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlacementData) {
            BlockState state = structureBlockInfo2.f_74676_();
            if (state.m_60713_(Blocks.f_50085_) || state.m_60827_() == SoundType.f_56745_) {
                return new StructureTemplate.StructureBlockInfo(structureBlockInfo2.f_74675_(), DefaultFeature.AIR, null);
            }
            return structureBlockInfo2;
        }

        protected StructureProcessorType<?> m_6953_() {
            return StructureProcessorType.f_74461_;
        }
    };
    private static final String STRUCTURE_PATH = "/data/minecraft/structures/end_city/ship.nbt";
    private StructureTemplate structure;

    public CrashedShipFeature() {
        super(NBTFeatureConfig.CODEC);
    }

    @Override
    protected StructureTemplate getStructure(NBTFeatureConfig cfg, WorldGenLevel world, BlockPos pos, RandomSource random) {
        if (this.structure == null) {
            this.structure = world.m_6018_().m_215082_().m_230359_(new ResourceLocation("end_city/ship"));
            if (this.structure == null) {
                this.structure = StructureHelper.readStructure((String)STRUCTURE_PATH);
            }
        }
        return this.structure;
    }

    @Override
    protected boolean canSpawn(WorldGenLevel world, BlockPos pos, RandomSource random) {
        long z;
        long x = pos.m_123341_() >> 4;
        if (x * x + (z = (long)(pos.m_123341_() >> 4)) * z < 3600L) {
            return false;
        }
        return pos.m_123342_() > 5 && world.m_8055_(pos.m_7495_()).m_204336_(CommonBlockTags.GEN_END_STONES);
    }

    @Override
    protected Rotation getRotation(WorldGenLevel world, BlockPos pos, RandomSource random) {
        return Rotation.m_221990_((RandomSource)random);
    }

    @Override
    protected Mirror getMirror(WorldGenLevel world, BlockPos pos, RandomSource random) {
        return Mirror.values()[random.m_188503_(3)];
    }

    @Override
    protected int getYOffset(StructureTemplate structure, WorldGenLevel world, BlockPos pos, RandomSource random) {
        int min = structure.m_163801_().m_123342_() >> 3;
        int max = structure.m_163801_().m_123342_() >> 2;
        return -MHelper.randRange((int)min, (int)max, (RandomSource)random);
    }

    @Override
    protected NBTFeature.TerrainMerge getTerrainMerge(WorldGenLevel world, BlockPos pos, RandomSource random) {
        return NBTFeature.TerrainMerge.NONE;
    }

    @Override
    public boolean m_142674_(FeaturePlaceContext<NBTFeatureConfig> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos center = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        center = new BlockPos(center.m_123341_() >> 4 << 4 | 8, 128, center.m_123343_() >> 4 << 4 | 8);
        center = this.getGround(world, center);
        BoundingBox bounds = this.makeBox(center);
        if (!this.canSpawn(world, center, random)) {
            return false;
        }
        StructureTemplate structure = this.getStructure((NBTFeatureConfig)featureConfig.m_159778_(), world, center, random);
        Rotation rotation = this.getRotation(world, center, random);
        Mirror mirror = this.getMirror(world, center, random);
        BlockPos offset = StructureTemplate.m_74593_((BlockPos)new BlockPos(structure.m_163801_()), (Mirror)mirror, (Rotation)rotation, (BlockPos)BlockPos.f_121853_);
        center = center.m_7918_(0, (int)((double)this.getYOffset(structure, world, center, random) + 0.5), 0);
        StructurePlaceSettings placementData = new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror);
        center = center.m_7918_((int)((double)(-offset.m_123341_()) * 0.5), 0, (int)((double)(-offset.m_123343_()) * 0.5));
        BoundingBox structB = structure.m_74633_(placementData, center);
        bounds = StructureHelper.intersectBoxes((BoundingBox)bounds, (BoundingBox)structB);
        this.addStructureData(placementData);
        structure.m_230328_((ServerLevelAccessor)world, center, center, placementData.m_74381_(bounds), random, 2);
        StructureErode.erodeIntense((WorldGenLevel)world, (BoundingBox)bounds, (RandomSource)random);
        BlockFixer.fixBlocks((LevelAccessor)world, new BlockPos(bounds.m_162395_(), bounds.m_162396_(), bounds.m_162398_()), new BlockPos(bounds.m_162399_(), bounds.m_162400_(), bounds.m_162401_()));
        return true;
    }

    @Override
    protected void addStructureData(StructurePlaceSettings data) {
        data.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_(REPLACER).m_74392_(true);
    }
}

