/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.cave;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.WeightedList;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;

public class LushSmaragdantCaveBiome
extends EndCaveBiome.Config {
    public static final Codec<Biome> CODEC = EndCaveBiome.simpleCaveBiomeCodec(Biome::new);
    public static final KeyDispatchDataCodec<Biome> KEY_CODEC = KeyDispatchDataCodec.m_216236_(CODEC);

    public LushSmaragdantCaveBiome() {
        super("lush_smaragdant_cave");
    }

    @Override
    protected void addCustomBuildData(BCLBiomeBuilder builder) {
        super.addCustomBuildData(builder);
        builder.fogColor(0, 253, 182).fogDensity(2.0f).plantsColor(0, 131, 145).waterAndFogColor(31, 167, 212).particles((ParticleOptions)EndParticles.SMARAGDANT, 0.001f);
    }

    @Override
    public BCLBiomeBuilder.BiomeSupplier<EndBiome> getSupplier() {
        return Biome::new;
    }

    @Override
    protected SurfaceMaterialProvider surfaceMaterial() {
        return new EndBiome.DefaultSurfaceMaterialProvider(){

            @Override
            public BlockState getTopMaterial() {
                return EndBlocks.CAVE_MOSS.m_49966_();
            }
        };
    }

    public static class Biome
    extends EndCaveBiome {
        public Biome(ResourceKey<net.minecraft.world.level.biome.Biome> biomeID, BCLBiomeSettings settings) {
            super(biomeID, settings);
            this.addFloorFeature(EndFeatures.SMARAGDANT_CRYSTAL.configuredFeature, 1.0f);
            this.addFloorFeature(EndFeatures.SMARAGDANT_CRYSTAL_SHARD.configuredFeature, 20.0f);
            this.addCeilFeature(EndFeatures.END_STONE_STALACTITE.configuredFeature, 1.0f);
        }

        @Override
        public KeyDispatchDataCodec<? extends BCLBiome> codec() {
            return KEY_CODEC;
        }

        protected Biome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<ResourceLocation> edge, ResourceLocation biomeID, Optional<List<Climate.ParameterPoint>> parameterPoints, Optional<ResourceLocation> biomeParent, Optional<String> intendedType, boolean hasCaves, SurfaceMaterialProvider surface, WeightedList<Holder<ConfiguredFeature<?, ?>>> floorFeatures, WeightedList<Holder<ConfiguredFeature<?, ?>>> ceilFeatures) {
            super(terrainHeight, fogDensity, genChance, edgeSize, vertical, edge, biomeID, parameterPoints, biomeParent, intendedType, hasCaves, surface, floorFeatures, ceilFeatures);
        }

        @Override
        public float getFloorDensity() {
            return 0.1f;
        }

        @Override
        public float getCeilDensity() {
            return 0.1f;
        }
    }
}

