/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.util;

import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndTemplates;

public class LootTableUtil {
    public static final ResourceLocation VILLAGE_LOOT = BetterEnd.makeID("chests/end_village_loot");
    public static final ResourceLocation VILLAGE_TEMPLATE_LOOT = BetterEnd.makeID("chests/end_village_template_loot");
    public static final ResourceLocation VILLAGE_BONUS_LOOT = BetterEnd.makeID("chests/end_village_bonus_loot");
    public static final ResourceLocation COMMON = BetterEnd.makeID("chests/common");
    public static final ResourceLocation FOGGY_MUSHROOMLAND = BetterEnd.makeID("chests/foggy_mushroomland");
    public static final ResourceLocation CHORUS_FOREST = BetterEnd.makeID("chests/chorus_forest");
    public static final ResourceLocation SHADOW_FOREST = BetterEnd.makeID("chests/shadow_forest");
    public static final ResourceLocation LANTERN_WOODS = BetterEnd.makeID("chests/lantern_woods");
    public static final ResourceLocation UMBRELLA_JUNGLE = BetterEnd.makeID("chests/umbrella_jungle");
    public static final ResourceLocation BIOME_CHEST = BetterEnd.makeID("chests/biome");
    public static final ResourceLocation FISHING_FISH = BetterEnd.makeID("gameplay/fishing/fish");
    public static final ResourceLocation FISHING_TREASURE = BetterEnd.makeID("gameplay/fishing/treasure");
    public static final ResourceLocation FISHING_JUNK = BetterEnd.makeID("gameplay/fishing/junk");
    public static final LootItemCondition.Builder IN_END = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_153976_(Level.f_46430_));
    public static final LootItemCondition.Builder IN_FOGGY_MUSHROOMLAND = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.FOGGY_MUSHROOMLAND));
    public static final LootItemCondition.Builder IN_CHORUS_FOREST = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.CHORUS_FOREST));
    public static final LootItemCondition.Builder IN_AMBER_LAND = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.AMBER_LAND));
    public static final LootItemCondition.Builder IN_GLOWING_GRASSLANDS = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.GLOWING_GRASSLANDS));
    public static final LootItemCondition.Builder IN_LANTERN_WOODS = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.LANTERN_WOODS));
    public static final LootItemCondition.Builder IN_MEGALAKE = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.MEGALAKE));
    public static final LootItemCondition.Builder IN_MEGALAKE_GROVE = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.MEGALAKE_GROVE));
    public static final LootItemCondition.Builder IN_NEON_OASIS = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.NEON_OASIS));
    public static final LootItemCondition.Builder IN_SHADOW_FOREST = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.SHADOW_FOREST));
    public static final LootItemCondition.Builder IN_SULPHUR_SPRINGS = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.SULPHUR_SPRINGS));
    public static final LootItemCondition.Builder IN_UMBRELLA_JUNGLE = LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(EndBiomes.UMBRELLA_JUNGLE));

    public static void init() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, table, setter) -> {
            if (BuiltInLootTables.f_78741_.equals((Object)id)) {
                LootPool.Builder builder = LootPool.m_79043_();
                builder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
                builder.m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.2f));
                builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42586_));
                table.m_79161_(builder);
                builder = LootPool.m_79043_();
                builder.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f));
                builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndItems.MUSIC_DISC_STRANGE_AND_ALIEN));
                builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndItems.MUSIC_DISC_GRASPING_AT_STARS));
                builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndItems.MUSIC_DISC_ENDSEEKER));
                builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndItems.MUSIC_DISC_EO_DRACONA));
                table.m_79161_(builder);
                table.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)).m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(12)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndTemplates.NETHERITE_UPGRADE).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndTemplates.HANDLE_ATTACHMENT).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndTemplates.LEATHER_HANDLE_ATTACHMENT).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndTemplates.TOOL_ASSEMBLY).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndTemplates.AETERNIUM_UPGRADE).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndTemplates.THALLASIUM_UPGRADE).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)EndTemplates.TERMINITE_UPGRADE).m_79707_(2)));
            } else if (BuiltInLootTables.f_78720_.equals((Object)id)) {
                table.modifyPools(modifier -> modifier.m_79080_(IN_END.m_81807_()));
                table.m_79161_(LootPool.m_79043_().m_79080_(IN_END).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)FISHING_FISH).m_79707_(85).m_79711_(-1)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)FISHING_TREASURE).m_79707_(5).m_79711_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)FISHING_JUNK).m_79707_(10).m_79711_(-2)));
            }
        });
    }

    public static ResourceLocation getTable(Holder<Biome> biome) {
        BCLBiome bclBiome = BiomeAPI.getBiome((Biome)((Biome)biome.m_203334_()));
        if (bclBiome != null) {
            if (bclBiome.equals(EndBiomes.FOGGY_MUSHROOMLAND)) {
                return FOGGY_MUSHROOMLAND;
            }
            if (bclBiome.equals(EndBiomes.CHORUS_FOREST)) {
                return CHORUS_FOREST;
            }
            if (bclBiome.equals(EndBiomes.SHADOW_FOREST)) {
                return SHADOW_FOREST;
            }
            if (bclBiome.equals(EndBiomes.LANTERN_WOODS)) {
                return LANTERN_WOODS;
            }
            if (bclBiome.equals(EndBiomes.UMBRELLA_JUNGLE)) {
                return UMBRELLA_JUNGLE;
            }
        }
        return COMMON;
    }
}

