/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.rituals;

import java.awt.Point;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.blocks.entities.InfusionPedestalEntity;
import org.betterx.betterend.blocks.entities.PedestalBlockEntity;
import org.betterx.betterend.particle.InfusionParticleType;
import org.betterx.betterend.recipe.builders.InfusionRecipe;

public class InfusionRitual
implements Container {
    private static final Point[] PEDESTALS_MAP = new Point[]{new Point(0, 3), new Point(2, 2), new Point(3, 0), new Point(2, -2), new Point(0, -3), new Point(-2, -2), new Point(-3, 0), new Point(-2, 2)};
    private Level world;
    private BlockPos worldPos;
    private InfusionRecipe activeRecipe;
    private boolean isDirty = false;
    private boolean hasRecipe = false;
    private int progress = 0;
    private int time = 0;
    private final PedestalBlockEntity[] catalysts = new PedestalBlockEntity[8];
    private final InfusionPedestalEntity input;

    public InfusionRitual(InfusionPedestalEntity pedestal, Level world, BlockPos pos) {
        this.input = pedestal;
        this.world = world;
        this.worldPos = pos;
    }

    public void configure() {
        if (this.world == null || this.worldPos == null) {
            return;
        }
        for (int i = 0; i < this.catalysts.length; ++i) {
            Point point = PEDESTALS_MAP[i];
            BlockPos.MutableBlockPos checkPos = this.worldPos.m_122032_().m_122175_(Direction.EAST, point.x).m_122175_(Direction.NORTH, point.y);
            BlockEntity catalystEntity = this.world.f_46443_ ? this.world.m_46745_((BlockPos)checkPos).m_5685_((BlockPos)checkPos, LevelChunk.EntityCreationType.CHECK) : this.world.m_7702_((BlockPos)checkPos);
            this.catalysts[i] = catalystEntity instanceof PedestalBlockEntity ? (PedestalBlockEntity)catalystEntity : null;
        }
    }

    public boolean checkRecipe() {
        if (!this.isValid()) {
            return false;
        }
        InfusionRecipe recipe = this.world.m_7465_().m_44015_(InfusionRecipe.TYPE, (Container)this, this.world).orElse(null);
        if (this.hasRecipe()) {
            if (recipe == null) {
                this.reset();
                return false;
            }
            if (this.activeRecipe == null || recipe.getInfusionTime() != this.time) {
                this.updateRecipe(recipe);
            }
            return true;
        }
        if (recipe != null) {
            this.updateRecipe(recipe);
            return true;
        }
        return false;
    }

    private void updateRecipe(InfusionRecipe recipe) {
        this.activeRecipe = recipe;
        this.hasRecipe = true;
        this.resetTimer();
        this.m_6596_();
    }

    private void resetTimer() {
        this.time = this.activeRecipe != null ? this.activeRecipe.getInfusionTime() : 0;
        this.progress = 0;
    }

    public void reset() {
        this.activeRecipe = null;
        this.hasRecipe = false;
        this.resetTimer();
        this.m_6596_();
    }

    public void tick() {
        if (this.isDirty) {
            this.configure();
            this.isDirty = false;
        }
        if (!this.checkRecipe()) {
            return;
        }
        ++this.progress;
        if (this.progress == this.time) {
            this.m_6211_();
            this.input.m_6836_(0, this.activeRecipe.assemble(this, this.world.m_9598_()));
            Level level = this.world;
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                sl.m_8795_(p -> p.m_20182_().m_82546_(new Vec3((double)this.worldPos.m_123341_(), (double)this.worldPos.m_123342_(), (double)this.worldPos.m_123343_())).m_82553_() < 16.0).forEach(p -> BECriteria.INFUSION_FINISHED.m_222618_(p));
            }
            this.reset();
        } else {
            Level sl = this.world;
            if (sl instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)sl;
                BlockPos target = this.worldPos.m_7494_();
                double tx = (double)target.m_123341_() + 0.5;
                double ty = (double)target.m_123342_() + 0.5;
                double tz = (double)target.m_123343_() + 0.5;
                for (PedestalBlockEntity catalyst : this.catalysts) {
                    ItemStack stack = catalyst.m_8020_(0);
                    if (stack.m_41619_()) continue;
                    BlockPos start = catalyst.m_58899_();
                    double sx = (double)start.m_123341_() + 0.5;
                    double sy = (double)start.m_123342_() + 1.25;
                    double sz = (double)start.m_123343_() + 0.5;
                    serverLevel.m_8767_((ParticleOptions)new InfusionParticleType(stack), sx, sy, sz, 0, tx - sx, ty - sy, tz - sz, 0.5);
                }
            }
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return this.isValid();
    }

    public boolean isValid() {
        if (this.world == null || this.worldPos == null || this.input == null) {
            return false;
        }
        return Arrays.stream(this.catalysts).noneMatch(Objects::isNull);
    }

    public boolean hasRecipe() {
        return this.hasRecipe;
    }

    public void setLocation(Level world, BlockPos pos) {
        this.world = world;
        this.worldPos = pos;
        this.isDirty = true;
    }

    public void m_6211_() {
        if (!this.isValid()) {
            return;
        }
        this.input.m_6211_();
        Arrays.stream(this.catalysts).forEach(PedestalBlockEntity::m_6211_);
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int slot) {
        if (slot > 8) {
            return ItemStack.f_41583_;
        }
        if (slot == 0) {
            return this.input.m_8020_(0);
        }
        return this.catalysts[slot - 1].m_8020_(0);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.m_8016_(slot);
    }

    public ItemStack m_8016_(int slot) {
        if (slot > 8) {
            return ItemStack.f_41583_;
        }
        if (slot == 0) {
            return this.input.m_8016_(0);
        }
        return this.catalysts[slot - 1].m_8016_(0);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (slot > 8) {
            return;
        }
        if (slot == 0) {
            this.input.m_6836_(0, stack);
        } else {
            this.catalysts[slot - 1].m_6836_(0, stack);
        }
    }

    public void m_6596_() {
        if (this.isValid()) {
            this.input.m_6596_();
            Arrays.stream(this.catalysts).forEach(PedestalBlockEntity::m_6596_);
        }
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void fromTag(CompoundTag tag) {
        if (tag.m_128441_("recipe")) {
            this.hasRecipe = tag.m_128471_("recipe");
            this.progress = tag.m_128451_("progress");
            this.time = tag.m_128451_("time");
        }
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (this.hasRecipe()) {
            tag.m_128379_("recipe", this.hasRecipe);
            tag.m_128405_("progress", this.progress);
            tag.m_128405_("time", this.time);
        }
        return tag;
    }

    public static Point[] getMap() {
        return PEDESTALS_MAP;
    }
}

