/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.items.BaseArmorItem;
import org.betterx.bclib.items.ModelProviderItem;
import org.betterx.bclib.items.tool.BaseAxeItem;
import org.betterx.bclib.items.tool.BaseHoeItem;
import org.betterx.bclib.items.tool.BaseShovelItem;
import org.betterx.bclib.items.tool.BaseSwordItem;
import org.betterx.bclib.registry.BaseRegistry;
import org.betterx.bclib.registry.ItemRegistry;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.item.ArmoredElytra;
import org.betterx.betterend.item.CrystaliteBoots;
import org.betterx.betterend.item.CrystaliteChestplate;
import org.betterx.betterend.item.CrystaliteElytra;
import org.betterx.betterend.item.CrystaliteHelmet;
import org.betterx.betterend.item.CrystaliteLeggings;
import org.betterx.betterend.item.EnchantedItem;
import org.betterx.betterend.item.EndArmorItem;
import org.betterx.betterend.item.EndBucketItem;
import org.betterx.betterend.item.EternalCrystalItem;
import org.betterx.betterend.item.material.EndArmorMaterial;
import org.betterx.betterend.item.material.EndToolMaterial;
import org.betterx.betterend.item.tool.EndHammerItem;
import org.betterx.betterend.item.tool.EndPickaxe;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.util.DebugHelpers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EndItems {
    private static final ItemRegistry REGISTRY = new ItemRegistry(Configs.ITEM_CONFIG);
    public static final Item ENDER_DUST = EndItems.registerEndItem("ender_dust");
    public static final Item ENDER_SHARD = EndItems.registerEndItem("ender_shard");
    public static final Item AETERNIUM_INGOT = EndItems.registerEndItem("aeternium_ingot", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_FORGED_PLATE = EndItems.registerEndItem("aeternium_forged_plate", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().m_41486_()));
    public static final Item END_LILY_LEAF = EndItems.registerEndItem("end_lily_leaf");
    public static final Item END_LILY_LEAF_DRIED = EndItems.registerEndItem("end_lily_leaf_dried");
    public static final Item CRYSTAL_SHARDS = EndItems.registerEndItem("crystal_shards");
    public static final Item RAW_AMBER = EndItems.registerEndItem("raw_amber");
    public static final Item AMBER_GEM = EndItems.registerEndItem("amber_gem");
    public static final Item GLOWING_BULB = EndItems.registerEndItem("glowing_bulb");
    public static final Item CRYSTALLINE_SULPHUR = EndItems.registerEndItem("crystalline_sulphur");
    public static final Item HYDRALUX_PETAL = EndItems.registerEndItem("hydralux_petal");
    public static final Item GELATINE = EndItems.registerEndItem("gelatine");
    public static final Item ETERNAL_CRYSTAL = EndItems.registerEndItem("eternal_crystal", (Item)new EternalCrystalItem());
    public static final Item ENCHANTED_PETAL = EndItems.registerEndItem("enchanted_petal", (Item)new EnchantedItem(HYDRALUX_PETAL));
    public static final Item LEATHER_STRIPE = EndItems.registerEndItem("leather_stripe");
    public static final Item LEATHER_WRAPPED_STICK = EndItems.registerEndItem("leather_wrapped_stick");
    public static final Item SILK_FIBER = EndItems.registerEndItem("silk_fiber");
    public static final Item LUMECORN_ROD = EndItems.registerEndItem("lumecorn_rod");
    public static final Item SILK_MOTH_MATRIX = EndItems.registerEndItem("silk_moth_matrix");
    public static final Item ENCHANTED_MEMBRANE = EndItems.registerEndItem("enchanted_membrane", (Item)new EnchantedItem(Items.f_42714_));
    public static final Item MUSIC_DISC_STRANGE_AND_ALIEN = EndItems.registerEndDisc("music_disc_strange_and_alien", 0, EndSounds.RECORD_STRANGE_AND_ALIEN, 266);
    public static final Item MUSIC_DISC_GRASPING_AT_STARS = EndItems.registerEndDisc("music_disc_grasping_at_stars", 0, EndSounds.RECORD_GRASPING_AT_STARS, 528);
    public static final Item MUSIC_DISC_ENDSEEKER = EndItems.registerEndDisc("music_disc_endseeker", 0, EndSounds.RECORD_ENDSEEKER, 461);
    public static final Item MUSIC_DISC_EO_DRACONA = EndItems.registerEndDisc("music_disc_eo_dracona", 0, EndSounds.RECORD_EO_DRACONA, 353);
    public static final Item AETERNIUM_HELMET = EndItems.registerEndItem("aeternium_helmet", (Item)new BaseArmorItem((ArmorMaterial)EndArmorMaterial.AETERNIUM, ArmorItem.Type.HELMET, EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_CHESTPLATE = EndItems.registerEndItem("aeternium_chestplate", (Item)new BaseArmorItem((ArmorMaterial)EndArmorMaterial.AETERNIUM, ArmorItem.Type.CHESTPLATE, EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_LEGGINGS = EndItems.registerEndItem("aeternium_leggings", (Item)new BaseArmorItem((ArmorMaterial)EndArmorMaterial.AETERNIUM, ArmorItem.Type.LEGGINGS, EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_BOOTS = EndItems.registerEndItem("aeternium_boots", (Item)new BaseArmorItem((ArmorMaterial)EndArmorMaterial.AETERNIUM, ArmorItem.Type.BOOTS, EndItems.makeEndItemSettings().m_41486_()));
    public static final Item CRYSTALITE_HELMET = EndItems.registerEndItem("crystalite_helmet", (Item)new CrystaliteHelmet());
    public static final Item CRYSTALITE_CHESTPLATE = EndItems.registerEndItem("crystalite_chestplate", (Item)new CrystaliteChestplate());
    public static final Item CRYSTALITE_LEGGINGS = EndItems.registerEndItem("crystalite_leggings", (Item)new CrystaliteLeggings());
    public static final Item CRYSTALITE_BOOTS = EndItems.registerEndItem("crystalite_boots", (Item)new CrystaliteBoots());
    public static final Item ARMORED_ELYTRA = EndItems.registerEndItem("elytra_armored", (Item)new ArmoredElytra("elytra_armored", EndArmorMaterial.AETERNIUM, Items.f_42714_, 900, 0.97, true));
    public static final Item CRYSTALITE_ELYTRA = EndItems.registerEndItem("elytra_crystalite", (Item)new CrystaliteElytra(650, 1.0));
    public static final TieredItem AETERNIUM_SHOVEL = EndItems.registerEndTool("aeternium_shovel", (TieredItem)new BaseShovelItem((Tier)EndToolMaterial.AETERNIUM, 1.5f, -3.0f, EndItems.makeEndItemSettings().m_41486_()));
    public static final TieredItem AETERNIUM_SWORD = EndItems.registerEndTool("aeternium_sword", (TieredItem)new BaseSwordItem((Tier)EndToolMaterial.AETERNIUM, 3, -2.4f, EndItems.makeEndItemSettings().m_41486_()));
    public static final TieredItem AETERNIUM_PICKAXE = EndItems.registerEndTool("aeternium_pickaxe", (TieredItem)new EndPickaxe(EndToolMaterial.AETERNIUM, 1, -2.8f, EndItems.makeEndItemSettings().m_41486_()));
    public static final TieredItem AETERNIUM_AXE = EndItems.registerEndTool("aeternium_axe", (TieredItem)new BaseAxeItem((Tier)EndToolMaterial.AETERNIUM, 5.0f, -3.0f, EndItems.makeEndItemSettings().m_41486_()));
    public static final TieredItem AETERNIUM_HOE = EndItems.registerEndTool("aeternium_hoe", (TieredItem)new BaseHoeItem((Tier)EndToolMaterial.AETERNIUM, -3, 0.0f, EndItems.makeEndItemSettings().m_41486_()));
    public static final TieredItem AETERNIUM_HAMMER = EndItems.registerEndTool("aeternium_hammer", (TieredItem)new EndHammerItem(EndToolMaterial.AETERNIUM, 6.0f, -3.0f, 0.3, EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_SHOVEL_HEAD = EndItems.registerEndItem("aeternium_shovel_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_PICKAXE_HEAD = EndItems.registerEndItem("aeternium_pickaxe_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_AXE_HEAD = EndItems.registerEndItem("aeternium_axe_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_HOE_HEAD = EndItems.registerEndItem("aeternium_hoe_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_HAMMER_HEAD = EndItems.registerEndItem("aeternium_hammer_head", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_SWORD_BLADE = EndItems.registerEndItem("aeternium_sword_blade", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().m_41486_()));
    public static final Item AETERNIUM_SWORD_HANDLE = EndItems.registerEndItem("aeternium_sword_handle", (Item)new ModelProviderItem(EndItems.makeEndItemSettings().m_41486_()));
    public static final TieredItem IRON_HAMMER = EndItems.registerEndTool("iron_hammer", (TieredItem)new EndHammerItem((Tier)Tiers.IRON, 5.0f, -3.2f, 0.2, EndItems.makeEndItemSettings()));
    public static final TieredItem GOLDEN_HAMMER = EndItems.registerEndTool("golden_hammer", (TieredItem)new EndHammerItem((Tier)Tiers.GOLD, 4.5f, -3.4f, 0.3, EndItems.makeEndItemSettings()));
    public static final TieredItem DIAMOND_HAMMER = EndItems.registerEndTool("diamond_hammer", (TieredItem)new EndHammerItem((Tier)Tiers.DIAMOND, 5.5f, -3.1f, 0.2, EndItems.makeEndItemSettings()));
    public static final TieredItem NETHERITE_HAMMER = EndItems.registerEndTool("netherite_hammer", (TieredItem)new EndHammerItem((Tier)Tiers.NETHERITE, 5.0f, -3.0f, 0.2, EndItems.makeEndItemSettings().m_41486_()));
    public static final Item SHADOW_BERRY_RAW = EndItems.registerEndFood("shadow_berry_raw", 4, 0.5f, new MobEffectInstance[0]);
    public static final Item SHADOW_BERRY_COOKED = EndItems.registerEndFood("shadow_berry_cooked", 6, 0.7f, new MobEffectInstance[0]);
    public static final Item END_FISH_RAW = EndItems.registerEndFood("end_fish_raw", Foods.f_38805_);
    public static final Item END_FISH_COOKED = EndItems.registerEndFood("end_fish_cooked", Foods.f_38826_);
    public static final Item BUCKET_END_FISH = EndItems.registerEndItem("bucket_end_fish", (Item)new EndBucketItem(EndEntities.END_FISH.type()));
    public static final Item BUCKET_CUBOZOA = EndItems.registerEndItem("bucket_cubozoa", (Item)new EndBucketItem(EndEntities.CUBOZOA.type()));
    public static final Item SWEET_BERRY_JELLY = EndItems.registerEndFood("sweet_berry_jelly", 8, 0.7f, new MobEffectInstance[0]);
    public static final Item SHADOW_BERRY_JELLY = EndItems.registerEndFood("shadow_berry_jelly", 6, 0.8f, new MobEffectInstance(MobEffects.f_19611_, 400));
    public static final Item BLOSSOM_BERRY_JELLY = EndItems.registerEndFood("blossom_berry_jelly", 8, 0.7f, new MobEffectInstance[0]);
    public static final Item BLOSSOM_BERRY = EndItems.registerEndFood("blossom_berry", Foods.f_38810_);
    public static final Item AMBER_ROOT_RAW = EndItems.registerEndFood("amber_root_raw", 2, 0.8f, new MobEffectInstance[0]);
    public static final Item CHORUS_MUSHROOM_RAW = EndItems.registerEndFood("chorus_mushroom_raw", 3, 0.5f, new MobEffectInstance[0]);
    public static final Item CHORUS_MUSHROOM_COOKED = EndItems.registerEndFood("chorus_mushroom_cooked", Foods.f_38834_);
    public static final Item BOLUX_MUSHROOM_COOKED = EndItems.registerEndFood("bolux_mushroom_cooked", Foods.f_38834_);
    public static final Item CAVE_PUMPKIN_PIE = EndItems.registerEndFood("cave_pumpkin_pie", Foods.f_38801_);
    public static final Item UMBRELLA_CLUSTER_JUICE = EndItems.registerEndDrink("umbrella_cluster_juice", 5, 0.7f);

    public static List<Item> getModItems() {
        return BaseRegistry.getModItems((String)"betterend");
    }

    public static Item registerEndDisc(String name, int power, Holder<SoundEvent> sound, int lengthInSeconds) {
        return EndItems.getItemRegistry().registerDisc(BetterEnd.makeID(name), power, (SoundEvent)sound.m_203334_(), lengthInSeconds);
    }

    public static Item registerEndItem(String name) {
        return EndItems.getItemRegistry().register(BetterEnd.makeID(name));
    }

    public static Item registerEndItem(String name, Item item) {
        if (item instanceof EndArmorItem) {
            return EndItems.getItemRegistry().register(BetterEnd.makeID(name), item, "armour");
        }
        return EndItems.getItemRegistry().register(BetterEnd.makeID(name), item);
    }

    public static TieredItem registerEndTool(String name, TieredItem item) {
        if (!Configs.ITEM_CONFIG.getBoolean("tools", name, true)) {
            return item;
        }
        return (TieredItem)EndItems.getItemRegistry().registerTool(BetterEnd.makeID(name), (Item)item);
    }

    public static Item registerEndEgg(String name, EntityType<? extends Mob> type, int background, int dots) {
        return EndItems.getItemRegistry().registerEgg(BetterEnd.makeID(name), type, background, dots);
    }

    public static Item registerEndFood(String name, int hunger, float saturation, MobEffectInstance ... effects) {
        return EndItems.getItemRegistry().registerFood(BetterEnd.makeID(name), hunger, saturation, effects);
    }

    public static Item registerEndFood(String name, FoodProperties foodComponent) {
        return EndItems.getItemRegistry().registerFood(BetterEnd.makeID(name), foodComponent);
    }

    public static Item registerEndDrink(String name, int hunger, float saturation) {
        return EndItems.getItemRegistry().registerDrink(BetterEnd.makeID(name), hunger, saturation);
    }

    public static Item.Properties makeEndItemSettings() {
        return EndItems.getItemRegistry().makeItemSettings();
    }

    @NotNull
    public static ItemRegistry getItemRegistry() {
        return REGISTRY;
    }

    @ApiStatus.Internal
    public static void register() {
        if (BCLib.isDevEnvironment()) {
            DebugHelpers.generateDebugItems();
        }
    }
}

