/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.portal;

import com.google.common.collect.Sets;
import java.awt.Point;
import java.util.Optional;
import java.util.Set;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.EndPortalBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.rituals.EternalRitual;

public class PortalBuilder {
    public static final Set<Point> FRAME_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 6), new Point(1, 0), new Point(1, 6), new Point(2, 1), new Point(2, 5), new Point(3, 2), new Point(3, 3), new Point(3, 4)});
    public static final Set<Point> PORTAL_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 1), new Point(0, 2), new Point(0, 3), new Point(0, 4), new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(1, 3), new Point(1, 4), new Point(2, 1), new Point(2, 2), new Point(2, 3)});
    private static final Set<Point> BASE_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(3, 0), new Point(2, 0), new Point(2, 1), new Point(1, 1), new Point(1, 2), new Point(0, 1), new Point(0, 2)});
    private static final Block BASE = EndBlocks.FLAVOLITE.tiles;
    public static final Block FRAME = EndBlocks.FLAVOLITE_RUNED_ETERNAL;
    public static final Block PORTAL = EndBlocks.END_PORTAL_BLOCK;
    public static int SPIRAL_SEARCH_RADIUS = 128;
    private final ServerLevel targetLevel;
    private final Level sourceLevel;

    public PortalBuilder(Level sourceLevel, ServerLevel targetLevel) {
        this.targetLevel = targetLevel;
        this.sourceLevel = sourceLevel;
    }

    public static void generatePortal(Level world, BlockPos center, Direction.Axis axis, int portalId) {
        BlockPos framePos = center.m_7495_();
        Direction moveDir = Direction.Axis.X == axis ? Direction.EAST : Direction.NORTH;
        BlockState frame = (BlockState)FRAME.m_49966_().m_61124_((Property)EternalRitual.ACTIVE, (Comparable)Boolean.valueOf(true));
        FRAME_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = framePos.m_122032_().m_122175_(moveDir, point.x).m_122175_(Direction.UP, point.y);
            world.m_46597_((BlockPos)pos, frame);
            pos = framePos.m_122032_().m_122175_(moveDir, -point.x).m_122175_(Direction.UP, point.y);
            world.m_46597_((BlockPos)pos, frame);
        });
        BlockState portal = (BlockState)((BlockState)PORTAL.m_49966_().m_61124_((Property)EndPortalBlock.f_54904_, (Comparable)axis)).m_61124_((Property)EndPortalBlock.PORTAL, (Comparable)Integer.valueOf(portalId));
        PORTAL_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = center.m_122032_().m_122175_(moveDir, point.x).m_122175_(Direction.UP, point.y);
            world.m_46597_((BlockPos)pos, portal);
            pos = center.m_122032_().m_122175_(moveDir, -point.x).m_122175_(Direction.UP, point.y);
            world.m_46597_((BlockPos)pos, portal);
        });
        PortalBuilder.generateBase(world, framePos, moveDir);
    }

    private static void generateBase(Level world, BlockPos center, Direction moveX) {
        BlockState base = BASE.m_49966_();
        Direction moveY = moveX.m_122427_();
        BASE_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = center.m_122032_().m_122175_(moveX, point.x).m_122175_(moveY, point.y);
            world.m_46597_((BlockPos)pos, base);
            pos = center.m_122032_().m_122175_(moveX, -point.x).m_122175_(moveY, point.y);
            world.m_46597_((BlockPos)pos, base);
            pos = center.m_122032_().m_122175_(moveX, point.x).m_122175_(moveY, -point.y);
            world.m_46597_((BlockPos)pos, base);
            pos = center.m_122032_().m_122175_(moveX, -point.x).m_122175_(moveY, -point.y);
            world.m_46597_((BlockPos)pos, base);
        });
    }

    public static boolean checkIsAreaValid(Level world, BlockPos pos, Direction.Axis axis) {
        if (pos.m_123342_() >= world.m_141928_() - 1) {
            return false;
        }
        if (!PortalBuilder.isBaseValid(world, pos, axis)) {
            return false;
        }
        return PortalBuilder.checkArea(world, pos, axis);
    }

    private static boolean isBaseValid(Level world, BlockPos pos, Direction.Axis axis) {
        boolean solid = true;
        if (axis.equals((Object)Direction.Axis.X)) {
            pos = pos.m_7495_().m_7918_(0, 0, -3);
            for (int i = 0; i < 7; ++i) {
                BlockPos checkPos = pos.m_7918_(0, 0, i);
                BlockState state = world.m_8055_(checkPos);
                solid &= PortalBuilder.validBlock(world, checkPos, state);
            }
        } else {
            pos = pos.m_7495_().m_7918_(-3, 0, 0);
            for (int i = 0; i < 7; ++i) {
                BlockPos checkPos = pos.m_7918_(i, 0, 0);
                BlockState state = world.m_8055_(checkPos);
                solid &= PortalBuilder.validBlock(world, checkPos, state);
            }
        }
        return solid;
    }

    private static boolean validBlock(Level world, BlockPos pos, BlockState state) {
        return state.m_60796_((BlockGetter)world, pos) && state.m_60838_((BlockGetter)world, pos);
    }

    public static boolean checkArea(Level world, BlockPos center, Direction.Axis axis) {
        Direction moveDir = Direction.Axis.X == axis ? Direction.NORTH : Direction.EAST;
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)center.m_121945_(moveDir.m_122427_()), (BlockPos)center.m_121945_(moveDir.m_122428_()))) {
            for (Point point : PORTAL_POSITIONS) {
                BlockPos.MutableBlockPos pos = checkPos.m_122032_().m_122175_(moveDir, point.x).m_122175_(Direction.UP, point.y);
                BlockState state = world.m_8055_((BlockPos)pos);
                if (PortalBuilder.isStateInvalid(state)) {
                    return false;
                }
                pos = checkPos.m_122032_().m_122175_(moveDir, -point.x).m_122175_(Direction.UP, point.y);
                state = world.m_8055_((BlockPos)pos);
                if (!PortalBuilder.isStateInvalid(state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isStateInvalid(BlockState state) {
        if (!state.m_60819_().m_76178_()) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((BlockState)state) == false;
    }

    public Optional<BlockUtil.FoundRectangle> findPortalAround(BlockPos blockPos, WorldBorder worldBorder) {
        PoiManager poiManager = this.targetLevel.m_8904_();
        poiManager.m_27056_((LevelReader)this.targetLevel, blockPos, SPIRAL_SEARCH_RADIUS);
        Optional oPos = EndPoiTypes.ETERNAL_PORTAL.findPoiAround(this.targetLevel, blockPos, SPIRAL_SEARCH_RADIUS, worldBorder);
        return oPos.map(poiPos -> {
            this.targetLevel.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(poiPos), 3, poiPos);
            BlockState blockState = this.targetLevel.m_8055_(poiPos);
            return BlockUtil.m_124334_((BlockPos)poiPos, (Direction.Axis)((Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, bp -> this.targetLevel.m_8055_(bp) == blockState);
        });
    }

    public static BlockPos getStartingPos(Level sourceLevel, Level targetLevel, Entity entity, WorldBorder worldBorder) {
        double dimensionScale = DimensionType.m_63908_((DimensionType)sourceLevel.m_6042_(), (DimensionType)targetLevel.m_6042_());
        return worldBorder.m_187569_(entity.m_20185_() * dimensionScale, entity.m_20186_(), entity.m_20189_() * dimensionScale);
    }

    public Optional<BlockPos> createPortal(BlockPos startPosition, Direction.Axis axis, int portalID) {
        Direction portalDirection = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d = -1.0;
        BlockPos centerPos = null;
        double e = -1.0;
        BlockPos blockPos3 = null;
        WorldBorder worldBorder = this.targetLevel.m_6857_();
        int maxHeight = Math.min(this.targetLevel.m_151558_(), this.targetLevel.m_141937_() + this.targetLevel.m_143344_()) - 1;
        BlockPos.MutableBlockPos currentPos = startPosition.m_122032_();
        for (BlockPos.MutableBlockPos testPosition : BlockPos.m_121935_((BlockPos)startPosition, (int)SPIRAL_SEARCH_RADIUS, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int levelHeight = Math.min(maxHeight, this.targetLevel.m_6924_(Heightmap.Types.MOTION_BLOCKING, testPosition.m_123341_(), testPosition.m_123343_()));
            if (!worldBorder.m_61937_((BlockPos)testPosition) || !worldBorder.m_61937_((BlockPos)testPosition.m_122175_(portalDirection, 1))) continue;
            testPosition.m_122175_(portalDirection.m_122424_(), 1);
            for (int yy = levelHeight; yy >= this.targetLevel.m_141937_(); --yy) {
                int n;
                testPosition.m_142448_(yy);
                if (!this.canPortalReplaceBlock((BlockPos)testPosition)) continue;
                int startY = yy;
                while (yy > this.targetLevel.m_141937_() && this.canPortalReplaceBlock((BlockPos)testPosition.m_122173_(Direction.DOWN))) {
                    --yy;
                }
                if (yy + 4 > maxHeight || (n = startY - yy) > 0 && n < 3) continue;
                testPosition.m_142448_(yy);
                if (!this.canHostFrame((BlockPos)testPosition, currentPos, portalDirection, 0)) continue;
                double f = startPosition.m_123331_((Vec3i)testPosition);
                if (this.canHostFrame((BlockPos)testPosition, currentPos, portalDirection, -1) && this.canHostFrame((BlockPos)testPosition, currentPos, portalDirection, 1) && (d == -1.0 || d > f)) {
                    d = f;
                    centerPos = testPosition.m_7949_();
                }
                if (d != -1.0 || e != -1.0 && !(e > f)) continue;
                e = f;
                blockPos3 = testPosition.m_7949_();
            }
        }
        if (d == -1.0 && e != -1.0) {
            centerPos = blockPos3;
            d = e;
        }
        if (d == -1.0) {
            int p = maxHeight - 9;
            int o = Math.max(this.targetLevel.m_141937_() - -1, 70);
            if (p < o) {
                return Optional.empty();
            }
            centerPos = new BlockPos(startPosition.m_123341_(), Mth.m_14045_((int)startPosition.m_123342_(), (int)o, (int)p), startPosition.m_123343_()).m_7949_();
            if (!worldBorder.m_61937_(centerPos)) {
                return Optional.empty();
            }
        }
        this.buildPortal(portalDirection, centerPos, portalID);
        return Optional.of(centerPos.m_7949_());
    }

    private void buildPortal(Direction portalDirection, BlockPos centerPos, int portalID) {
        Direction.Axis portalAxis = Direction.Axis.X == portalDirection.m_122434_() ? Direction.Axis.Z : Direction.Axis.X;
        PortalBuilder.generatePortal((Level)this.targetLevel, centerPos, portalAxis, portalID);
    }

    private int getPortalID(BlockPos portalEntrancePos) {
        BlockState currentState = this.sourceLevel.m_8055_(portalEntrancePos);
        int portalID = currentState.m_61138_((Property)EndPortalBlock.PORTAL) ? (Integer)currentState.m_61143_((Property)EndPortalBlock.PORTAL) : -1;
        return portalID;
    }

    private boolean canPortalReplaceBlock(BlockPos currentPos) {
        BlockState blockState = this.targetLevel.m_8055_(currentPos);
        return blockState.m_247087_() && blockState.m_60819_().m_76178_();
    }

    private boolean canHostFrame(BlockPos pos, BlockPos.MutableBlockPos currentPos, Direction direction, int widthScale) {
        Direction orthogonalDir = direction.m_122427_();
        for (int x = -1; x < 3; ++x) {
            for (int y = -1; y < 4; ++y) {
                currentPos.m_122154_((Vec3i)pos, direction.m_122429_() * x + orthogonalDir.m_122429_() * widthScale, y, direction.m_122431_() * x + orthogonalDir.m_122431_() * widthScale);
                if (y < 0 && !this.targetLevel.m_8055_((BlockPos)currentPos).m_280296_()) {
                    return false;
                }
                if (y < 0 || this.canPortalReplaceBlock((BlockPos)currentPos)) continue;
                return false;
            }
        }
        return true;
    }
}

