/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.worlds.together.world.WorldConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpikeFeature.class})
public class SpikeFeatureMixin {
    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_place(FeaturePlaceContext<SpikeConfiguration> featurePlaceContext, CallbackInfoReturnable<Boolean> info) {
        if (!GeneratorOptions.hasPillars()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"placeSpike"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_placeSpike(ServerLevelAccessor world, RandomSource random, SpikeConfiguration config, SpikeFeature.EndSpike spike, CallbackInfo info) {
        int x = spike.m_66886_();
        int z = spike.m_66893_();
        int radius = spike.m_66896_();
        int minY = 0;
        long lx = x;
        long lz = z;
        if (lx * lx + lz * lz < 10000L) {
            String pillarID = String.format("%d_%d", x, z);
            CompoundTag pillar = WorldConfig.getCompoundTag((String)"betterend", (String)"pillars");
            boolean haveValue = pillar.m_128441_(pillarID);
            int n = minY = haveValue ? pillar.m_128451_(pillarID) : world.m_6325_(x >> 4, z >> 4).m_5885_(Heightmap.Types.WORLD_SURFACE, x & 0xF, z);
            if (!haveValue) {
                pillar.m_128405_(pillarID, minY);
                WorldConfig.saveFile((String)"betterend");
            }
        } else {
            minY = world.m_6325_(x >> 4, z >> 4).m_5885_(Heightmap.Types.WORLD_SURFACE, x & 0xF, z);
        }
        GeneratorOptions.setDirectSpikeHeight();
        int maxY = minY + spike.m_66899_() - 64;
        if (GeneratorOptions.replacePillars() && this.be_radiusInRange(radius)) {
            StructureTemplate base = StructureHelper.readStructure((ResourceLocation)BetterEnd.makeID("pillars/pillar_base_" + --radius));
            StructureTemplate top = StructureHelper.readStructure((ResourceLocation)BetterEnd.makeID("pillars/pillar_top_" + radius + (spike.m_66902_() ? "_cage" : "")));
            Vec3i side = base.m_163801_();
            BlockPos pos1 = new BlockPos(x - (side.m_123341_() >> 1), minY - 3, z - (side.m_123343_() >> 1));
            minY = pos1.m_123342_() + side.m_123342_();
            side = top.m_163801_();
            BlockPos pos2 = new BlockPos(x - (side.m_123341_() >> 1), maxY, z - (side.m_123343_() >> 1));
            maxY = pos2.m_123342_();
            StructurePlaceSettings data = new StructurePlaceSettings();
            base.m_230328_(world, pos1, pos1, data, random, 2);
            top.m_230328_(world, pos2, pos2, data, random, 2);
            int r2 = radius * radius + 1;
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            for (int px = -radius; px <= radius; ++px) {
                mut.m_142451_(x + px);
                int x2 = px * px;
                for (int pz = -radius; pz <= radius; ++pz) {
                    mut.m_142443_(z + pz);
                    int z2 = pz * pz;
                    if (x2 + z2 > r2) continue;
                    for (int py = minY; py < maxY; ++py) {
                        mut.m_142448_(py);
                        if (!world.m_8055_((BlockPos)mut).m_247087_()) continue;
                        if ((px == radius || px == -radius || pz == radius || pz == -radius) && random.m_188503_(24) == 0) {
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.f_50723_);
                            continue;
                        }
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.f_50080_);
                    }
                }
            }
        } else {
            minY -= 15;
            int r2 = radius * radius + 1;
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            for (int px = -radius; px <= radius; ++px) {
                mut.m_142451_(x + px);
                int x2 = px * px;
                for (int pz = -radius; pz <= radius; ++pz) {
                    mut.m_142443_(z + pz);
                    int z2 = pz * pz;
                    if (x2 + z2 > r2) continue;
                    for (int py = minY; py < maxY; ++py) {
                        mut.m_142448_(py);
                        if (!world.m_8055_((BlockPos)mut).m_247087_()) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.f_50080_);
                    }
                }
            }
            mut.m_142451_(x);
            mut.m_142443_(z);
            mut.m_142448_(maxY);
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)Blocks.f_50752_);
            EndCrystal crystal = (EndCrystal)EntityType.f_20564_.m_20615_((Level)world.m_6018_());
            crystal.m_31052_(config.m_68122_());
            crystal.m_20331_(config.m_68116_());
            crystal.m_7678_((double)x + 0.5, (double)(maxY + 1), (double)z + 0.5, random.m_188501_() * 360.0f, 0.0f);
            world.m_7967_((Entity)crystal);
            if (spike.m_66902_()) {
                for (int px = -2; px <= 2; ++px) {
                    boolean bl = Mth.m_14040_((int)px) == 2;
                    for (int pz = -2; pz <= 2; ++pz) {
                        boolean bl2 = Mth.m_14040_((int)pz) == 2;
                        for (int py = 0; py <= 3; ++py) {
                            boolean bl3;
                            boolean bl4 = bl3 = py == 3;
                            if (!bl && !bl2 && !bl3) continue;
                            boolean bl42 = px == -2 || px == 2 || bl3;
                            boolean bl5 = pz == -2 || pz == 2 || bl3;
                            BlockState blockState = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50183_.m_49966_().m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)Boolean.valueOf(bl42 && pz != -2))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)Boolean.valueOf(bl42 && pz != 2))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)Boolean.valueOf(bl5 && px != -2))).m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)Boolean.valueOf(bl5 && px != 2));
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut.m_122178_(spike.m_66886_() + px, maxY + py, spike.m_66893_() + pz), (BlockState)blockState);
                        }
                    }
                }
            }
        }
        info.cancel();
    }

    private boolean be_radiusInRange(int radius) {
        return radius > 1 && radius < 6;
    }
}

