/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.util.StructureHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.worlds.together.world.WorldConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EndPodiumFeature.class})
public class EndPodiumFeatureMixin {
    private static BlockPos be_portalPosition;
    @Final
    @Shadow
    private boolean f_65715_;

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private void be_place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext, CallbackInfoReturnable<Boolean> info) {
        if (!GeneratorOptions.hasPortal()) {
            info.setReturnValue((Object)false);
            info.cancel();
        } else if (GeneratorOptions.replacePortal()) {
            RandomSource random = featurePlaceContext.m_225041_();
            WorldGenLevel world = featurePlaceContext.m_159774_();
            BlockPos blockPos = this.be_updatePortalPos(world);
            StructureTemplate structure = StructureHelper.readStructure((ResourceLocation)BetterEnd.makeID(this.f_65715_ ? "portal/end_portal_active" : "portal/end_portal_inactive"));
            Vec3i size = structure.m_163801_();
            blockPos = blockPos.m_7918_(-(size.m_123341_() >> 1), -3, -(size.m_123343_() >> 1));
            structure.m_230328_((ServerLevelAccessor)world, blockPos, blockPos, new StructurePlaceSettings(), random, 2);
            info.setReturnValue((Object)true);
            info.cancel();
        }
    }

    @ModifyVariable(method={"place"}, ordinal=0, at=@At(value="HEAD"))
    private FeaturePlaceContext<NoneFeatureConfiguration> be_setPosOnGround(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        BlockPos pos = this.be_updatePortalPos(world);
        return new FeaturePlaceContext(Optional.empty(), world, featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), pos, (FeatureConfiguration)((NoneFeatureConfiguration)featurePlaceContext.m_159778_()));
    }

    private BlockPos be_updatePortalPos(WorldGenLevel world) {
        CompoundTag compound = WorldConfig.getRootTag((String)"betterend").m_128469_("portal");
        be_portalPosition = NbtUtils.m_129239_((CompoundTag)compound);
        if (be_portalPosition.m_123342_() == 0) {
            int y = world.m_6924_(Heightmap.Types.WORLD_SURFACE, 0, 0);
            be_portalPosition = new BlockPos(0, y, 0);
            WorldConfig.getRootTag((String)"betterend").m_128365_("portal", (Tag)NbtUtils.m_129224_((BlockPos)be_portalPosition));
            WorldConfig.saveFile((String)"betterend");
        }
        return be_portalPosition;
    }
}

