/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.betterx.bclib.client.render.HumanoidArmorRenderer;
import org.betterx.betterend.registry.EndEntitiesRenders;

public class CrystaliteChestplateModel
extends HumanoidModel<LivingEntity>
implements HumanoidArmorRenderer.CopyExtraState {
    public ModelPart leftShoulder;
    public ModelPart rightShoulder;
    private final boolean thinArms;
    final ModelPart localBody;

    public static LayerDefinition getRegularTexturedModelData() {
        return CrystaliteChestplateModel.getTexturedModelData(1.0f, false);
    }

    public static LayerDefinition getThinTexturedModelData() {
        return CrystaliteChestplateModel.getTexturedModelData(1.0f, true);
    }

    private static LayerDefinition getTexturedModelData(float scale, boolean thinArms) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        modelPartData.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        CubeDeformation deformation = new CubeDeformation(scale + 0.25f);
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.f_171404_);
        if (thinArms) {
            deformation = new CubeDeformation(scale + 0.45f);
            PartDefinition leftShoulder = modelPartData.m_171599_("leftShoulder", CubeListBuilder.m_171558_().m_171480_().m_171514_(40, 32).m_171488_(-1.0f, -2.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            PartDefinition partDefinition = modelPartData.m_171599_("rightShoulder", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)10.0f));
        } else {
            deformation = new CubeDeformation(scale + 0.45f);
            PartDefinition leftShoulder = modelPartData.m_171599_("leftShoulder", CubeListBuilder.m_171558_().m_171480_().m_171514_(40, 32).m_171488_(-1.0f, -2.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
            PartDefinition partDefinition = modelPartData.m_171599_("rightShoulder", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.5f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)10.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)48);
    }

    public static CrystaliteChestplateModel createRegularModel(EntityModelSet entityModelSet) {
        return new CrystaliteChestplateModel(entityModelSet == null ? CrystaliteChestplateModel.getRegularTexturedModelData().m_171564_() : entityModelSet.m_171103_(EndEntitiesRenders.CRYSTALITE_CHESTPLATE), false);
    }

    public static CrystaliteChestplateModel createThinModel(EntityModelSet entityModelSet) {
        return new CrystaliteChestplateModel(entityModelSet == null ? CrystaliteChestplateModel.getThinTexturedModelData().m_171564_() : entityModelSet.m_171103_(EndEntitiesRenders.CRYSTALITE_CHESTPLATE_THIN), true);
    }

    protected CrystaliteChestplateModel(ModelPart modelPart, boolean thinArms) {
        super(modelPart, RenderType::m_110473_);
        this.thinArms = thinArms;
        this.localBody = modelPart.m_171324_("body");
        this.leftShoulder = modelPart.m_171324_("leftShoulder");
        this.rightShoulder = modelPart.m_171324_("rightShoulder");
    }

    public void copyPropertiesFrom(HumanoidModel<LivingEntity> parentModel) {
        this.leftShoulder.m_104315_(this.f_102812_);
        this.rightShoulder.m_104315_(this.f_102811_);
    }

    protected Iterable<ModelPart> m_5607_() {
        return Collections::emptyIterator;
    }

    protected Iterable<ModelPart> m_5608_() {
        return Lists.newArrayList((Object[])new ModelPart[]{this.localBody, this.leftShoulder, this.rightShoulder});
    }

    public void m_6002_(HumanoidArm arm, PoseStack matrices) {
        ModelPart modelPart = this.m_102851_(arm);
        if (this.thinArms) {
            float f = 0.5f * (float)(arm == HumanoidArm.RIGHT ? 1 : -1);
            modelPart.f_104200_ += f;
            modelPart.m_104299_(matrices);
            modelPart.f_104200_ -= f;
        } else {
            modelPart.m_104299_(matrices);
        }
    }
}

