/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.rei;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.betterx.betterend.integration.rei.REIAlloyingFuelDisplay;
import org.betterx.betterend.integration.rei.REIPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class REIAlloyingFuelCategory
implements DisplayCategory<REIAlloyingFuelDisplay> {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    @NotNull
    public CategoryIdentifier getCategoryIdentifier() {
        return REIPlugin.ALLOYING_FUEL;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"category.rei.fuel");
    }

    public int getDisplayHeight() {
        return 49;
    }

    @NotNull
    public EntryStack getIcon() {
        return EntryStacks.of((ItemLike)Items.f_42448_);
    }

    public List<Widget> setupDisplay(REIAlloyingFuelDisplay recipeDisplay, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 17);
        String burnTime = DECIMAL_FORMAT.format(recipeDisplay.getFuelTime());
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + 26, bounds.getMaxY() - 15), (Component)Component.m_237110_((String)"category.rei.fuel.time", (Object[])new Object[]{burnTime})).color(-12566464, -4473925).noShadow().leftAligned());
        widgets.add(Widgets.createBurningFire((Point)new Point(bounds.x + 6, startPoint.y + 1)).animationDurationTicks((double)recipeDisplay.getFuelTime()));
        widgets.add(Widgets.createSlot((Point)new Point(bounds.x + 6, startPoint.y + 18)).entries((Collection)recipeDisplay.getInputEntries().get(0)).markInput());
        return widgets;
    }

    public DisplayRenderer getDisplayRenderer(REIAlloyingFuelDisplay recipe) {
        final Slot slot = Widgets.createSlot((Point)new Point(0, 0)).entries((Collection)recipe.getInputEntries().get(0)).disableBackground().disableHighlight();
        final String burnItems = DECIMAL_FORMAT.format((double)recipe.getFuelTime() / 200.0);
        return new DisplayRenderer(){
            private final Component text;
            {
                this.text = Component.m_237110_((String)"category.rei.fuel.time_short.items", (Object[])new Object[]{burnItems});
            }

            public int getHeight() {
                return 22;
            }

            @Nullable
            public Tooltip getTooltip(TooltipContext ctx) {
                if (slot.containsMouse(ctx.getPoint())) {
                    return slot.getCurrentTooltip(ctx);
                }
                return null;
            }

            public void render(GuiGraphics guiGraphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                slot.getBounds().setLocation(bounds.x + 4, bounds.y + 2);
                slot.m_88315_(guiGraphics, mouseX, mouseY, delta);
                guiGraphics.m_280648_(Minecraft.m_91087_().f_91062_, this.text.m_7532_(), bounds.x + 25, bounds.y + 8, -1);
            }
        };
    }
}

