/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.entity.EndSlimeEntity;
import org.betterx.betterend.entity.model.EndSlimeEntityModel;

public class RendererEntityEndSlime
extends MobRenderer<EndSlimeEntity, EndSlimeEntityModel<EndSlimeEntity>> {
    private static final ResourceLocation[] TEXTURE = new ResourceLocation[4];
    private static final RenderType[] GLOW = new RenderType[4];

    public RendererEntityEndSlime(EntityRendererProvider.Context ctx) {
        super(ctx, new EndSlimeEntityModel(ctx.m_174027_(), false), 0.25f);
        this.m_115326_(new OverlayFeatureRenderer(this, ctx));
        this.m_115326_((RenderLayer)new EyesLayer<EndSlimeEntity, EndSlimeEntityModel<EndSlimeEntity>>((RenderLayerParent)this){

            public RenderType m_5708_() {
                return GLOW[0];
            }

            public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, EndSlimeEntity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
                VertexConsumer vertexConsumer = vertexConsumers.m_6299_(GLOW[entity.getSlimeType()]);
                ((EndSlimeEntityModel)this.m_117386_()).m_7695_(matrices, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                if (entity.isLake()) {
                    ((EndSlimeEntityModel)this.m_117386_()).renderFlower(matrices, vertexConsumer, 0xF00000, OverlayTexture.f_118083_);
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(EndSlimeEntity entity) {
        return TEXTURE[entity.getSlimeType()];
    }

    public void render(EndSlimeEntity slimeEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        this.f_114477_ = 0.25f * (float)slimeEntity.m_33632_();
        super.m_7392_((Mob)slimeEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    protected void scale(EndSlimeEntity slimeEntity, PoseStack matrixStack, float f) {
        matrixStack.m_85841_(0.999f, 0.999f, 0.999f);
        matrixStack.m_85837_(0.0, (double)0.001f, 0.0);
        float h = slimeEntity.m_33632_();
        float i = Mth.m_14179_((float)f, (float)slimeEntity.f_33585_, (float)slimeEntity.f_33584_) / (h * 0.5f + 1.0f);
        float j = 1.0f / (i + 1.0f);
        matrixStack.m_85841_(j * h, 1.0f / j * h, j * h);
    }

    static {
        RendererEntityEndSlime.TEXTURE[0] = BetterEnd.makeID("textures/entity/end_slime/end_slime.png");
        RendererEntityEndSlime.TEXTURE[1] = BetterEnd.makeID("textures/entity/end_slime/end_slime_mossy.png");
        RendererEntityEndSlime.TEXTURE[2] = BetterEnd.makeID("textures/entity/end_slime/end_slime_lake.png");
        RendererEntityEndSlime.TEXTURE[3] = BetterEnd.makeID("textures/entity/end_slime/end_slime_amber.png");
        RendererEntityEndSlime.GLOW[0] = RenderType.m_110488_((ResourceLocation)BetterEnd.makeID("textures/entity/end_slime/end_slime_glow.png"));
        RendererEntityEndSlime.GLOW[1] = GLOW[0];
        RendererEntityEndSlime.GLOW[2] = RenderType.m_110488_((ResourceLocation)BetterEnd.makeID("textures/entity/end_slime/end_slime_lake_glow.png"));
        RendererEntityEndSlime.GLOW[3] = RenderType.m_110488_((ResourceLocation)BetterEnd.makeID("textures/entity/end_slime/end_slime_amber_glow.png"));
    }

    private final class OverlayFeatureRenderer<T extends EndSlimeEntity>
    extends RenderLayer<T, EndSlimeEntityModel<T>> {
        private final EndSlimeEntityModel<T> modelOrdinal;
        private final EndSlimeEntityModel<T> modelLake;

        public OverlayFeatureRenderer(RenderLayerParent<T, EndSlimeEntityModel<T>> featureRendererContext, EntityRendererProvider.Context ctx) {
            super(featureRendererContext);
            this.modelOrdinal = new EndSlimeEntityModel(ctx.m_174027_(), true);
            this.modelLake = new EndSlimeEntityModel(ctx.m_174027_(), true);
        }

        public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
            if (!livingEntity.m_20145_()) {
                if (((EndSlimeEntity)((Object)livingEntity)).isLake()) {
                    vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110452_((ResourceLocation)this.m_117347_((Entity)livingEntity)));
                    ((EndSlimeEntityModel)this.m_117386_()).renderFlower(matrixStack, vertexConsumer, i, LivingEntityRenderer.m_115338_(livingEntity, (float)0.0f));
                } else if (((EndSlimeEntity)((Object)livingEntity)).isAmber() || ((EndSlimeEntity)((Object)livingEntity)).isChorus()) {
                    vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110452_((ResourceLocation)this.m_117347_((Entity)livingEntity)));
                    ((EndSlimeEntityModel)this.m_117386_()).renderCrop(matrixStack, vertexConsumer, i, LivingEntityRenderer.m_115338_(livingEntity, (float)0.0f));
                }
                EndSlimeEntityModel<T> model = ((EndSlimeEntity)((Object)livingEntity)).getSlimeType() == 1 ? this.modelLake : this.modelOrdinal;
                ((EndSlimeEntityModel)this.m_117386_()).m_102624_((EntityModel)model);
                model.m_6839_((Entity)livingEntity, f, g, h);
                model.setupAnim(livingEntity, f, g, j, k, l);
                VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110473_((ResourceLocation)this.m_117347_((Entity)livingEntity)));
                model.m_7695_(matrixStack, vertexConsumer, i, LivingEntityRenderer.m_115338_(livingEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

