/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.entity.DespawnableAnimal;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndSounds;

public class DragonflyEntity
extends DespawnableAnimal
implements FlyingAnimal {
    public DragonflyEntity(EntityType<DragonflyEntity> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_21365_ = new DragonflyLookControl((Mob)this);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.f_21364_ = 1;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22279_, 0.1);
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world){

            public boolean m_6342_(BlockPos pos) {
                BlockState state = this.f_26495_.m_8055_(pos);
                return state.m_60795_() || !state.m_280555_();
            }

            public void m_7638_() {
                super.m_7638_();
            }
        };
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26443_(true);
        return birdNavigation;
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return world.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WanderAroundGoal());
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public boolean m_20068_() {
        return true;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)EndSounds.ENTITY_DRAGONFLY.m_203334_();
    }

    protected float m_6121_() {
        return MHelper.randRange((float)0.25f, (float)0.5f, (RandomSource)this.f_19796_);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)EndEntities.DRAGONFLY.type().m_20615_((Level)world);
    }

    class DragonflyLookControl
    extends LookControl {
        DragonflyLookControl(Mob entity) {
            super(entity);
        }

        protected boolean m_8106_() {
            return true;
        }
    }

    class WanderAroundGoal
    extends Goal {
        WanderAroundGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return DragonflyEntity.this.f_21344_.m_26571_() && DragonflyEntity.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return DragonflyEntity.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3d = this.getRandomLocation();
            if (vec3d != null) {
                BlockPos pos = new BlockPos((int)vec3d.f_82479_, (int)vec3d.f_82480_, (int)vec3d.f_82481_);
                try {
                    Path path = DragonflyEntity.this.f_21344_.m_7864_(pos, 1);
                    if (path != null) {
                        DragonflyEntity.this.f_21344_.m_26536_(path, 1.0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            super.m_8056_();
        }

        private Vec3 getRandomLocation() {
            int h = BlocksHelper.downRay((LevelAccessor)DragonflyEntity.this.m_9236_(), (BlockPos)DragonflyEntity.this.m_20183_(), (int)16);
            Vec3 rotation = DragonflyEntity.this.m_20252_(0.0f);
            Vec3 airPos = HoverRandomPos.m_148465_((PathfinderMob)DragonflyEntity.this, (int)8, (int)7, (double)rotation.f_82479_, (double)rotation.f_82481_, (float)1.5707964f, (int)3, (int)1);
            if (airPos != null) {
                if (this.isInVoid(airPos)) {
                    for (int i = 0; i < 8; ++i) {
                        airPos = HoverRandomPos.m_148465_((PathfinderMob)DragonflyEntity.this, (int)16, (int)7, (double)rotation.f_82479_, (double)rotation.f_82481_, (float)((float)Math.PI * 2), (int)3, (int)1);
                        if (airPos == null || this.isInVoid(airPos)) continue;
                        return airPos;
                    }
                    return null;
                }
                if (h > 5 && airPos.m_7098_() >= (double)DragonflyEntity.this.m_20183_().m_123342_()) {
                    airPos = new Vec3(airPos.f_82479_, airPos.f_82480_ - (double)h * 0.5, airPos.f_82481_);
                }
                return airPos;
            }
            return AirAndWaterRandomPos.m_148357_((PathfinderMob)DragonflyEntity.this, (int)8, (int)4, (int)-2, (double)rotation.f_82479_, (double)rotation.f_82481_, (double)1.5707963705062866);
        }

        private boolean isInVoid(Vec3 pos) {
            int h = BlocksHelper.downRay((LevelAccessor)DragonflyEntity.this.m_9236_(), (BlockPos)new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), (int)128);
            return h > 100;
        }
    }
}

