/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndItems;

public class CubozoaEntity
extends AbstractSchoolingFish {
    public static final int VARIANTS = 2;
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(CubozoaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> SCALE = SynchedEntityData.m_135353_(CubozoaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public CubozoaEntity(EntityType<CubozoaEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData, CompoundTag entityTag) {
        SpawnGroupData data = super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
        BCLBiome biome = BiomeAPI.getBiome((Holder)world.m_204166_(this.m_20183_()));
        if (!BCLBiomeRegistry.isEmptyBiome((BCLBiome)biome) && biome.is(EndBiomes.SULPHUR_SPRINGS)) {
            this.f_19804_.m_135381_(VARIANT, (Object)1);
        }
        if (entityTag != null) {
            if (entityTag.m_128441_("Variant")) {
                this.f_19804_.m_135381_(VARIANT, (Object)entityTag.m_128445_("Variant"));
            }
            if (entityTag.m_128441_("Scale")) {
                this.f_19804_.m_135381_(SCALE, (Object)entityTag.m_128445_("Scale"));
            }
        }
        this.m_6210_();
        return data;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(SCALE, (Object)((byte)this.m_217043_().m_188503_(16)));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Variant", (byte)this.getVariant());
        tag.m_128344_("Scale", this.getByteScale());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.f_19804_.m_135381_(VARIANT, (Object)tag.m_128445_("Variant"));
        }
        if (tag.m_128441_("Scale")) {
            this.f_19804_.m_135381_(SCALE, (Object)tag.m_128445_("Scale"));
        }
    }

    public ItemStack m_28282_() {
        ItemStack bucket = EndItems.BUCKET_CUBOZOA.m_7968_();
        CompoundTag tag = bucket.m_41784_();
        tag.m_128344_("Variant", ((Byte)this.f_19804_.m_135370_(VARIANT)).byteValue());
        tag.m_128344_("Scale", ((Byte)this.f_19804_.m_135370_(SCALE)).byteValue());
        return bucket;
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.5);
    }

    public int getVariant() {
        return ((Byte)this.f_19804_.m_135370_(VARIANT)).byteValue();
    }

    public byte getByteScale() {
        return (Byte)this.f_19804_.m_135370_(SCALE);
    }

    public float m_6134_() {
        return (float)this.getByteScale() / 32.0f + 0.75f;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }

    protected void m_7625_(DamageSource source, boolean causedByPlayer) {
        int count = this.f_19796_.m_188503_(3);
        if (count > 0) {
            ItemEntity drop = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)EndItems.GELATINE, count));
            this.m_9236_().m_7967_((Entity)drop);
        }
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12329_;
    }

    public void m_6123_(Player player) {
        if (player instanceof ServerPlayer && player.m_6469_(player.m_269291_().m_269333_((LivingEntity)this), 0.5f)) {
            if (!this.m_20067_()) {
                ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132162_, 0.0f));
            }
            if (this.f_19796_.m_188499_()) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 20, 0));
            }
        }
    }
}

