/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.complexmaterials;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.blocks.BaseBarsBlock;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.blocks.BaseChainBlock;
import org.betterx.bclib.blocks.BaseDoorBlock;
import org.betterx.bclib.blocks.BaseOreBlock;
import org.betterx.bclib.blocks.BasePressurePlateBlock;
import org.betterx.bclib.blocks.BaseSlabBlock;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.bclib.blocks.BaseTrapdoorBlock;
import org.betterx.bclib.items.ModelProviderItem;
import org.betterx.bclib.items.tool.BaseAxeItem;
import org.betterx.bclib.items.tool.BaseHoeItem;
import org.betterx.bclib.items.tool.BaseShovelItem;
import org.betterx.bclib.items.tool.BaseSwordItem;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.recipes.CookingRecipeBuilder;
import org.betterx.bclib.recipes.SmithingRecipeBuilder;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.BulbVineLanternBlock;
import org.betterx.betterend.blocks.BulbVineLanternColoredBlock;
import org.betterx.betterend.blocks.ChandelierBlock;
import org.betterx.betterend.blocks.basis.EndAnvilBlock;
import org.betterx.betterend.complexmaterials.ColoredMaterial;
import org.betterx.betterend.item.EndArmorItem;
import org.betterx.betterend.item.tool.EndHammerItem;
import org.betterx.betterend.item.tool.EndPickaxe;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.betterend.registry.EndTemplates;
import org.betterx.worlds.together.tag.v3.TagManager;

public class MetalMaterial {
    public final Block ore;
    public final Block block;
    public final Block tile;
    public final Block bars;
    public final Block pressurePlate;
    public final Block door;
    public final Block trapdoor;
    public final Block chain;
    public final Block stairs;
    public final Block slab;
    public final Block chandelier;
    public final Block bulb_lantern;
    public final ColoredMaterial bulb_lantern_colored;
    public final Block anvilBlock;
    public final Item rawOre;
    public final Item nugget;
    public final Item ingot;
    public final Item shovelHead;
    public final Item pickaxeHead;
    public final Item axeHead;
    public final Item hoeHead;
    public final Item swordBlade;
    public final Item swordHandle;
    public final Item shovel;
    public final Item sword;
    public final Item pickaxe;
    public final Item axe;
    public final Item hoe;
    public final Item hammer;
    public final Item forgedPlate;
    public final Item helmet;
    public final Item chestplate;
    public final Item leggings;
    public final Item boots;
    public final TagKey<Item> alloyingOre;
    public final SmithingTemplateItem swordHandleTemplate;
    public final String name;

    public static MetalMaterial makeNormal(String name, MapColor color, Tier material, ArmorMaterial armor, int anvilAndToolLevel, SmithingTemplateItem swordHandleTemplate) {
        return new MetalMaterial(name, true, FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50075_).mapColor(color), EndItems.makeEndItemSettings(), material, armor, anvilAndToolLevel, swordHandleTemplate);
    }

    public static MetalMaterial makeNormal(String name, MapColor color, float hardness, float resistance, Tier material, ArmorMaterial armor, int anvilAndToolLevel, SmithingTemplateItem swordHandleTemplate) {
        return new MetalMaterial(name, true, FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50075_).mapColor(color).hardness(hardness).resistance(resistance), EndItems.makeEndItemSettings(), material, armor, anvilAndToolLevel, swordHandleTemplate);
    }

    public static MetalMaterial makeOreless(String name, MapColor color, Tier material, ArmorMaterial armor, int anvilAndToolLevel, SmithingTemplateItem swordHandleTemplate) {
        return new MetalMaterial(name, false, FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50075_).mapColor(color), EndItems.makeEndItemSettings(), material, armor, anvilAndToolLevel, swordHandleTemplate);
    }

    public static MetalMaterial makeOreless(String name, MapColor color, float hardness, float resistance, Tier material, ArmorMaterial armor, int anvilAndToolLevel, SmithingTemplateItem swordHandleTemplate) {
        return new MetalMaterial(name, false, FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50075_).mapColor(color).hardness(hardness).resistance(resistance), EndItems.makeEndItemSettings(), material, armor, anvilAndToolLevel, swordHandleTemplate);
    }

    private MetalMaterial(String name, boolean hasOre, FabricBlockSettings settings, Item.Properties itemSettings, Tier material, ArmorMaterial armor, int anvilAndToolLevel, SmithingTemplateItem swordHandleTemplate) {
        BlockBehaviour.Properties lanternProperties = FabricBlockSettings.copyOf((BlockBehaviour.Properties)settings).hardness(1.0f).resistance(1.0f).lightLevel(bs -> 15).m_60918_(SoundType.f_56762_);
        int level = material.m_6604_();
        this.name = name;
        this.swordHandleTemplate = swordHandleTemplate;
        this.rawOre = hasOre ? EndItems.registerEndItem(name + "_raw", (Item)new ModelProviderItem(itemSettings)) : null;
        this.ore = hasOre ? EndBlocks.registerBlock(name + "_ore", (Block)new BaseOreBlock(() -> this.rawOre, 1, 3, 1), new TagKey[0]) : null;
        TagKey<Item> tagKey = this.alloyingOre = hasOre ? TagManager.ITEMS.makeTag("betterend", name + "_alloying") : null;
        if (hasOre) {
            TagManager.ITEMS.add(this.alloyingOre, (Object[])new Item[]{this.ore.m_5456_(), this.rawOre});
        }
        this.block = EndBlocks.registerBlock(name + "_block", (Block)new BaseBlock.Metal((BlockBehaviour.Properties)settings), new TagKey[0]);
        this.tile = EndBlocks.registerBlock(name + "_tile", (Block)new BaseBlock.Metal((BlockBehaviour.Properties)settings), new TagKey[0]);
        this.stairs = EndBlocks.registerBlock(name + "_stairs", (Block)new BaseStairsBlock.Metal(this.tile), new TagKey[0]);
        this.slab = EndBlocks.registerBlock(name + "_slab", (Block)new BaseSlabBlock.Metal(this.tile), new TagKey[0]);
        this.door = EndBlocks.registerBlock(name + "_door", (Block)new BaseDoorBlock.Metal(this.block, BlockSetType.f_271132_), new TagKey[0]);
        this.trapdoor = EndBlocks.registerBlock(name + "_trapdoor", (Block)new BaseTrapdoorBlock.Metal(this.block, BlockSetType.f_271132_), new TagKey[0]);
        this.bars = EndBlocks.registerBlock(name + "_bars", (Block)new BaseBarsBlock.Metal(this.block), new TagKey[0]);
        this.chain = EndBlocks.registerBlock(name + "_chain", (Block)new BaseChainBlock.Metal(this.block.m_284356_()), new TagKey[0]);
        this.pressurePlate = EndBlocks.registerBlock(name + "_plate", (Block)new BasePressurePlateBlock.Wood(this.block, BlockSetType.f_271132_), new TagKey[0]);
        this.chandelier = EndBlocks.registerBlock(name + "_chandelier", (Block)new ChandelierBlock(this.block), new TagKey[0]);
        this.bulb_lantern = EndBlocks.registerBlock(name + "_bulb_lantern", (Block)new BulbVineLanternBlock(lanternProperties), new TagKey[0]);
        this.bulb_lantern_colored = new ColoredMaterial(BulbVineLanternColoredBlock::new, this.bulb_lantern, false);
        this.nugget = EndItems.registerEndItem(name + "_nugget", (Item)new ModelProviderItem(itemSettings));
        this.ingot = EndItems.registerEndItem(name + "_ingot", (Item)new ModelProviderItem(itemSettings));
        this.shovelHead = EndItems.registerEndItem(name + "_shovel_head");
        this.pickaxeHead = EndItems.registerEndItem(name + "_pickaxe_head");
        this.axeHead = EndItems.registerEndItem(name + "_axe_head");
        this.hoeHead = EndItems.registerEndItem(name + "_hoe_head");
        this.swordBlade = EndItems.registerEndItem(name + "_sword_blade");
        this.swordHandle = EndItems.registerEndItem(name + "_sword_handle");
        this.shovel = EndItems.registerEndTool(name + "_shovel", (TieredItem)new BaseShovelItem(material, 1.5f, -3.0f, itemSettings));
        this.sword = EndItems.registerEndTool(name + "_sword", (TieredItem)new BaseSwordItem(material, 3, -2.4f, itemSettings));
        this.pickaxe = EndItems.registerEndTool(name + "_pickaxe", (TieredItem)new EndPickaxe(material, 1, -2.8f, itemSettings));
        this.axe = EndItems.registerEndTool(name + "_axe", (TieredItem)new BaseAxeItem(material, 6.0f, -3.0f, itemSettings));
        this.hoe = EndItems.registerEndTool(name + "_hoe", (TieredItem)new BaseHoeItem(material, -3, 0.0f, itemSettings));
        this.hammer = EndItems.registerEndTool(name + "_hammer", (TieredItem)new EndHammerItem(material, 5.0f, -3.2f, 0.3, itemSettings));
        this.forgedPlate = EndItems.registerEndItem(name + "_forged_plate");
        this.helmet = EndItems.registerEndItem(name + "_helmet", (Item)new EndArmorItem(armor, ArmorItem.Type.HELMET, itemSettings));
        this.chestplate = EndItems.registerEndItem(name + "_chestplate", (Item)new EndArmorItem(armor, ArmorItem.Type.CHESTPLATE, itemSettings));
        this.leggings = EndItems.registerEndItem(name + "_leggings", (Item)new EndArmorItem(armor, ArmorItem.Type.LEGGINGS, itemSettings));
        this.boots = EndItems.registerEndItem(name + "_boots", (Item)new EndArmorItem(armor, ArmorItem.Type.BOOTS, itemSettings));
        this.anvilBlock = EndBlocks.registerBlock(name + "_anvil", (Block)new EndAnvilBlock(this, this.block.m_284356_(), anvilAndToolLevel), new TagKey[0]);
        if (hasOre) {
            ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_ingot_furnace_ore"), (ItemLike)this.ingot).setPrimaryInputAndUnlock(new ItemLike[]{this.ore})).buildWithBlasting();
            ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_ingot_furnace_raw"), (ItemLike)this.ingot).setPrimaryInputAndUnlock(new ItemLike[]{this.rawOre})).buildWithBlasting();
            BCLRecipeBuilder.alloying((ResourceLocation)BetterEnd.makeID(name + "_ingot_alloy"), (ItemLike)this.ingot).setInput(this.alloyingOre, this.alloyingOre).setOutputCount(3).setExperience(2.1f).build();
        }
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_ingot_from_nuggets"), (ItemLike)this.ingot).setShape(new String[]{"###", "###", "###"}).addMaterial('#', new ItemLike[]{this.nugget}).setGroup("end_metal_ingots_nug").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_nuggets_from_ingot"), (ItemLike)this.nugget).setOutputCount(9).shapeless().addMaterial('#', new ItemLike[]{this.ingot}).setGroup("end_metal_nuggets_ing").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_block"), (ItemLike)this.block).setShape(new String[]{"###", "###", "###"}).addMaterial('#', new ItemLike[]{this.ingot}).setGroup("end_metal_blocks").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_ingot_from_block"), (ItemLike)this.ingot).setOutputCount(9).shapeless().addMaterial('#', new ItemLike[]{this.block}).setGroup("end_metal_ingots").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_tile"), (ItemLike)this.tile).setOutputCount(4).setShape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.block}).setGroup("end_metal_tiles").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bars"), (ItemLike)this.bars).setOutputCount(16).setShape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{this.ingot}).setGroup("end_metal_bars").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_pressure_plate"), (ItemLike)this.pressurePlate).setShape(new String[]{"##"}).addMaterial('#', new ItemLike[]{this.ingot}).setGroup("end_metal_plates").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_door"), (ItemLike)this.door).setOutputCount(3).setShape(new String[]{"##", "##", "##"}).addMaterial('#', new ItemLike[]{this.ingot}).setGroup("end_metal_doors").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_trapdoor"), (ItemLike)this.trapdoor).setShape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.ingot}).setGroup("end_metal_trapdoors").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_stairs"), (ItemLike)this.stairs).setOutputCount(4).setShape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{this.block, this.tile}).setGroup("end_metal_stairs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_slab"), (ItemLike)this.slab).setOutputCount(6).setShape(new String[]{"###"}).addMaterial('#', new ItemLike[]{this.block, this.tile}).setGroup("end_metal_slabs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_chain"), (ItemLike)this.chain).setShape(new String[]{"N", "#", "N"}).addMaterial('#', new ItemLike[]{this.ingot}).addMaterial('N', new ItemLike[]{this.nugget}).setGroup("end_metal_chain").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_anvil"), (ItemLike)this.anvilBlock).setShape(new String[]{"###", " I ", "III"}).addMaterial('#', new ItemLike[]{this.block, this.tile}).addMaterial('I', new ItemLike[]{this.ingot}).setGroup("end_metal_anvil").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bulb_lantern"), (ItemLike)this.bulb_lantern).setShape(new String[]{"C", "I", "#"}).addMaterial('C', new ItemLike[]{this.chain}).addMaterial('I', new ItemLike[]{this.ingot}).addMaterial('#', new ItemLike[]{EndItems.GLOWING_BULB}).build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_chandelier"), (ItemLike)this.chandelier).setShape(new String[]{"I#I", " # "}).addMaterial('#', new ItemLike[]{this.ingot}).addMaterial('I', new ItemLike[]{EndItems.LUMECORN_ROD}).setGroup("end_metal_chandelier").build();
        ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_axe_nugget"), (ItemLike)this.nugget).setPrimaryInputAndUnlock(new ItemLike[]{this.axe})).buildWithBlasting();
        ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_hoe_nugget"), (ItemLike)this.nugget).setPrimaryInputAndUnlock(new ItemLike[]{this.hoe})).buildWithBlasting();
        ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_pickaxe_nugget"), (ItemLike)this.nugget).setPrimaryInputAndUnlock(new ItemLike[]{this.pickaxe})).buildWithBlasting();
        ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_sword_nugget"), (ItemLike)this.nugget).setPrimaryInputAndUnlock(new ItemLike[]{this.sword})).buildWithBlasting();
        ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_hammer_nugget"), (ItemLike)this.nugget).setPrimaryInputAndUnlock(new ItemLike[]{this.hammer})).buildWithBlasting();
        ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_helmet_nugget"), (ItemLike)this.nugget).setPrimaryInputAndUnlock(new ItemLike[]{this.helmet})).buildWithBlasting();
        ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_chestplate_nugget"), (ItemLike)this.nugget).setPrimaryInputAndUnlock(new ItemLike[]{this.chestplate})).buildWithBlasting();
        ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_leggings_nugget"), (ItemLike)this.nugget).setPrimaryInputAndUnlock(new ItemLike[]{this.leggings})).buildWithBlasting();
        ((CookingRecipeBuilder)BCLRecipeBuilder.smelting((ResourceLocation)BetterEnd.makeID(name + "_boots_nugget"), (ItemLike)this.nugget).setPrimaryInputAndUnlock(new ItemLike[]{this.boots})).buildWithBlasting();
        ((AnvilRecipe.Builder)BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.makeID(name + "_shovel_head"), (ItemLike)this.shovelHead).setPrimaryInput(new ItemLike[]{this.ingot})).setAnvilLevel(anvilAndToolLevel).setToolLevel(level).setDamage(level).build();
        ((AnvilRecipe.Builder)BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.makeID(name + "_pickaxe_head"), (ItemLike)this.pickaxeHead).setPrimaryInput(new ItemLike[]{this.ingot})).setInputCount(3).setAnvilLevel(anvilAndToolLevel).setToolLevel(level).setDamage(level).build();
        ((AnvilRecipe.Builder)BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.makeID(name + "_axe_head"), (ItemLike)this.axeHead).setPrimaryInput(new ItemLike[]{this.ingot})).setInputCount(3).setAnvilLevel(anvilAndToolLevel).setToolLevel(level).setDamage(level).build();
        ((AnvilRecipe.Builder)BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.makeID(name + "_hoe_head"), (ItemLike)this.hoeHead).setPrimaryInput(new ItemLike[]{this.ingot})).setInputCount(2).setAnvilLevel(anvilAndToolLevel).setToolLevel(level).setDamage(level).build();
        ((AnvilRecipe.Builder)BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.makeID(name + "_sword_blade"), (ItemLike)this.swordBlade).setPrimaryInput(new ItemLike[]{this.ingot})).setAnvilLevel(anvilAndToolLevel).setToolLevel(level).setDamage(level).build();
        ((AnvilRecipe.Builder)BCLRecipeBuilder.anvil((ResourceLocation)BetterEnd.makeID(name + "_forged_plate"), (ItemLike)this.forgedPlate).setPrimaryInput(new ItemLike[]{this.ingot})).setAnvilLevel(anvilAndToolLevel).setToolLevel(level).setDamage(level).build();
        ((SmithingRecipeBuilder)BCLRecipeBuilder.smithing((ResourceLocation)BetterEnd.makeID(name + "_hammer"), (ItemLike)this.hammer).setTemplate((Item)EndTemplates.HANDLE_ATTACHMENT).setPrimaryInputAndUnlock(new ItemLike[]{this.block})).setAddition((ItemLike)Items.f_42398_).build();
        ((SmithingRecipeBuilder)BCLRecipeBuilder.smithing((ResourceLocation)BetterEnd.makeID(name + "_axe"), (ItemLike)this.axe).setTemplate((Item)EndTemplates.HANDLE_ATTACHMENT).setPrimaryInputAndUnlock(new ItemLike[]{this.axeHead})).setAddition((ItemLike)Items.f_42398_).build();
        ((SmithingRecipeBuilder)BCLRecipeBuilder.smithing((ResourceLocation)BetterEnd.makeID(name + "_pickaxe"), (ItemLike)this.pickaxe).setTemplate((Item)EndTemplates.HANDLE_ATTACHMENT).setPrimaryInputAndUnlock(new ItemLike[]{this.pickaxeHead})).setAddition((ItemLike)Items.f_42398_).build();
        ((SmithingRecipeBuilder)BCLRecipeBuilder.smithing((ResourceLocation)BetterEnd.makeID(name + "_hoe"), (ItemLike)this.hoe).setTemplate((Item)EndTemplates.HANDLE_ATTACHMENT).setPrimaryInputAndUnlock(new ItemLike[]{this.hoeHead})).setAddition((ItemLike)Items.f_42398_).build();
        ((SmithingRecipeBuilder)BCLRecipeBuilder.smithing((ResourceLocation)BetterEnd.makeID(name + "_sword_handle"), (ItemLike)this.swordHandle).setTemplate((Item)this.swordHandleTemplate).setPrimaryInputAndUnlock(new ItemLike[]{Items.f_42398_})).setAddition((ItemLike)this.ingot).build();
        ((SmithingRecipeBuilder)BCLRecipeBuilder.smithing((ResourceLocation)BetterEnd.makeID(name + "_sword"), (ItemLike)this.sword).setTemplate((Item)EndTemplates.TOOL_ASSEMBLY).setPrimaryInputAndUnlock(new ItemLike[]{this.swordBlade})).setAddition((ItemLike)this.swordHandle).build();
        ((SmithingRecipeBuilder)BCLRecipeBuilder.smithing((ResourceLocation)BetterEnd.makeID(name + "_shovel"), (ItemLike)this.shovel).setTemplate((Item)EndTemplates.HANDLE_ATTACHMENT).setPrimaryInputAndUnlock(new ItemLike[]{this.shovelHead})).setAddition((ItemLike)Items.f_42398_).build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_helmet"), (ItemLike)this.helmet).setShape(new String[]{"###", "# #"}).addMaterial('#', new ItemLike[]{this.forgedPlate}).setGroup("end_metal_helmets").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_chestplate"), (ItemLike)this.chestplate).setShape(new String[]{"# #", "###", "###"}).addMaterial('#', new ItemLike[]{this.forgedPlate}).setGroup("end_metal_chestplates").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_leggings"), (ItemLike)this.leggings).setShape(new String[]{"###", "# #", "# #"}).addMaterial('#', new ItemLike[]{this.forgedPlate}).setGroup("end_metal_leggings").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_boots"), (ItemLike)this.boots).setShape(new String[]{"# #", "# #"}).addMaterial('#', new ItemLike[]{this.forgedPlate}).setGroup("end_metal_boots").build();
        TagManager.BLOCKS.add(BlockTags.f_13033_, (Object[])new Block[]{this.anvilBlock});
        TagManager.BLOCKS.add(BlockTags.f_13079_, (Object[])new Block[]{this.block});
        TagManager.ITEMS.add(ItemTags.f_13164_, (Object[])new Item[]{this.ingot});
        TagManager.BLOCKS.add(BlockTags.f_13069_, (Object[])new Block[]{this.ore, this.bars});
    }
}

