/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.complexmaterials;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.blocks.BaseSlabBlock;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.bclib.blocks.BaseWallBlock;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndPedestal;
import org.betterx.betterend.blocks.basis.LitBaseBlock;
import org.betterx.betterend.blocks.basis.LitPillarBlock;
import org.betterx.betterend.recipe.CraftingRecipes;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.TagManager;

public class CrystalSubblocksMaterial {
    public final Block polished;
    public final Block tiles;
    public final Block pillar;
    public final Block stairs;
    public final Block slab;
    public final Block wall;
    public final Block pedestal;
    public final Block bricks;
    public final Block brick_stairs;
    public final Block brick_slab;
    public final Block brick_wall;

    public CrystalSubblocksMaterial(String name, Block source) {
        FabricBlockSettings material = FabricBlockSettings.copyOf((BlockBehaviour)source);
        this.polished = EndBlocks.registerBlock(name + "_polished", (Block)new LitBaseBlock((BlockBehaviour.Properties)material), new TagKey[0]);
        this.tiles = EndBlocks.registerBlock(name + "_tiles", (Block)new LitBaseBlock((BlockBehaviour.Properties)material), new TagKey[0]);
        this.pillar = EndBlocks.registerBlock(name + "_pillar", (Block)new LitPillarBlock((BlockBehaviour.Properties)material), new TagKey[0]);
        this.stairs = EndBlocks.registerBlock(name + "_stairs", (Block)new BaseStairsBlock.Stone(source), new TagKey[0]);
        this.slab = EndBlocks.registerBlock(name + "_slab", (Block)new BaseSlabBlock.Stone(source), new TagKey[0]);
        this.wall = EndBlocks.registerBlock(name + "_wall", (Block)new BaseWallBlock.Stone(source), new TagKey[0]);
        this.pedestal = EndBlocks.registerBlock(name + "_pedestal", (Block)new EndPedestal.Stone(source), new TagKey[0]);
        this.bricks = EndBlocks.registerBlock(name + "_bricks", (Block)new LitBaseBlock((BlockBehaviour.Properties)material), new TagKey[0]);
        this.brick_stairs = EndBlocks.registerBlock(name + "_bricks_stairs", (Block)new BaseStairsBlock.Stone(this.bricks), new TagKey[0]);
        this.brick_slab = EndBlocks.registerBlock(name + "_bricks_slab", (Block)new BaseSlabBlock.Stone(this.bricks), new TagKey[0]);
        this.brick_wall = EndBlocks.registerBlock(name + "_bricks_wall", (Block)new BaseWallBlock.Stone(this.bricks), new TagKey[0]);
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bricks"), (ItemLike)this.bricks).setOutputCount(4).setShape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{source}).setGroup("end_bricks").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_polished"), (ItemLike)this.polished).setOutputCount(4).setShape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.bricks}).setGroup("end_tile").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_tiles"), (ItemLike)this.tiles).setOutputCount(4).setShape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{this.polished}).setGroup("end_small_tile").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_pillar"), (ItemLike)this.pillar).setShape(new String[]{"#", "#"}).addMaterial('#', new ItemLike[]{this.slab}).setGroup("end_pillar").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_stairs"), (ItemLike)this.stairs).setOutputCount(4).setShape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{source}).setGroup("end_stone_stairs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_slab"), (ItemLike)this.slab).setOutputCount(6).setShape(new String[]{"###"}).addMaterial('#', new ItemLike[]{source}).setGroup("end_stone_slabs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bricks_stairs"), (ItemLike)this.brick_stairs).setOutputCount(4).setShape(new String[]{"#  ", "## ", "###"}).addMaterial('#', new ItemLike[]{this.bricks}).setGroup("end_stone_stairs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bricks_slab"), (ItemLike)this.brick_slab).setOutputCount(6).setShape(new String[]{"###"}).addMaterial('#', new ItemLike[]{this.bricks}).setGroup("end_stone_slabs").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_wall"), (ItemLike)this.wall).setOutputCount(6).setShape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{source}).setGroup("end_wall").build();
        BCLRecipeBuilder.crafting((ResourceLocation)BetterEnd.makeID(name + "_bricks_wall"), (ItemLike)this.brick_wall).setOutputCount(6).setShape(new String[]{"###", "###"}).addMaterial('#', new ItemLike[]{this.bricks}).setGroup("end_wall").build();
        CraftingRecipes.registerPedestal(name + "_pedestal", this.pedestal, this.slab, this.pillar);
        TagManager.ITEMS.add(ItemTags.f_13139_, (Object[])new Item[]{this.slab.m_5456_(), this.brick_slab.m_5456_()});
        TagManager.ITEMS.add(ItemTags.f_13169_, (Object[])new Item[]{this.bricks.m_5456_()});
        TagManager.ITEMS.add(ItemTags.f_13166_, (Object[])new Item[]{source.m_5456_()});
        TagManager.ITEMS.add(ItemTags.f_13165_, (Object[])new Item[]{source.m_5456_()});
        TagManager.BLOCKS.add(BlockTags.f_13091_, (Object[])new Block[]{this.bricks});
        TagManager.BLOCKS.add(BlockTags.f_13032_, (Object[])new Block[]{this.wall, this.brick_wall});
        TagManager.BLOCKS.add(BlockTags.f_13031_, (Object[])new Block[]{this.slab, this.brick_slab});
    }
}

