/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.betterx.bclib.util.BackgroundInfo;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BetterEndSkyRenderer
implements DimensionRenderingRegistry.SkyRenderer {
    private static final ResourceLocation NEBULA_1 = BetterEnd.makeID("textures/sky/nebula_2.png");
    private static final ResourceLocation NEBULA_2 = BetterEnd.makeID("textures/sky/nebula_3.png");
    private static final ResourceLocation HORIZON = BetterEnd.makeID("textures/sky/nebula_1.png");
    private static final ResourceLocation STARS = BetterEnd.makeID("textures/sky/stars.png");
    private static final ResourceLocation FOG = BetterEnd.makeID("textures/sky/fog.png");
    private VertexBuffer nebula1;
    private VertexBuffer nebula2;
    private VertexBuffer horizon;
    private VertexBuffer stars1;
    private VertexBuffer stars2;
    private VertexBuffer stars3;
    private VertexBuffer stars4;
    private VertexBuffer fog;
    private Vector3f axis1;
    private Vector3f axis2;
    private Vector3f axis3;
    private Vector3f axis4;
    private boolean initialised;

    private void initialise() {
        if (!this.initialised) {
            this.initStars();
            LegacyRandomSource random = new LegacyRandomSource(131L);
            this.axis1 = new Vector3f(random.m_188501_(), random.m_188501_(), random.m_188501_());
            this.axis2 = new Vector3f(random.m_188501_(), random.m_188501_(), random.m_188501_());
            this.axis3 = new Vector3f(random.m_188501_(), random.m_188501_(), random.m_188501_());
            this.axis4 = new Vector3f(random.m_188501_(), random.m_188501_(), random.m_188501_());
            this.axis1.normalize();
            this.axis2.normalize();
            this.axis3.normalize();
            this.axis4.normalize();
            this.initialised = true;
        }
    }

    public void render(WorldRenderContext context) {
        float a;
        if (context.world() == null || context.matrixStack() == null) {
            return;
        }
        this.initialise();
        Matrix4f projectionMatrix = context.projectionMatrix();
        PoseStack matrices = context.matrixStack();
        float time = ((float)context.world().m_46468_() + context.tickDelta()) % 360000.0f * 1.7453292E-5f;
        float time2 = time * 2.0f;
        float time3 = time * 3.0f;
        FogRenderer.m_109036_();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float blindA = 1.0f - BackgroundInfo.blindness;
        float blind02 = blindA * 0.2f;
        float blind06 = blindA * 0.6f;
        if (blindA > 0.0f) {
            matrices.m_85836_();
            matrices.m_252781_(new Quaternionf().rotationXYZ(0.0f, time, 0.0f));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HORIZON);
            this.renderBuffer(matrices, projectionMatrix, this.horizon, DefaultVertexFormat.f_85817_, 0.77f, 0.31f, 0.73f, 0.7f * blindA);
            matrices.m_85849_();
            matrices.m_85836_();
            matrices.m_252781_(new Quaternionf().rotationXYZ(0.0f, -time, 0.0f));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)NEBULA_1);
            this.renderBuffer(matrices, projectionMatrix, this.nebula1, DefaultVertexFormat.f_85817_, 0.77f, 0.31f, 0.73f, blind02);
            matrices.m_85849_();
            matrices.m_85836_();
            matrices.m_252781_(new Quaternionf().rotationXYZ(0.0f, time2, 0.0f));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)NEBULA_2);
            this.renderBuffer(matrices, projectionMatrix, this.nebula2, DefaultVertexFormat.f_85817_, 0.77f, 0.31f, 0.73f, blind02);
            matrices.m_85849_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)STARS);
            matrices.m_85836_();
            matrices.m_252781_(new Quaternionf().setAngleAxis(time, this.axis3.x, this.axis3.y, this.axis3.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars3, DefaultVertexFormat.f_85817_, 0.77f, 0.31f, 0.73f, blind06);
            matrices.m_85849_();
            matrices.m_85836_();
            matrices.m_252781_(new Quaternionf().setAngleAxis(time2, this.axis4.x, this.axis4.y, this.axis4.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars4, DefaultVertexFormat.f_85817_, 1.0f, 1.0f, 1.0f, blind06);
            matrices.m_85849_();
        }
        if ((a = BackgroundInfo.fogDensity - 1.0f) > 0.0f) {
            if (a > 1.0f) {
                a = 1.0f;
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FOG);
            this.renderBuffer(matrices, projectionMatrix, this.fog, DefaultVertexFormat.f_85817_, BackgroundInfo.fogColorRed, BackgroundInfo.fogColorGreen, BackgroundInfo.fogColorBlue, a);
        }
        if (blindA > 0.0f) {
            matrices.m_85836_();
            matrices.m_252781_(new Quaternionf().setAngleAxis(time3, this.axis1.x, this.axis1.y, this.axis1.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars1, DefaultVertexFormat.f_85814_, 1.0f, 1.0f, 1.0f, blind06);
            matrices.m_85849_();
            matrices.m_85836_();
            matrices.m_252781_(new Quaternionf().setAngleAxis(time2, this.axis2.x, this.axis2.y, this.axis2.z));
            this.renderBuffer(matrices, projectionMatrix, this.stars2, DefaultVertexFormat.f_85814_, 0.95f, 0.64f, 0.93f, blind06);
            matrices.m_85849_();
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderBuffer(PoseStack matrices, Matrix4f matrix4f, VertexBuffer buffer, VertexFormat format, float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        buffer.m_85921_();
        if (format == DefaultVertexFormat.f_85814_) {
            buffer.m_253207_(matrices.m_85850_().m_252922_(), matrix4f, GameRenderer.m_172808_());
        } else {
            buffer.m_253207_(matrices.m_85850_().m_252922_(), matrix4f, GameRenderer.m_172817_());
        }
        VertexBuffer.m_85931_();
    }

    private void initStars() {
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        this.stars1 = this.buildBuffer(buffer, this.stars1, 0.1, 0.3, 3500, 41315L, this::makeStars);
        this.stars2 = this.buildBuffer(buffer, this.stars2, 0.1, 0.35, 2000, 35151L, this::makeStars);
        this.stars3 = this.buildBuffer(buffer, this.stars3, 0.4, 1.2, 1000, 61354L, this::makeUVStars);
        this.stars4 = this.buildBuffer(buffer, this.stars4, 0.4, 1.2, 1000, 61355L, this::makeUVStars);
        this.nebula1 = this.buildBuffer(buffer, this.nebula1, 40.0, 60.0, 30, 11515L, this::makeFarFog);
        this.nebula2 = this.buildBuffer(buffer, this.nebula2, 40.0, 60.0, 10, 14151L, this::makeFarFog);
        this.horizon = this.buildBufferHorizon(buffer, this.horizon);
        this.fog = this.buildBufferFog(buffer, this.fog);
    }

    private VertexBuffer buildBuffer(BufferBuilder bufferBuilder, VertexBuffer buffer, double minSize, double maxSize, int count, long seed, BufferFunction fkt) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        fkt.make(bufferBuilder, minSize, maxSize, count, seed);
        BufferBuilder.RenderedBuffer renderedBuffer = bufferBuilder.m_231175_();
        buffer.m_85921_();
        buffer.m_231221_(renderedBuffer);
        return buffer;
    }

    private VertexBuffer buildBufferHorizon(BufferBuilder bufferBuilder, VertexBuffer buffer) {
        return this.buildBuffer(bufferBuilder, buffer, 0.0, 0.0, 0, 0L, (_builder, _minSize, _maxSize, _count, _seed) -> this.makeCylinder(_builder, 16, 50.0, 100.0));
    }

    private VertexBuffer buildBufferFog(BufferBuilder bufferBuilder, VertexBuffer buffer) {
        return this.buildBuffer(bufferBuilder, buffer, 0.0, 0.0, 0, 0L, (_builder, _minSize, _maxSize, _count, _seed) -> this.makeCylinder(_builder, 16, 50.0, 70.0));
    }

    private void makeStars(BufferBuilder buffer, double minSize, double maxSize, int count, long seed) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        RenderSystem.setShader(GameRenderer::m_172808_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < count; ++i) {
            double posX = random.m_188500_() * 2.0 - 1.0;
            double posY = random.m_188500_() * 2.0 - 1.0;
            double posZ = random.m_188500_() * 2.0 - 1.0;
            double size = MHelper.randRange((double)minSize, (double)maxSize, (RandomSource)random);
            double length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = 1.0 / Math.sqrt(length);
            double px = (posX *= length) * 100.0;
            double py = (posY *= length) * 100.0;
            double pz = (posZ *= length) * 100.0;
            double angle = Math.atan2(posX, posZ);
            double sin1 = Math.sin(angle);
            double cos1 = Math.cos(angle);
            angle = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double sin2 = Math.sin(angle);
            double cos2 = Math.cos(angle);
            angle = random.m_188500_() * Math.PI * 2.0;
            double sin3 = Math.sin(angle);
            double cos3 = Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                double x = (double)((index & 2) - 1) * size;
                double y = (double)((index + 1 & 2) - 1) * size;
                double aa = x * cos3 - y * sin3;
                double ab = y * cos3 + x * sin3;
                double dy = aa * sin2 + 0.0 * cos2;
                double ae = 0.0 * sin2 - aa * cos2;
                double dx = ae * sin1 - ab * cos1;
                double dz = ab * sin1 + ae * cos1;
                buffer.m_5483_(px + dx, py + dy, pz + dz).m_5752_();
            }
        }
    }

    private void makeUVStars(BufferBuilder buffer, double minSize, double maxSize, int count, long seed) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        RenderSystem.setShader(GameRenderer::m_172817_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (int i = 0; i < count; ++i) {
            double posX = random.m_188500_() * 2.0 - 1.0;
            double posY = random.m_188500_() * 2.0 - 1.0;
            double posZ = random.m_188500_() * 2.0 - 1.0;
            double size = MHelper.randRange((double)minSize, (double)maxSize, (RandomSource)random);
            double length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = 1.0 / Math.sqrt(length);
            double px = (posX *= length) * 100.0;
            double py = (posY *= length) * 100.0;
            double pz = (posZ *= length) * 100.0;
            double angle = Math.atan2(posX, posZ);
            double sin1 = Math.sin(angle);
            double cos1 = Math.cos(angle);
            angle = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double sin2 = Math.sin(angle);
            double cos2 = Math.cos(angle);
            angle = random.m_188500_() * Math.PI * 2.0;
            double sin3 = Math.sin(angle);
            double cos3 = Math.cos(angle);
            float minV = (float)random.m_188503_(4) / 4.0f;
            for (int index = 0; index < 4; ++index) {
                double x = (double)((index & 2) - 1) * size;
                double y = (double)((index + 1 & 2) - 1) * size;
                double aa = x * cos3 - y * sin3;
                double ab = y * cos3 + x * sin3;
                double dy = aa * sin2 + 0.0 * cos2;
                double ae = 0.0 * sin2 - aa * cos2;
                double dx = ae * sin1 - ab * cos1;
                double dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = (float)(index + 1 >> 1 & 1) / 4.0f + minV;
                buffer.m_5483_(px + dx, py + dy, pz + dz).m_7421_(texU, texV).m_5752_();
            }
        }
    }

    private void makeFarFog(BufferBuilder buffer, double minSize, double maxSize, int count, long seed) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        RenderSystem.setShader(GameRenderer::m_172817_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (int i = 0; i < count; ++i) {
            double posX = random.m_188500_() * 2.0 - 1.0;
            double posY = random.m_188500_() - 0.5;
            double posZ = random.m_188500_() * 2.0 - 1.0;
            double size = MHelper.randRange((double)minSize, (double)maxSize, (RandomSource)random);
            double length = posX * posX + posY * posY + posZ * posZ;
            double distance = 2.0;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = distance / Math.sqrt(length);
            size *= distance;
            double px = (posX *= length) * 100.0;
            double py = (posY *= length) * 100.0;
            double pz = (posZ *= length) * 100.0;
            double angle = Math.atan2(posX, posZ);
            double sin1 = Math.sin(angle);
            double cos1 = Math.cos(angle);
            angle = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double sin2 = Math.sin(angle);
            double cos2 = Math.cos(angle);
            angle = random.m_188500_() * Math.PI * 2.0;
            double sin3 = Math.sin(angle);
            double cos3 = Math.cos(angle);
            for (int index = 0; index < 4; ++index) {
                double x = (double)((index & 2) - 1) * size;
                double y = (double)((index + 1 & 2) - 1) * size;
                double aa = x * cos3 - y * sin3;
                double ab = y * cos3 + x * sin3;
                double dy = aa * sin2 + 0.0 * cos2;
                double ae = 0.0 * sin2 - aa * cos2;
                double dx = ae * sin1 - ab * cos1;
                double dz = ab * sin1 + ae * cos1;
                float texU = index >> 1 & 1;
                float texV = index + 1 >> 1 & 1;
                buffer.m_5483_(px + dx, py + dy, pz + dz).m_7421_(texU, texV).m_5752_();
            }
        }
    }

    private void makeCylinder(BufferBuilder buffer, int segments, double height, double radius) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        for (int i = 0; i < segments; ++i) {
            double a1 = (double)i * Math.PI * 2.0 / (double)segments;
            double a2 = (double)(i + 1) * Math.PI * 2.0 / (double)segments;
            double px1 = Math.sin(a1) * radius;
            double pz1 = Math.cos(a1) * radius;
            double px2 = Math.sin(a2) * radius;
            double pz2 = Math.cos(a2) * radius;
            float u0 = (float)i / (float)segments;
            float u1 = (float)(i + 1) / (float)segments;
            buffer.m_5483_(px1, -height, pz1).m_7421_(u0, 0.0f).m_5752_();
            buffer.m_5483_(px1, height, pz1).m_7421_(u0, 1.0f).m_5752_();
            buffer.m_5483_(px2, height, pz2).m_7421_(u1, 1.0f).m_5752_();
            buffer.m_5483_(px2, -height, pz2).m_7421_(u1, 0.0f).m_5752_();
        }
    }

    @FunctionalInterface
    static interface BufferFunction {
        public void make(BufferBuilder var1, double var2, double var4, int var6, long var7);
    }
}

