/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.entities;

import java.util.List;
import net.fabricmc.fabric.api.entity.event.v1.FabricElytraItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.betterx.betterend.blocks.HydrothermalVentBlock;
import org.betterx.betterend.registry.EndBlockEntities;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.util.GlobalState;

public class BlockEntityHydrothermalVent
extends BlockEntity {
    private static final Vec3 POSITIVE_Y = new Vec3(0.0, 1.0, 0.0);

    public BlockEntityHydrothermalVent(BlockPos blockPos, BlockState blockState) {
        super(EndBlockEntities.HYDROTHERMAL_VENT, blockPos, blockState);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos worldPosition, BlockState state, T uncastedEntity) {
        if (level != null && uncastedEntity instanceof BlockEntityHydrothermalVent && state.m_60713_(EndBlocks.HYDROTHERMAL_VENT)) {
            BlockEntityHydrothermalVent blockEntity = (BlockEntityHydrothermalVent)uncastedEntity;
            if (level.m_5776_()) {
                BlockEntityHydrothermalVent.clientTick(level, worldPosition, state, blockEntity);
            }
            BlockEntityHydrothermalVent.serverTick(level, worldPosition, state, blockEntity);
        }
    }

    private static void clientTick(Level level, BlockPos worldPosition, BlockState state, BlockEntityHydrothermalVent blockEntity) {
        boolean active = (Boolean)state.m_61143_((Property)HydrothermalVentBlock.ACTIVATED);
        if (active && level.f_46441_.m_188503_(20) == 0 && ((Boolean)state.m_61143_((Property)HydrothermalVentBlock.WATERLOGGED)).booleanValue()) {
            double x = (double)worldPosition.m_123341_() + level.f_46441_.m_188500_();
            double y = (double)worldPosition.m_123342_() + 0.9 + level.f_46441_.m_188500_() * 0.3;
            double z = (double)worldPosition.m_123343_() + level.f_46441_.m_188500_();
            level.m_7106_((ParticleOptions)EndParticles.GEYSER_PARTICLE, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void serverTick(Level level, BlockPos worldPosition, BlockState state, BlockEntityHydrothermalVent blockEntity) {
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        boolean active = (Boolean)state.m_61143_((Property)HydrothermalVentBlock.ACTIVATED);
        POS.m_122190_((Vec3i)worldPosition).m_122173_(Direction.UP);
        int height = active ? 85 : 25;
        AABB box = new AABB(POS.m_7918_(-1, 0, -1), POS.m_7918_(1, height, 1));
        List entities = level.m_45976_(LivingEntity.class, box);
        if (entities.size() > 0) {
            BlockState blockState;
            while ((double)POS.m_123342_() < box.f_82292_ && !(blockState = level.m_8055_((BlockPos)POS)).m_60804_((BlockGetter)level, (BlockPos)POS)) {
                if (blockState.m_60795_()) {
                    double mult = active ? 3.0 : 5.0;
                    float force = (float)((1.0 - (double)POS.m_123342_() / box.f_82292_) / mult);
                    entities.stream().filter(entity -> (int)entity.m_20186_() == POS.m_123342_() && blockEntity.hasElytra((LivingEntity)entity) && entity.m_21255_()).forEach(entity -> entity.m_19920_(force, POSITIVE_Y));
                }
                POS.m_122173_(Direction.UP);
            }
        }
    }

    private boolean hasElytra(LivingEntity entity) {
        Item item = entity.m_6844_(EquipmentSlot.CHEST).m_41720_();
        return item instanceof ElytraItem || item instanceof FabricElytraItem;
    }
}

