/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.basis;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.betterend.blocks.basis.EndLanternBlock;
import org.betterx.betterend.client.models.Patterns;
import org.betterx.betterend.registry.EndBlocks;
import org.jetbrains.annotations.Nullable;

public class StoneLanternBlock
extends EndLanternBlock
implements CustomColorProvider,
BehaviourWood {
    private static final VoxelShape SHAPE_CEIL = StoneLanternBlock.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_FLOOR = StoneLanternBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);

    public StoneLanternBlock(Block source) {
        super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)source).lightLevel(bs -> 15));
    }

    public BlockColor getProvider() {
        return ((CustomColorProvider)EndBlocks.AURORA_CRYSTAL).getProvider();
    }

    public ItemColor getItemProvider() {
        return ((CustomColorProvider)EndBlocks.AURORA_CRYSTAL).getItemProvider();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return (Boolean)state.m_61143_((Property)IS_FLOOR) != false ? SHAPE_FLOOR : SHAPE_CEIL;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        String blockName = resourceLocation.m_135815_();
        Optional<String> pattern = (Boolean)blockState.m_61143_((Property)IS_FLOOR) != false ? Patterns.createJson(Patterns.BLOCK_STONE_LANTERN_FLOOR, blockName, blockName) : Patterns.createJson(Patterns.BLOCK_STONE_LANTERN_CEIL, blockName, blockName);
        return ModelsHelper.fromPattern(pattern);
    }
}

