/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.interfaces.survives.SurvivesOnBrimstone;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;

public class SulphurCrystalBlock
extends BaseAttachedBlock.Glass
implements RenderLayerProvider,
SimpleWaterloggedBlock,
LiquidBlockContainer,
SurvivesOnBrimstone {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)2);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public SulphurCrystalBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283832_).m_60918_(SoundType.f_56744_).m_60999_().m_60910_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{AGE, WATERLOGGED});
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (tool != null && !tool.m_41619_()) {
            int max;
            int min;
            int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool) + 1;
            int age = (Integer)state.m_61143_((Property)AGE);
            if (age < 2) {
                min = 1;
                max = 1 + age * fortuneLevel;
            } else {
                min = fortuneLevel + 1;
                max = 2 + age * fortuneLevel;
            }
            if (tool.m_41735_(state) && EnchantmentHelper.m_272262_((ItemStack)tool)) {
                ItemStack drop = new ItemStack((ItemLike)EndBlocks.SULPHUR_CRYSTAL, MHelper.randRange((int)min, (int)max, (RandomSource)MHelper.RANDOM_SOURCE));
                return List.of(drop);
            }
        }
        if ((Integer)state.m_61143_((Property)AGE) < 2) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)EndItems.CRYSTALLINE_SULPHUR, MHelper.randRange((int)1, (int)3, (RandomSource)MHelper.RANDOM_SOURCE))});
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        if (state != null) {
            BlockPos blockPos;
            Level worldView = ctx.m_43725_();
            boolean water = worldView.m_6425_(blockPos = ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
        }
        return null;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)FACING));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        return this.isTerrain(world.m_8055_(blockPos));
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.5, (double)0.875));
        BOUNDING_SHAPES.put(Direction.DOWN, Shapes.m_83048_((double)0.125, (double)0.5, (double)0.125, (double)0.875, (double)1.0, (double)0.875));
        BOUNDING_SHAPES.put(Direction.NORTH, Shapes.m_83048_((double)0.125, (double)0.125, (double)0.5, (double)0.875, (double)0.875, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, Shapes.m_83048_((double)0.125, (double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.5));
        BOUNDING_SHAPES.put(Direction.WEST, Shapes.m_83048_((double)0.5, (double)0.125, (double)0.125, (double)1.0, (double)0.875, (double)0.875));
        BOUNDING_SHAPES.put(Direction.EAST, Shapes.m_83048_((double)0.0, (double)0.125, (double)0.125, (double)0.5, (double)0.875, (double)0.875));
    }
}

