/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.items.tool.BaseShearsItem;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.entity.SilkMothEntity;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndItems;

public class SilkMothHiveBlock
extends BaseBlock.Wood {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty FULLNESS = EndBlockProperties.FULLNESS;

    public SilkMothHiveBlock() {
        BlockBehaviour.Properties.m_284310_();
        super(BlockBehaviour.Properties.m_284310_().m_60913_(0.5f, 0.1f).m_60918_(SoundType.f_56745_).m_60955_().m_60977_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FULLNESS, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING, FULLNESS});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction dir = ctx.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal((BlockState)state, (Rotation)rotation, (Property)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal((BlockState)state, (Mirror)mirror, (Property)FACING);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        BlockPos spawn = pos.m_121945_(dir);
        if (!world.m_8055_(spawn).m_60795_()) {
            return;
        }
        int count = world.m_142425_((EntityTypeTest)EndEntities.SILK_MOTH.type(), new AABB(pos).m_82400_(16.0), entity -> true).size();
        if (count > 6) {
            return;
        }
        SilkMothEntity moth = new SilkMothEntity((EntityType<? extends SilkMothEntity>)EndEntities.SILK_MOTH.type(), (Level)world);
        moth.m_7678_((double)spawn.m_123341_() + 0.5, (double)spawn.m_123342_() + 0.5, (double)spawn.m_123343_() + 0.5, dir.m_122435_(), 0.0f);
        moth.m_20256_(new Vec3((double)dir.m_122429_() * 0.4, 0.0, (double)dir.m_122431_() * 0.4));
        moth.setHive((Level)world, pos);
        world.m_7967_((Entity)moth);
        world.m_5594_(null, pos, SoundEvents.f_11696_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack;
        if (hand == InteractionHand.MAIN_HAND && BaseShearsItem.isShear((ItemStack)(stack = player.m_21205_())) && (Integer)state.m_61143_((Property)FULLNESS) == 3) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_((Property)FULLNESS, (Comparable)Integer.valueOf(0))));
            Direction dir = (Direction)state.m_61143_((Property)FACING);
            double px = (double)(pos.m_123341_() + dir.m_122429_()) + 0.5;
            double py = (double)(pos.m_123342_() + dir.m_122430_()) + 0.5;
            double pz = (double)(pos.m_123343_() + dir.m_122431_()) + 0.5;
            ItemStack drop = new ItemStack((ItemLike)EndItems.SILK_FIBER, MHelper.randRange((int)8, (int)16, (RandomSource)world.m_213780_()));
            ItemEntity entity = new ItemEntity(world, px, py, pz, drop);
            world.m_7967_((Entity)entity);
            if (world.m_213780_().m_188503_(4) == 0) {
                drop = new ItemStack((ItemLike)EndItems.SILK_MOTH_MATRIX);
                entity = new ItemEntity(world, px, py, pz, drop);
                world.m_7967_((Entity)entity);
            }
            if (!player.m_7500_()) {
                stack.m_41721_(stack.m_41773_() + 1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

