/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlock;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.particle.InfusionParticleType;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndItems;
import org.betterx.ui.ColorUtil;
import org.jetbrains.annotations.Nullable;

public class RespawnObeliskBlock
extends BaseBlock.Stone
implements CustomColorProvider,
RenderLayerProvider {
    private static final VoxelShape VOXEL_SHAPE_BOTTOM = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape VOXEL_SHAPE_MIDDLE_TOP = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public RespawnObeliskBlock() {
        super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50259_).luminance(state -> state.m_61143_(SHAPE) == BlockProperties.TripleShape.BOTTOM ? 0 : 15));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.m_61143_(SHAPE) == BlockProperties.TripleShape.BOTTOM ? VOXEL_SHAPE_BOTTOM : VOXEL_SHAPE_MIDDLE_TOP;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        for (int i = 0; i < 3; ++i) {
            if (world.m_8055_(pos.m_6630_(i)).m_247087_()) continue;
            return false;
        }
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        state = this.m_49966_();
        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)));
        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.m_7494_(), (BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE)));
        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.m_6630_(2), (BlockState)((BlockState)state.m_61124_(SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.m_61143_(SHAPE);
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            if (world.m_8055_(pos.m_7494_()).m_60713_((Block)this)) {
                return state;
            }
            return Blocks.f_50016_.m_49966_();
        }
        if (shape == BlockProperties.TripleShape.MIDDLE) {
            if (world.m_8055_(pos.m_7494_()).m_60713_((Block)this) && world.m_8055_(pos.m_7495_()).m_60713_((Block)this)) {
                return state;
            }
            return Blocks.f_50016_.m_49966_();
        }
        if (world.m_8055_(pos.m_7495_()).m_60713_((Block)this)) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (player.m_7500_()) {
            BlockProperties.TripleShape shape = (BlockProperties.TripleShape)state.m_61143_(SHAPE);
            if (shape == BlockProperties.TripleShape.MIDDLE) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.m_7495_(), (Block)Blocks.f_50016_);
            } else if (shape == BlockProperties.TripleShape.TOP) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)pos.m_6625_(2), (Block)Blocks.f_50016_);
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (state.m_61143_(SHAPE) == BlockProperties.TripleShape.BOTTOM) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        }
        return Lists.newArrayList();
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.TRANSLUCENT;
    }

    public BlockColor getProvider() {
        return ((CustomColorProvider)EndBlocks.AURORA_CRYSTAL).getProvider();
    }

    public ItemColor getItemProvider() {
        return (stack, tintIndex) -> ColorUtil.color((int)255, (int)255, (int)255);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean canActivate;
        ItemStack itemStack = player.m_21120_(hand);
        boolean bl = canActivate = itemStack.m_41720_() == EndItems.AMBER_GEM && itemStack.m_41613_() > 5;
        if (hand != InteractionHand.MAIN_HAND || !canActivate) {
            if (!(world.f_46443_ || itemStack.m_41720_() instanceof BlockItem || player.m_7500_())) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                serverPlayerEntity.m_5661_((Component)Component.m_237115_((String)"message.betterend.fail_spawn"), true);
            }
            return InteractionResult.FAIL;
        }
        if (!world.f_46443_) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            serverPlayerEntity.m_9158_(world.m_46472_(), pos, 0.0f, false, false);
            serverPlayerEntity.m_5661_((Component)Component.m_237115_((String)"message.betterend.set_spawn"), true);
            double px = (double)pos.m_123341_() + 0.5;
            double py = (double)pos.m_123342_() + 0.5;
            double pz = (double)pos.m_123343_() + 0.5;
            InfusionParticleType particle = new InfusionParticleType(new ItemStack((ItemLike)EndItems.AMBER_GEM));
            if (world instanceof ServerLevel) {
                double py1 = py;
                double py2 = py - 0.2;
                if (state.m_61143_(SHAPE) == BlockProperties.TripleShape.BOTTOM) {
                    py1 += 1.0;
                    py2 += 2.0;
                } else if (state.m_61143_(SHAPE) == BlockProperties.TripleShape.MIDDLE) {
                    py1 += 0.0;
                    py2 += 1.0;
                } else {
                    py1 -= 2.0;
                }
                ((ServerLevel)world).m_8767_((ParticleOptions)particle, px, py1, pz, 20, 0.14, 0.5, 0.14, 0.1);
                ((ServerLevel)world).m_8767_((ParticleOptions)particle, px, py2, pz, 20, 0.14, 0.3, 0.14, 0.1);
            }
            world.m_6263_(null, px, py, py, SoundEvents.f_12326_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                itemStack.m_41774_(6);
            }
        }
        return player.m_7500_() ? InteractionResult.PASS : InteractionResult.m_19078_((boolean)world.f_46443_);
    }
}

