/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Maps;
import com.mojang.math.Transformation;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.betterend.client.models.Patterns;
import org.jetbrains.annotations.Nullable;

public class ChandelierBlock
extends BaseAttachedBlock.Metal
implements RenderLayerProvider,
BlockModelProvider {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);

    public ChandelierBlock(Block source) {
        super(FabricBlockSettings.copyOf((BlockBehaviour)source).lightLevel(bs -> 15).m_60910_().m_60955_().m_60999_());
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.m_61143_((Property)FACING));
    }

    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation blockId) {
        return ModelsHelper.createItemModel((ResourceLocation)blockId);
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        return ModelsHelper.fromPattern(switch ((Direction)blockState.m_61143_((Property)FACING)) {
            case Direction.UP -> Patterns.createJson(Patterns.BLOCK_CHANDELIER_FLOOR, resourceLocation.m_135815_());
            case Direction.DOWN -> Patterns.createJson(Patterns.BLOCK_CHANDELIER_CEIL, resourceLocation.m_135815_());
            default -> Patterns.createJson(Patterns.BLOCK_CHANDELIER_WALL, resourceLocation.m_135815_());
        });
    }

    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        String state = "_wall";
        BlockModelRotation rotation = BlockModelRotation.X0_Y0;
        switch ((Direction)blockState.m_61143_((Property)FACING)) {
            case UP: {
                state = "_floor";
                break;
            }
            case DOWN: {
                state = "_ceil";
                break;
            }
            case EAST: {
                rotation = BlockModelRotation.X0_Y270;
                break;
            }
            case NORTH: {
                rotation = BlockModelRotation.X0_Y180;
                break;
            }
            case WEST: {
                rotation = BlockModelRotation.X0_Y90;
                break;
            }
        }
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + state);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createMultiVariant((ResourceLocation)modelId, (Transformation)rotation.m_6189_(), (boolean)false);
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
        BOUNDING_SHAPES.put(Direction.DOWN, Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
        BOUNDING_SHAPES.put(Direction.NORTH, Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5));
        BOUNDING_SHAPES.put(Direction.WEST, Shapes.m_83048_((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.EAST, Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0));
    }
}

