/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.world.event;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.mixin.common.WorldPresetAccessor;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleUtil;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.OnWorldLoad;
import org.betterx.worlds.together.world.event.WorldEventsImpl;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class WorldBootstrap {
    private static RegistryAccess LAST_REGISTRY_ACCESS = null;
    private static byte WARN_COUNT_GLOBAL_REGISTRY = 0;

    public static RegistryAccess getLastRegistryAccess() {
        return LAST_REGISTRY_ACCESS;
    }

    public static RegistryAccess getLastRegistryAccessOrElseBuiltin() {
        if (WARN_COUNT_GLOBAL_REGISTRY < 10 && LAST_REGISTRY_ACCESS == null && Configs.MAIN_CONFIG.verboseLogging()) {
            WorldsTogether.LOGGER.error("Tried to read from global registry!");
            WARN_COUNT_GLOBAL_REGISTRY = (byte)(WARN_COUNT_GLOBAL_REGISTRY + 1);
        }
        return LAST_REGISTRY_ACCESS;
    }

    private static void setupWorld(LevelStorageSource.LevelStorageAccess levelStorageAccess, Map<ResourceKey<LevelStem>, ChunkGenerator> dimensions, boolean newWorld, boolean isServer) {
        try {
            Helpers.initializeWorldConfig(levelStorageAccess, newWorld);
            WorldEventsImpl.BEFORE_WORLD_LOAD.emit(e -> e.prepareWorld(levelStorageAccess, dimensions, newWorld, isServer));
        }
        catch (Exception e2) {
            WorldsTogether.LOGGER.error("Failed to initialize data in world", e2);
        }
    }

    private static void writeWorldPresets(WorldDimensions dimensions, Holder<WorldPreset> currentPreset) {
        Object object;
        if ((currentPreset = WorldEventsImpl.ADAPT_WORLD_PRESET.emit(currentPreset, dimensions)) != null && (object = currentPreset.m_203334_()) instanceof WorldPresetAccessor) {
            WorldPresetAccessor acc = (WorldPresetAccessor)object;
            TogetherWorldPreset.writeWorldPresetSettings(acc.bcl_getDimensions());
        } else {
            WorldsTogether.LOGGER.error("Failed writing together File");
            TogetherWorldPreset.writeWorldPresetSettings(dimensions);
        }
    }

    public static void finishedWorldLoad() {
        WorldEventsImpl.ON_WORLD_LOAD.emit(OnWorldLoad::onLoad);
    }

    public static void finalizeWorldGenSettings(Registry<LevelStem> dimensionRegistry) {
        Object output = "World Dimensions: ";
        for (Map.Entry entry : dimensionRegistry.m_6579_()) {
            WorldEventsImpl.ON_FINALIZE_LEVEL_STEM.emit(e -> e.now(dimensionRegistry, (ResourceKey<LevelStem>)((ResourceKey)entry.getKey()), (LevelStem)entry.getValue()));
            if (!Configs.MAIN_CONFIG.verboseLogging()) continue;
            output = (String)output + "\n - " + ((ResourceKey)entry.getKey()).m_135782_().toString() + ": \n     " + ((LevelStem)entry.getValue()).f_63976_().toString() + " " + ((LevelStem)entry.getValue()).f_63976_().m_62218_().toString().replace("\n", "\n     ");
        }
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info((String)output);
        }
        SurfaceRuleUtil.injectSurfaceRulesToAllDimensions(dimensionRegistry);
        WorldEventsImpl.ON_FINALIZED_WORLD_LOAD.emit(e -> e.done(dimensionRegistry));
    }

    public static LayeredRegistryAccess<RegistryLayer> enforceInLayeredRegistry(LayeredRegistryAccess<RegistryLayer> registries) {
        RegistryAccess.Frozen access = registries.m_247579_();
        Helpers.onRegistryReady((RegistryAccess)access);
        Registry dimensions = access.m_175515_(Registries.f_256862_);
        Registry<LevelStem> changedDimensions = WorldGenUtil.repairBiomeSourceInAllDimensions((RegistryAccess)access, (Registry<LevelStem>)dimensions);
        if (dimensions != changedDimensions) {
            if (Configs.MAIN_CONFIG.verboseLogging()) {
                WorldsTogether.LOGGER.info("Loading originally configured Dimensions in World.");
            }
            registries = registries.m_247705_((Object)RegistryLayer.DIMENSIONS, new RegistryAccess.Frozen[]{new RegistryAccess.ImmutableRegistryAccess(List.of(changedDimensions)).m_203557_()});
            Helpers.onRegistryReady((RegistryAccess)registries.m_247579_());
        }
        return registries;
    }

    public static class Helpers {
        private static void initializeWorldConfig(LevelStorageSource.LevelStorageAccess levelStorageAccess, boolean newWorld) {
            File levelPath = levelStorageAccess.m_78283_(LevelResource.f_78182_).toFile();
            Helpers.initializeWorldConfig(levelPath, newWorld);
        }

        private static void initializeWorldConfig(File levelBaseDir, boolean newWorld) {
            WorldConfig.load(new File(levelBaseDir, "data"));
        }

        private static void onRegistryReady(RegistryAccess a) {
            if (a != LAST_REGISTRY_ACCESS) {
                LAST_REGISTRY_ACCESS = a;
                WorldEventsImpl.WORLD_REGISTRY_READY.emit(e -> e.initRegistry(a));
            }
        }

        private static Holder<WorldPreset> defaultServerPreset() {
            return org.betterx.worlds.together.worldPreset.WorldPresets.get(LAST_REGISTRY_ACCESS, org.betterx.worlds.together.worldPreset.WorldPresets.getDEFAULT());
        }

        private static WorldDimensions defaultServerDimensions() {
            Holder<WorldPreset> defaultPreset = Helpers.defaultServerPreset();
            return Helpers.defaultServerDimensions(defaultPreset);
        }

        private static WorldDimensions defaultServerDimensions(Holder<WorldPreset> defaultPreset) {
            WorldDimensions dimensions;
            Object object = defaultPreset.m_203334_();
            if (object instanceof TogetherWorldPreset) {
                TogetherWorldPreset t = (TogetherWorldPreset)((Object)object);
                dimensions = t.getWorldDimensions();
            } else {
                dimensions = TogetherWorldPreset.getWorldDimensions((ResourceKey<WorldPreset>)WorldPresets.f_226437_);
            }
            return dimensions;
        }

        private static Holder<WorldPreset> presetFromDatapack(Holder<WorldPreset> currentPreset) {
            Optional presetKey;
            if (currentPreset != null && LAST_REGISTRY_ACCESS != null && (presetKey = currentPreset.m_203543_()).isPresent()) {
                Optional newPreset = LAST_REGISTRY_ACCESS.m_175515_(Registries.f_256729_).m_203636_((ResourceKey)presetKey.get());
                currentPreset = newPreset.orElse(null);
            }
            return currentPreset;
        }
    }

    public static class InFreshLevel {
        public static void setupNewWorld(String levelID, WorldDimensions worldDims, LevelStorageSource levelSource, Holder<WorldPreset> worldPreset) {
            try {
                LevelStorageSource.LevelStorageAccess levelStorageAccess = levelSource.m_78260_(levelID);
                InGUI.setupNewWorldCommon(levelStorageAccess, worldPreset, worldDims, false);
                levelStorageAccess.close();
            }
            catch (Exception e) {
                WorldsTogether.LOGGER.error("Failed to initialize data in world", e);
            }
        }
    }

    public static class InGUI {
        public static void registryReadyOnNewWorld(WorldCreationContext worldGenSettingsComponent) {
            Helpers.onRegistryReady((RegistryAccess)worldGenSettingsComponent.m_246480_());
        }

        public static void registryReady(RegistryAccess access) {
            Helpers.onRegistryReady(access);
        }

        public static void setupNewWorld(Optional<LevelStorageSource.LevelStorageAccess> levelStorageAccess, WorldCreationUiState uiState, boolean recreated) {
            if (levelStorageAccess.isPresent()) {
                Holder<WorldPreset> currentPreset = uiState.m_267828_().f_267398_();
                currentPreset = Helpers.presetFromDatapack(currentPreset);
                Holder<WorldPreset> newPreset = InGUI.setupNewWorldCommon(levelStorageAccess.get(), currentPreset, uiState.m_267573_().f_243796_(), recreated);
                if (newPreset != null && newPreset != currentPreset) {
                    uiState.m_267576_(new WorldCreationUiState.WorldTypeEntry(newPreset));
                }
            } else {
                WorldsTogether.LOGGER.error("Unable to access Level Folder.");
            }
        }

        static Holder<WorldPreset> setupNewWorldCommon(LevelStorageSource.LevelStorageAccess levelStorageAccess, Holder<WorldPreset> currentPreset, WorldDimensions worldDims, boolean recreated) {
            WorldDimensions dimensions;
            Object object;
            if (currentPreset != null && (object = currentPreset.m_203334_()) instanceof TogetherWorldPreset) {
                TogetherWorldPreset t = (TogetherWorldPreset)((Object)object);
                dimensions = t.getWorldDimensions();
            } else {
                dimensions = recreated ? worldDims : TogetherWorldPreset.getWorldDimensions((ResourceKey<WorldPreset>)WorldPresets.f_226437_);
            }
            WorldBootstrap.setupWorld(levelStorageAccess, TogetherWorldPreset.getDimensionMap(dimensions), true, false);
            WorldBootstrap.writeWorldPresets(worldDims, currentPreset);
            WorldBootstrap.finishedWorldLoad();
            return currentPreset;
        }

        public static void setupLoadedWorld(String levelID, LevelStorageSource levelSource) {
            try {
                LevelStorageSource.LevelStorageAccess levelStorageAccess = levelSource.m_78260_(levelID);
                WorldBootstrap.setupWorld(levelStorageAccess, TogetherWorldPreset.loadWorldDimensions(), false, false);
                levelStorageAccess.close();
            }
            catch (Exception e) {
                WorldsTogether.LOGGER.error("Failed to acquire storage access", e);
            }
        }

        public static boolean applyWorldPatches(LevelStorageSource levelSource, String levelID, Consumer<Boolean> onResume) {
            boolean result = false;
            try {
                LevelStorageSource.LevelStorageAccess levelStorageAccess = levelSource.m_78260_(levelID);
                result = WorldEventsImpl.PATCH_WORLD.applyPatches(levelStorageAccess, onResume);
                levelStorageAccess.close();
            }
            catch (Exception e) {
                WorldsTogether.LOGGER.error("Failed to initialize data in world", e);
            }
            return result;
        }
    }

    public static class DedicatedServer {
        public static void registryReady(RegistryAccess acc) {
            Helpers.onRegistryReady(acc);
        }

        public static void setupWorld(LevelStorageSource.LevelStorageAccess levelStorageAccess) {
            File levelDat = levelStorageAccess.m_78283_(LevelResource.f_78178_).toFile();
            if (!levelDat.exists()) {
                WorldsTogether.LOGGER.info("Creating a new World, no fixes needed");
                WorldDimensions dimensions = Helpers.defaultServerDimensions();
                WorldBootstrap.setupWorld(levelStorageAccess, TogetherWorldPreset.getDimensionMap(dimensions), true, true);
                Holder<WorldPreset> currentPreset = Helpers.defaultServerPreset();
                WorldBootstrap.writeWorldPresets(dimensions, currentPreset);
                WorldBootstrap.finishedWorldLoad();
            } else {
                WorldBootstrap.setupWorld(levelStorageAccess, TogetherWorldPreset.loadWorldDimensions(), false, true);
                WorldBootstrap.finishedWorldLoad();
            }
        }

        public static boolean applyWorldPatches(LevelStorageSource.LevelStorageAccess levelStorageAccess) {
            boolean result = false;
            if (levelStorageAccess.m_78283_(LevelResource.f_78178_).toFile().exists()) {
                try {
                    result = WorldEventsImpl.PATCH_WORLD.applyPatches(levelStorageAccess, null);
                }
                catch (Exception e) {
                    WorldsTogether.LOGGER.error("Failed to initialize data in world", e);
                }
            }
            return result;
        }
    }
}

