/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.util.ModUtil;
import org.jetbrains.annotations.ApiStatus;

public class WorldConfig {
    private static final Map<String, CompoundTag> TAGS = Maps.newHashMap();
    private static final List<String> MODS = Lists.newArrayList();
    private static final String TAG_CREATED = "create_version";
    private static final String TAG_MODIFIED = "modify_version";
    private static File dataDir;

    @ApiStatus.Internal
    public static void setDataDir(File dataDir) {
        WorldConfig.dataDir = dataDir;
    }

    public static void load(File dataDir) {
        WorldConfig.setDataDir(dataDir);
        ((Stream)MODS.stream().parallel()).forEach(modID -> {
            File file = new File(dataDir, modID + ".nbt");
            CompoundTag root = new CompoundTag();
            if (file.exists()) {
                try {
                    root = NbtIo.m_128937_((File)file);
                }
                catch (IOException e) {
                    WorldsTogether.LOGGER.error("World data loading failed", e);
                }
                TAGS.put((String)modID, root);
            } else {
                Optional optional = FabricLoader.getInstance().getModContainer(modID);
                if (optional.isPresent()) {
                    ModContainer modContainer = (ModContainer)optional.get();
                    if (WorldsTogether.isDevEnvironment()) {
                        root.m_128359_("version", "255.255.9999");
                    } else {
                        root.m_128359_("version", modContainer.getMetadata().getVersion().toString());
                    }
                    TAGS.put((String)modID, root);
                    WorldConfig.saveFile(modID);
                }
            }
        });
    }

    public static void registerModCache(String modID) {
        if (!MODS.contains(modID)) {
            MODS.add(modID);
        }
    }

    public static CompoundTag getRootTag(String modID) {
        CompoundTag root = TAGS.get(modID);
        if (root == null) {
            root = new CompoundTag();
            root.m_128359_(TAG_CREATED, ModUtil.getModVersion(modID));
            TAGS.put(modID, root);
        }
        return root;
    }

    public static boolean hasMod(String modID) {
        return MODS.contains(modID);
    }

    public static CompoundTag getCompoundTag(String modID, String path) {
        String[] parts = path.split("\\.");
        CompoundTag tag = WorldConfig.getRootTag(modID);
        for (String part : parts) {
            if (tag.m_128441_(part)) {
                tag = tag.m_128469_(part);
                continue;
            }
            CompoundTag t = new CompoundTag();
            tag.m_128365_(part, (Tag)t);
            tag = t;
        }
        return tag;
    }

    public static void saveFile(String modID) {
        try {
            if (dataDir != null && !dataDir.exists()) {
                dataDir.mkdirs();
            }
            CompoundTag tag = WorldConfig.getRootTag(modID);
            tag.m_128359_(TAG_MODIFIED, ModUtil.getModVersion(modID));
            File tempFile = new File(dataDir, modID + "_temp.nbt");
            NbtIo.m_128944_((CompoundTag)tag, (File)tempFile);
            File oldFile = new File(dataDir, modID + "_old.nbt");
            File dataFile = new File(dataDir, modID + ".nbt");
            Util.m_137462_((File)dataFile, (File)tempFile, (File)oldFile);
        }
        catch (IOException e) {
            WorldsTogether.LOGGER.error("World data saving failed", e);
        }
    }

    public static String getModVersion(String modID) {
        return WorldConfig.getRootTag(modID).m_128461_("version");
    }

    public static int getIntModVersion(String modID) {
        return ModUtil.convertModVersion(WorldConfig.getModVersion(modID));
    }
}

