/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.tag.v3;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.tags.TagManager;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.interfaces.TriConsumer;
import org.betterx.bclib.util.Pair;
import org.betterx.worlds.together.WorldsTogether;

public class TagRegistry<T> {
    boolean isFrozen = false;
    public final String directory;
    private final Map<TagKey<T>, Set<TagEntry>> tags = Maps.newConcurrentMap();
    public final ResourceKey<? extends Registry<T>> registryKey;
    private final Function<T, ResourceLocation> locationProvider;

    private TagRegistry(ResourceKey<? extends Registry<T>> registry, String directory, Function<T, ResourceLocation> locationProvider) {
        this.registryKey = registry;
        this.directory = directory;
        this.locationProvider = locationProvider;
    }

    protected void initializeTag(TagKey<T> tag) {
        this.getSetForTag(tag);
    }

    public Set<TagEntry> getSetForTag(TagKey<T> tag) {
        if (tag == null) {
            return new HashSet<TagEntry>();
        }
        return this.tags.computeIfAbsent(tag, k -> Sets.newHashSet());
    }

    public TagKey<T> makeTag(String modId, String name) {
        return this.makeTag(new ResourceLocation(modId, name));
    }

    public TagKey<T> makeTag(ResourceLocation id) {
        return this.creatTagKey(id);
    }

    protected TagKey<T> creatTagKey(ResourceLocation id) {
        TagKey tag = TagKey.m_203882_(this.registryKey, (ResourceLocation)id);
        this.initializeTag(tag);
        return tag;
    }

    public TagKey<T> makeCommonTag(String name) {
        return this.creatTagKey(new ResourceLocation("c", name));
    }

    public TagKey<T> makeTogetherTag(String name) {
        return this.creatTagKey(WorldsTogether.makeID(name));
    }

    public void addUntyped(TagKey<T> tagID, ResourceLocation ... elements) {
        if (this.isFrozen) {
            WorldsTogether.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<TagEntry> set = this.getSetForTag(tagID);
        for (ResourceLocation id : elements) {
            if (id == null) continue;
            set.add(TagEntry.m_215925_((ResourceLocation)id));
        }
    }

    public void addUntyped(ResourceLocation element, TagKey<T> ... tagIDs) {
        for (TagKey<T> tagID : tagIDs) {
            this.addUntyped(tagID, element);
        }
    }

    public void addOtherTags(TagKey<T> tagID, TagKey<T> ... tags) {
        this.addOtherTags(tagID, false, tags);
    }

    public void addOptionalOtherTags(TagKey<T> tagID, TagKey<T> ... tags) {
        this.addOtherTags(tagID, true, tags);
    }

    void addOtherTags(TagKey<T> tagID, boolean optional, TagKey<T> ... tags) {
        if (this.isFrozen) {
            WorldsTogether.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<TagEntry> set = this.getSetForTag(tagID);
        for (TagKey<T> tag : tags) {
            ResourceLocation id = tag.f_203868_();
            if (id == null) continue;
            set.add(optional ? TagEntry.m_215953_((ResourceLocation)id) : TagEntry.m_215949_((ResourceLocation)id));
        }
    }

    protected void add(TagKey<T> tagID, T ... elements) {
        this.add(tagID, false, elements);
    }

    protected void addOptional(TagKey<T> tagID, T ... elements) {
        this.add(tagID, true, elements);
    }

    protected void add(TagKey<T> tagID, boolean optional, T ... elements) {
        if (this.isFrozen) {
            WorldsTogether.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
        }
        Set<TagEntry> set = this.getSetForTag(tagID);
        for (T element : elements) {
            ResourceLocation id = this.locationProvider.apply(element);
            for (TagEntry tagEntry : set) {
                if (tagEntry.m_215924_().f_216196_() || !tagEntry.m_215924_().f_216195_().equals((Object)id)) continue;
                id = null;
                break;
            }
            if (id == null) continue;
            set.add(optional ? TagEntry.m_215943_((ResourceLocation)id) : TagEntry.m_215925_((ResourceLocation)id));
        }
    }

    protected boolean contains(TagKey<T> tagID, T element) {
        Set<TagEntry> set = this.getSetForTag(tagID);
        ResourceLocation id = this.locationProvider.apply(element);
        if (id != null) {
            for (TagEntry entry : set) {
                if (entry.m_215924_().f_216196_() || !id.equals((Object)entry.m_215924_().f_216195_())) continue;
                return true;
            }
        }
        return false;
    }

    protected void add(T element, TagKey<T> ... tagIDs) {
        for (TagKey<T> tagID : tagIDs) {
            this.add(tagID, element);
        }
    }

    public void forEach(BiConsumer<ResourceLocation, Set<TagEntry>> consumer) {
        this.tags.forEach((? super K a, ? super V b) -> consumer.accept(a.f_203868_(), (Set<TagEntry>)b));
    }

    public void forEachTag(TriConsumer<TagKey<T>, List<ResourceLocation>, List<TagKey<T>>> consumer) {
        this.forEachTag(consumer, null);
    }

    public void forEachTag(TriConsumer<TagKey<T>, List<ResourceLocation>, List<TagKey<T>>> consumer, BiPredicate<TagKey<T>, ResourceLocation> allow) {
        this.tags.forEach((? super K tag, ? super V set) -> {
            LinkedList locations = new LinkedList();
            LinkedList tags = new LinkedList();
            set.forEach((? super T e) -> {
                ExtraCodecs.TagOrElementLocation t = e.m_215924_();
                if (allow == null || allow.test((TagKey<T>)tag, t.f_216195_())) {
                    if (t.f_216196_()) {
                        tags.add(TagKey.m_203882_(this.registryKey, (ResourceLocation)t.f_216195_()));
                    } else {
                        locations.add(t.f_216195_());
                    }
                }
            });
            consumer.accept((TagKey<T>)tag, locations, tags);
        });
    }

    public void forEachEntry(TriConsumer<TagKey<T>, List<Pair<ResourceLocation, TagEntry>>, List<Pair<TagKey<T>, TagEntry>>> consumer, BiPredicate<TagKey<T>, ResourceLocation> allow) {
        this.tags.forEach((? super K tag, ? super V set) -> {
            LinkedList locations = new LinkedList();
            LinkedList tags = new LinkedList();
            set.forEach((? super T e) -> {
                ExtraCodecs.TagOrElementLocation t = e.m_215924_();
                if (allow == null || allow.test((TagKey<T>)tag, t.f_216195_())) {
                    if (t.f_216196_()) {
                        tags.add(new Pair<TagKey, TagEntry>(TagKey.m_203882_(this.registryKey, (ResourceLocation)t.f_216195_()), (TagEntry)e));
                    } else {
                        locations.add(new Pair<ResourceLocation, TagEntry>(t.f_216195_(), (TagEntry)e));
                    }
                }
            });
            consumer.accept((TagKey<T>)tag, locations, tags);
        });
    }

    public void apply(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagsMap) {
        if (BCLib.isDatagen()) {
            this.forEach((id, ids) -> TagRegistry.apply(id, tagsMap.computeIfAbsent((ResourceLocation)id, key -> Lists.newArrayList()), ids));
        } else {
            this.tags.clear();
        }
    }

    private static List<TagLoader.EntryWithSource> apply(ResourceLocation id, List<TagLoader.EntryWithSource> builder, Set<TagEntry> ids) {
        ids.forEach((? super T value) -> builder.add(new TagLoader.EntryWithSource(value, "worlds_together")));
        return builder;
    }

    public static class UnTyped<T>
    extends TagRegistry<T> {
        UnTyped(ResourceKey<? extends Registry<T>> registry, String directory) {
            super(registry, directory, t -> {
                throw new RuntimeException("Using Untyped TagType with Type-Dependant access. ");
            });
        }
    }

    public static class Items
    extends RegistryBacked<Item> {
        Items() {
            super(BuiltInRegistries.f_257033_);
        }

        @SafeVarargs
        public final void add(TagKey<Item> tagID, ItemLike ... elements) {
            for (ItemLike element : elements) {
                this.add(tagID, element.m_5456_());
            }
        }

        @SafeVarargs
        public final void addOptional(TagKey<Item> tagID, ItemLike ... elements) {
            for (ItemLike element : elements) {
                this.addOptional(tagID, element.m_5456_());
            }
        }

        @Override
        @SafeVarargs
        public final void add(ItemLike element, TagKey<Item> ... tagIDs) {
            super.add(element.m_5456_(), tagIDs);
        }
    }

    public static class Biomes
    extends Simple<Biome> {
        Biomes(String directory, Function<Biome, ResourceLocation> locationProvider) {
            super(Registries.f_256952_, directory, locationProvider);
        }

        public void add(TagKey<Biome> tagID, ResourceKey<Biome> ... elements) {
            this.add(tagID, false, elements);
        }

        public void addOptional(TagKey<Biome> tagID, ResourceKey<Biome> ... elements) {
            this.add(tagID, true, elements);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(TagKey<Biome> tagID, boolean optional, ResourceKey<Biome> ... elements) {
            if (this.isFrozen) {
                WorldsTogether.LOGGER.warning("Adding Tag " + tagID + " after the API was frozen.", new Object[0]);
            }
            Biomes biomes = this;
            synchronized (biomes) {
                Set<TagEntry> set = this.getSetForTag(tagID);
                for (ResourceKey<Biome> element : elements) {
                    ResourceLocation id = element.m_135782_();
                    for (TagEntry tagEntry : set) {
                        if (tagEntry.m_215924_().f_216196_() || !tagEntry.m_215924_().f_216195_().equals((Object)id)) continue;
                        id = null;
                        break;
                    }
                    if (id == null) continue;
                    set.add(optional ? TagEntry.m_215943_((ResourceLocation)id) : TagEntry.m_215925_((ResourceLocation)id));
                }
            }
        }

        public TagKey<Biome> makeStructureTag(String modID, String name) {
            return this.makeTag(modID, "has_structure/" + name);
        }

        @Override
        public void apply(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagsMap) {
            super.apply(tagsMap);
        }
    }

    public static class Simple<T>
    extends TagRegistry<T> {
        Simple(ResourceKey<? extends Registry<T>> registry, String directory, Function<T, ResourceLocation> locationProvider) {
            super(registry, directory, locationProvider);
        }

        @Override
        @SafeVarargs
        public final void add(TagKey<T> tagID, T ... elements) {
            super.add(tagID, elements);
        }

        @Override
        @SafeVarargs
        public final void addOptional(TagKey<T> tagID, T ... elements) {
            super.addOptional(tagID, elements);
        }

        @Override
        @SafeVarargs
        public final void add(T element, TagKey<T> ... tagIDs) {
            super.add(element, tagIDs);
        }

        @Override
        public final boolean contains(TagKey<T> tagID, T element) {
            return super.contains(tagID, element);
        }
    }

    public static class RegistryBacked<T>
    extends Simple<T> {
        private final DefaultedRegistry<T> registry;

        RegistryBacked(DefaultedRegistry<T> registry) {
            super(registry.m_123023_(), TagManager.m_203918_((ResourceKey)registry.m_123023_()), element -> {
                ResourceLocation id = registry.m_7981_(element);
                if (id != registry.m_122315_()) {
                    return id;
                }
                return null;
            });
            this.registry = registry;
        }

        @Override
        public TagKey<T> makeTag(ResourceLocation id) {
            TagKey tag = this.registry.m_203613_().filter(tagKey -> tagKey.f_203868_().equals((Object)id)).findAny().orElse(TagKey.m_203882_((ResourceKey)this.registry.m_123023_(), (ResourceLocation)id));
            this.initializeTag(tag);
            return tag;
        }
    }
}

