/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.surfaceRules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.chunkgenerator.InjectableSurfaceRules;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleProvider;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleRegistry;
import org.betterx.worlds.together.world.event.WorldBootstrap;

public class SurfaceRuleUtil {
    private static List<SurfaceRules.RuleSource> getRulesForBiome(ResourceLocation biomeID) {
        Registry registry = null;
        if (WorldBootstrap.getLastRegistryAccess() != null) {
            registry = WorldBootstrap.getLastRegistryAccess().m_175515_(SurfaceRuleRegistry.SURFACE_RULES_REGISTRY);
        }
        if (registry == null) {
            return List.of();
        }
        return registry.m_123024_().filter(a -> a != null && a.biomeID != null && a.biomeID.equals((Object)biomeID)).map(a -> a.ruleSource).toList();
    }

    private static List<SurfaceRules.RuleSource> getRulesForBiomes(List<Biome> biomes) {
        Registry biomeRegistry = WorldBootstrap.getLastRegistryAccess().m_175515_(Registries.f_256952_);
        List<ResourceLocation> biomeIDs = biomes.stream().map(b -> biomeRegistry.m_7981_(b)).filter(id -> id != null).toList();
        return biomeIDs.stream().map(biomeID -> SurfaceRuleUtil.getRulesForBiome(biomeID)).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedList::new));
    }

    private static SurfaceRules.RuleSource mergeSurfaceRules(ResourceKey<LevelStem> dimensionKey, SurfaceRules.RuleSource org, BiomeSource source, List<SurfaceRules.RuleSource> additionalRules) {
        if (additionalRules == null || additionalRules.isEmpty()) {
            return null;
        }
        int count = additionalRules.size();
        if (org instanceof SurfaceRules.SequenceRuleSource) {
            SurfaceRules.SequenceRuleSource sequenceRule = (SurfaceRules.SequenceRuleSource)org;
            List existingSequence = sequenceRule.f_189697_();
            if ((additionalRules = additionalRules.stream().filter(r -> existingSequence.indexOf(r) < 0).collect(Collectors.toList())).isEmpty()) {
                return null;
            }
            if (dimensionKey.equals((Object)LevelStem.f_63972_)) {
                ArrayList<Object> combined = new ArrayList<Object>(existingSequence.size() + additionalRules.size());
                for (SurfaceRules.RuleSource rule : existingSequence) {
                    SurfaceRules.TestRuleSource testRule;
                    if (rule instanceof SurfaceRules.TestRuleSource && (testRule = (SurfaceRules.TestRuleSource)rule).f_189808_() instanceof SurfaceRules.BiomeConditionSource) {
                        combined.addAll(additionalRules);
                    }
                    combined.add(rule);
                }
                additionalRules = combined;
            } else {
                additionalRules.addAll(existingSequence);
            }
        } else if (!additionalRules.contains(org)) {
            additionalRules.add(org);
        }
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("Merged " + count + " additional Surface Rules for " + source + " => " + additionalRules.size());
        }
        return new SurfaceRules.SequenceRuleSource(additionalRules);
    }

    public static void injectSurfaceRules(ResourceKey<LevelStem> dimensionKey, NoiseGeneratorSettings noiseSettings, BiomeSource loadedBiomeSource) {
        NoiseGeneratorSettings noiseGeneratorSettings = noiseSettings;
        if (noiseGeneratorSettings instanceof SurfaceRuleProvider) {
            SurfaceRuleProvider srp = (SurfaceRuleProvider)noiseGeneratorSettings;
            SurfaceRules.RuleSource originalRules = srp.bclib_getOriginalSurfaceRules();
            srp.bclib_overwriteSurfaceRules(SurfaceRuleUtil.mergeSurfaceRules(dimensionKey, originalRules, loadedBiomeSource, SurfaceRuleUtil.getRulesForBiomes(loadedBiomeSource.m_207840_().stream().map(h -> (Biome)h.m_203334_()).toList())));
        }
    }

    public static void injectSurfaceRulesToAllDimensions(Registry<LevelStem> dimensionRegistry) {
        for (Map.Entry entry : dimensionRegistry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            LevelStem stem = (LevelStem)entry.getValue();
            ChunkGenerator chunkGenerator = stem.f_63976_();
            if (!(chunkGenerator instanceof InjectableSurfaceRules)) continue;
            InjectableSurfaceRules generator = (InjectableSurfaceRules)chunkGenerator;
            generator.injectSurfaceRules((ResourceKey<LevelStem>)key);
        }
    }
}

