/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.levelgen;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.levelgen.BiomeRepairHelper;
import org.betterx.worlds.together.world.BiomeSourceWithNoiseRelatedSettings;
import org.betterx.worlds.together.world.BiomeSourceWithSeed;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.betterx.worlds.together.worldPreset.WorldPresets;
import org.jetbrains.annotations.ApiStatus;

public class WorldGenUtil {
    public static final String TAG_PRESET = "preset";
    public static final String TAG_GENERATOR = "generator";

    public static WorldDimensions createWorldFromPreset(ResourceKey<WorldPreset> preset, RegistryAccess registryAccess, long seed, boolean generateStructures, boolean generateBonusChest) {
        WorldDimensions settings = ((WorldPreset)registryAccess.m_175515_(Registries.f_256729_).m_246971_(preset).m_203334_()).m_247748_();
        for (LevelStem stem : settings.f_243948_()) {
            BiomeSource biomeSource;
            Object bcl;
            BiomeSource biomeSource2 = stem.f_63976_().m_62218_();
            if (biomeSource2 instanceof BiomeSourceWithSeed) {
                bcl = (BiomeSourceWithSeed)biomeSource2;
                bcl.setSeed(seed);
            }
            if (!((biomeSource = stem.f_63976_().m_62218_()) instanceof BiomeSourceWithNoiseRelatedSettings)) continue;
            bcl = (BiomeSourceWithNoiseRelatedSettings)biomeSource;
            biomeSource = stem.f_63976_();
            if (!(biomeSource instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)biomeSource;
            bcl.onLoadGeneratorSettings((NoiseGeneratorSettings)noiseGenerator.m_224341_().m_203334_());
        }
        return settings;
    }

    public static WorldDimensions createDefaultWorldFromPreset(RegistryAccess registryAccess, long seed, boolean generateStructures, boolean generateBonusChest) {
        return WorldGenUtil.createWorldFromPreset(WorldPresets.getDEFAULT(), registryAccess, seed, generateStructures, generateBonusChest);
    }

    public static WorldDimensions createDefaultWorldFromPreset(RegistryAccess registryAccess, long seed) {
        return WorldGenUtil.createDefaultWorldFromPreset(registryAccess, seed, true, false);
    }

    public static WorldDimensions createDefaultWorldFromPreset(RegistryAccess registryAccess) {
        return WorldGenUtil.createDefaultWorldFromPreset(registryAccess, RandomSource.m_216327_().m_188505_());
    }

    public static CompoundTag getPresetsNbt() {
        return WorldConfig.getCompoundTag("worlds_together", TAG_PRESET);
    }

    public static CompoundTag getGeneratorNbt() {
        CompoundTag root = WorldConfig.getRootTag("worlds_together");
        if (root.m_128441_(TAG_GENERATOR)) {
            return WorldConfig.getCompoundTag("worlds_together", TAG_GENERATOR);
        }
        return null;
    }

    @ApiStatus.Internal
    public static Registry<LevelStem> repairBiomeSourceInAllDimensions(RegistryAccess registryAccess, Registry<LevelStem> dimensionRegistry) {
        return new BiomeRepairHelper().repairBiomeSourceInAllDimensions(registryAccess, dimensionRegistry);
    }

    public static ResourceLocation getBiomeID(Biome biome) {
        ResourceLocation id = null;
        RegistryAccess access = WorldBootstrap.getLastRegistryAccessOrElseBuiltin();
        id = access.m_175515_(Registries.f_256952_).m_7981_((Object)biome);
        if (id == null) {
            WorldsTogether.LOGGER.error("Unable to get ID for " + biome + ".");
        }
        return id;
    }

    public static class StemContext {
        public final Holder<DimensionType> dimension;
        public final HolderGetter<StructureSet> structureSets;
        public final Holder<NoiseGeneratorSettings> generatorSettings;

        public StemContext(Holder<DimensionType> dimension, HolderGetter<StructureSet> structureSets, Holder<NoiseGeneratorSettings> generatorSettings) {
            this.dimension = dimension;
            this.structureSets = structureSets;
            this.generatorSettings = generatorSettings;
        }
    }

    public static class Context
    extends StemContext {
        public Context(Holder<DimensionType> dimension, HolderGetter<StructureSet> structureSets, Holder<NoiseGeneratorSettings> generatorSettings) {
            super(dimension, structureSets, generatorSettings);
        }
    }
}

