/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.datagen.bclib.tests;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructureBuilder;
import org.betterx.bclib.util.MHelper;
import org.betterx.datagen.bclib.tests.TestStructurePiece;

public class TestStructure
extends Structure {
    public static final BCLStructure<TestStructure> TEST = ((BCLStructureBuilder)((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start(BCLib.makeID("test_structure"), TestStructure::new).adjustment(TerrainAdjustment.BEARD_THIN)).randomPlacement(16, 8)).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).build();

    protected TestStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    protected Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        BlockPos pos = TestStructure.getGenerationHeight(context.f_226628_(), context.f_226622_(), context.f_226629_(), context.f_226624_());
        if (pos.m_123342_() >= 10) {
            return Optional.of(new Structure.GenerationStub(pos, structurePiecesBuilder -> this.generatePieces((StructurePiecesBuilder)structurePiecesBuilder, context)));
        }
        return Optional.empty();
    }

    private static BlockPos getGenerationHeight(ChunkPos chunkPos, ChunkGenerator chunkGenerator, LevelHeightAccessor levelHeightAccessor, RandomState rState) {
        int blockX = chunkPos.m_151382_(7);
        int blockZ = chunkPos.m_151391_(7);
        int z = chunkGenerator.m_223235_(blockX, blockZ, Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, rState);
        return new BlockPos.MutableBlockPos(blockX, z, blockZ);
    }

    protected void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        int z;
        WorldgenRandom random = context.f_226626_();
        ChunkPos chunkPos = context.f_226628_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        LevelHeightAccessor levelHeightAccessor = context.f_226629_();
        RandomState rState = context.f_226624_();
        int x = chunkPos.m_151382_(MHelper.randRange(4, 12, (RandomSource)random));
        int y = chunkGenerator.m_214096_(x, z = chunkPos.m_151391_(MHelper.randRange(4, 12, (RandomSource)random)), Heightmap.Types.WORLD_SURFACE_WG, levelHeightAccessor, rState);
        if (y > 50) {
            structurePiecesBuilder.m_142679_((StructurePiece)new TestStructurePiece(5, new BoundingBox(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1)));
        }
    }

    public StructureType<?> m_213658_() {
        return TestStructure.TEST.structureType;
    }

    public static void bootstrap(BootstapContext<Structure> bootstrapContext) {
        BCLib.LOGGER.info("Bootstrap Structure");
        TEST.register(bootstrapContext);
    }

    public static void bootstrapSet(BootstapContext<StructureSet> bootstrapContext) {
        BCLib.LOGGER.info("Bootstrap StructureSet");
        TEST.registerSet(bootstrapContext);
    }

    public static void registerBase() {
    }
}

