/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.sdf;

import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PosInfo
implements Comparable<PosInfo> {
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private final Map<BlockPos, PosInfo> blocks;
    private final Map<BlockPos, PosInfo> add;
    private final BlockPos pos;
    private BlockState state;

    public static PosInfo create(Map<BlockPos, PosInfo> blocks, Map<BlockPos, PosInfo> add, BlockPos pos) {
        return new PosInfo(blocks, add, pos);
    }

    private PosInfo(Map<BlockPos, PosInfo> blocks, Map<BlockPos, PosInfo> add, BlockPos pos) {
        this.blocks = blocks;
        this.add = add;
        this.pos = pos;
        blocks.put(pos, this);
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockState getState(BlockPos pos) {
        PosInfo info = this.blocks.get(pos);
        if (info == null) {
            info = this.add.get(pos);
            return info == null ? AIR : info.getState();
        }
        return info.getState();
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public void setState(BlockPos pos, BlockState state) {
        PosInfo info = this.blocks.get(pos);
        if (info != null) {
            info.setState(state);
        }
    }

    public BlockState getState(Direction dir) {
        PosInfo info = this.blocks.get(this.pos.m_121945_(dir));
        if (info == null) {
            info = this.add.get(this.pos.m_121945_(dir));
            return info == null ? AIR : info.getState();
        }
        return info.getState();
    }

    public BlockState getState(Direction dir, int distance) {
        PosInfo info = this.blocks.get(this.pos.m_5484_(dir, distance));
        if (info == null) {
            return AIR;
        }
        return info.getState();
    }

    public BlockState getStateUp() {
        return this.getState(Direction.UP);
    }

    public BlockState getStateDown() {
        return this.getState(Direction.DOWN);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PosInfo)) {
            return false;
        }
        return this.pos.equals((Object)((PosInfo)obj).pos);
    }

    @Override
    public int compareTo(PosInfo info) {
        return this.pos.m_123342_() - info.pos.m_123342_();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setBlockPos(BlockPos pos, BlockState state) {
        PosInfo info = new PosInfo(this.blocks, this.add, pos);
        info.state = state;
        this.add.put(pos, info);
    }
}

