/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v3.datagen.DatapackRecipeBuilder;
import org.betterx.bclib.api.v3.datagen.RecipeDataProvider;
import org.betterx.bclib.util.RecipeHelper;

public abstract class AbstractBaseRecipeBuilder<T extends AbstractBaseRecipeBuilder>
implements DatapackRecipeBuilder {
    protected final ResourceLocation id;
    protected final ItemStack output;
    protected String group;
    protected RecipeCategory category;
    protected boolean alright;

    protected AbstractBaseRecipeBuilder(ResourceLocation id, ItemStack output) {
        this.id = id;
        this.output = output;
        this.category = RecipeCategory.MISC;
        this.alright = RecipeHelper.exists((ItemLike)output.m_41720_());
    }

    protected AbstractBaseRecipeBuilder(ResourceLocation id, ItemLike output) {
        this(id, new ItemStack(output, 1));
    }

    public T setCategory(RecipeCategory category) {
        this.category = category;
        return (T)this;
    }

    protected T setGroup(String group) {
        this.group = group;
        return (T)this;
    }

    protected T setOutputCount(int count) {
        this.output.m_41764_(count);
        return (T)this;
    }

    protected T setOutputTag(CompoundTag tag) {
        this.output.m_41751_(tag);
        return (T)this;
    }

    protected T unlockedBy(ItemLike item) {
        this.unlocks("has_" + item.m_5456_().m_5524_(), (CriterionTriggerInstance)RecipeProvider.m_125977_((ItemLike)item.m_5456_()));
        return (T)this;
    }

    protected T unlockedBy(TagKey<Item> tag) {
        this.unlocks("has_tag_" + tag.f_203868_().m_135827_() + "_" + tag.f_203868_().m_135815_(), (CriterionTriggerInstance)RecipeProvider.m_206406_(tag));
        return (T)this;
    }

    protected T unlockedBy(ItemLike ... items) {
        Object name = "has_" + Arrays.stream(items).map(block -> block instanceof Block ? BuiltInRegistries.f_256975_.m_7981_((Object)((Block)block)) : BuiltInRegistries.f_257033_.m_7981_((Object)((Item)block))).filter(id -> id != null).map(id -> id.m_135815_()).collect(Collectors.joining("_"));
        if (((String)name).length() > 45) {
            name = ((String)name).substring(0, 42);
        }
        return this.unlocks((String)name, items);
    }

    protected T unlocks(String name, ItemLike ... items) {
        return this.unlocks(name, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items));
    }

    protected T unlockedBy(ItemStack ... stacks) {
        ItemLike[] items = (ItemLike[])Arrays.stream(stacks).filter(stack -> stack.m_41613_() > 0).map(stack -> stack.m_41720_()).toArray(ItemLike[]::new);
        return this.unlockedBy(items);
    }

    protected abstract T unlocks(String var1, CriterionTriggerInstance var2);

    public final T build() {
        if (!this.checkRecipe()) {
            return (T)this;
        }
        RecipeDataProvider.register(this);
        return (T)this;
    }

    protected boolean checkRecipe() {
        if (this.output == null) {
            BCLib.LOGGER.warning("Output for Recipe can't be 'null', recipe {} will be ignored!", this.id);
            return false;
        }
        if (this.output.m_150930_(Items.f_41852_)) {
            BCLib.LOGGER.warning("Unable to build Recipe " + this.id + ": Result is AIR", new Object[0]);
            return false;
        }
        if (!this.alright) {
            BCLib.LOGGER.debug("Can't add recipe {}! Ingeredient or output do not exists.", this.id);
            return false;
        }
        return true;
    }

    protected abstract void buildRecipe(Consumer<FinishedRecipe> var1);

    @Override
    public final void build(Consumer<FinishedRecipe> cc) {
        if (!this.checkRecipe()) {
            return;
        }
        this.buildRecipe(cc);
    }

    @Override
    public final ResourceLocation getId() {
        return this.id;
    }
}

