/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.furniture.block;

import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.furniture.block.BaseChair;
import org.betterx.bclib.furniture.entity.EntityChair;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.betterx.bclib.util.BlocksHelper;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChair
extends BaseBlockNotFull {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private final float height;

    public AbstractChair(Block block, int height) {
        super(FabricBlockSettings.copyOf((BlockBehaviour)block).m_60955_());
        this.height = ((float)height - 3.0f) / 16.0f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        EntityChair entity;
        if (world.f_46443_) {
            return InteractionResult.FAIL;
        }
        if (player.m_20159_() || player.m_5833_()) {
            return InteractionResult.FAIL;
        }
        Optional<EntityChair> active = this.getEntity(world, pos);
        if (active.isEmpty()) {
            entity = this.createEntity(state, world, pos);
        } else {
            entity = active.get();
            if (entity.m_20160_()) {
                return InteractionResult.FAIL;
            }
        }
        if (entity != null) {
            float yaw = ((Direction)state.m_61143_((Property)FACING)).m_122424_().m_122435_();
            player.m_7998_((Entity)entity, true);
            player.m_5618_(yaw);
            player.m_5616_(yaw);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    private EntityChair createEntity(BlockState state, Level world, BlockPos pos) {
        BCLib.LOGGER.info("Creating Chair at " + pos + ", " + state);
        double px = (double)pos.m_123341_() + 0.5;
        double py = (float)pos.m_123342_() + this.height;
        double pz = (double)pos.m_123343_() + 0.5;
        float yaw = ((Direction)state.m_61143_((Property)FACING)).m_122424_().m_122435_();
        EntityChair entity = (EntityChair)BaseBlockEntities.CHAIR.m_20615_(world);
        entity.m_7678_(px, py, pz, yaw, 0.0f);
        entity.m_20242_(true);
        entity.m_20225_(true);
        entity.m_6842_(true);
        entity.m_5616_(yaw);
        entity.m_5618_(yaw);
        if (!world.m_7967_((Entity)entity)) {
            entity = null;
        }
        return entity;
    }

    private Optional<EntityChair> getEntity(Level level, BlockPos pos) {
        List list = level.m_6443_(EntityChair.class, new AABB(pos), entity -> true);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((EntityChair)((Object)list.get(0)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.m_6807_(blockState, level, blockPos, blockState2, bl);
        BCLib.LOGGER.info("Created at " + blockPos + ", " + blockState + ", " + blockState2);
        if (blockState.m_61138_((Property)BaseChair.TOP) && ((Boolean)blockState.m_61143_((Property)BaseChair.TOP)).booleanValue()) {
            return;
        }
        this.createEntity(blockState, level, blockPos);
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.m_6810_(blockState, level, blockPos, blockState2, bl);
    }
}

