/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials.set.wood;

import java.util.function.Consumer;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.blocks.signs.BaseHangingSignBlock;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.BlockEntry;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.betterx.bclib.complexmaterials.entry.RecipeEntry;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.recipes.CraftingRecipeBuilder;
import org.jetbrains.annotations.NotNull;

public class HangingSign
extends MaterialSlot<WoodenComplexMaterial> {
    @NotNull
    public static final String WALL_SUFFFIX = "wall_hanging_sign";

    public HangingSign() {
        super("hanging_sign");
    }

    @Override
    public void addBlockEntry(WoodenComplexMaterial parentMaterial, Consumer<BlockEntry> adder) {
        BlockEntry signEntry = new BlockEntry(this.suffix, (complexMaterial, settings) -> new BaseHangingSignBlock.Wood(parentMaterial.woodType));
        BlockEntry wallSignEntry = new BlockEntry(WALL_SUFFFIX, false, (complexMaterial, settings) -> {
            Block patt1293$temp = complexMaterial.getBlock(this.suffix);
            if (patt1293$temp instanceof BaseHangingSignBlock) {
                BaseHangingSignBlock sign = (BaseHangingSignBlock)patt1293$temp;
                return sign.getWallSignBlock();
            }
            return null;
        });
        adder.accept(signEntry);
        adder.accept(wallSignEntry);
    }

    @Override
    public void addRecipeEntry(WoodenComplexMaterial parentMaterial, Consumer<RecipeEntry> adder) {
        adder.accept(new RecipeEntry(this.suffix, (mat, id) -> ((CraftingRecipeBuilder)BCLRecipeBuilder.crafting(id, (ItemLike)parentMaterial.getBlock(this.suffix)).setOutputCount(3).setShape("I I", "###", "###").addMaterial('#', new ItemLike[]{parentMaterial.getBlock(WoodSlots.STRIPPED_LOG)}).addMaterial('I', new ItemLike[]{Items.f_42026_}).setGroup("sign").setCategory(RecipeCategory.DECORATIONS)).build()));
    }
}

