/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials.set.stone;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.StoneComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.MaterialSlot;
import org.betterx.bclib.complexmaterials.set.common.AbstractStairs;
import org.betterx.bclib.complexmaterials.set.stone.StoneSlots;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.recipes.StonecutterRecipeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Stairs
extends AbstractStairs<StoneComplexMaterial> {
    private final MaterialSlot<StoneComplexMaterial> base;

    public Stairs() {
        this.base = StoneSlots.SOURCE;
    }

    public Stairs(MaterialSlot<StoneComplexMaterial> base) {
        super(base.suffix);
        this.base = base;
    }

    @Override
    @NotNull
    protected Block createBlock(StoneComplexMaterial parentMaterial, BlockBehaviour.Properties settings) {
        return new BaseStairsBlock.Stone(parentMaterial.getBlock(this.getSourceBlockSlot()));
    }

    @Override
    @Nullable
    protected void makeRecipe(ComplexMaterial parentMaterial, ResourceLocation id) {
        super.makeRecipe(parentMaterial, id);
        ((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting(new ResourceLocation(id.m_135827_(), "stonecutter_" + id.m_135815_()), (ItemLike)parentMaterial.getBlock(this.suffix)).setPrimaryInputAndUnlock(new ItemLike[]{parentMaterial.getBlock(this.getSourceBlockSlot())})).setOutputCount(1).setGroup("stairs").build();
    }

    @Override
    @Nullable
    protected MaterialSlot<StoneComplexMaterial> getSourceBlockSlot() {
        return this.base;
    }
}

