/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public abstract class HumanoidArmorRenderer
implements ArmorRenderer {
    public void render(PoseStack pose, MultiBufferSource buffer, ItemStack stack, LivingEntity entity, EquipmentSlot slot, int light, HumanoidModel<LivingEntity> parentModel) {
        HumanoidModel<LivingEntity> model = this.getModelForSlot(entity, slot);
        if (model != null) {
            Item item = stack.m_41720_();
            if (!(item instanceof ArmorItem)) {
                return;
            }
            ArmorItem armorItem = (ArmorItem)item;
            if (armorItem.m_40402_() != slot) {
                return;
            }
            parentModel.m_102872_(model);
            if (model instanceof CopyExtraState) {
                CopyExtraState mdl = (CopyExtraState)model;
                mdl.copyPropertiesFrom(parentModel);
            }
            this.setPartVisibility(model, slot);
            this.renderModel(pose, buffer, light, model, this.getTextureForSlot(slot, this.usesInnerModel(slot)), 1.0f, 1.0f, 1.0f);
            if (stack.m_41790_()) {
                this.renderGlint(pose, buffer, light, model);
            }
        }
    }

    @NotNull
    protected abstract ResourceLocation getTextureForSlot(EquipmentSlot var1, boolean var2);

    protected abstract HumanoidModel<LivingEntity> getModelForSlot(LivingEntity var1, EquipmentSlot var2);

    protected boolean usesInnerModel(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS;
    }

    protected void renderModel(PoseStack pose, MultiBufferSource buffer, int light, HumanoidModel<LivingEntity> humanoidModel, ResourceLocation texture, float r, float g, float b) {
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110431_((ResourceLocation)texture));
        humanoidModel.m_7695_(pose, vertexConsumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }

    protected void renderGlint(PoseStack pose, MultiBufferSource buffer, int light, HumanoidModel<LivingEntity> humanoidModel) {
        humanoidModel.m_7695_(pose, buffer.m_6299_(RenderType.m_110484_()), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected void setPartVisibility(HumanoidModel<LivingEntity> humanoidModel, EquipmentSlot equipmentSlot) {
        humanoidModel.m_8009_(false);
        switch (equipmentSlot) {
            case HEAD: {
                humanoidModel.f_102808_.f_104207_ = true;
                humanoidModel.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                humanoidModel.f_102810_.f_104207_ = true;
                humanoidModel.f_102811_.f_104207_ = true;
                humanoidModel.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                humanoidModel.f_102810_.f_104207_ = true;
                humanoidModel.f_102813_.f_104207_ = true;
                humanoidModel.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                humanoidModel.f_102813_.f_104207_ = true;
                humanoidModel.f_102814_.f_104207_ = true;
            }
        }
    }

    public static interface CopyExtraState {
        public void copyPropertiesFrom(HumanoidModel<LivingEntity> var1);
    }
}

