/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks.signs;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.signs.BaseWallHangingSignBlock;
import org.betterx.bclib.complexmaterials.BCLWoodTypeWrapper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.CustomItemProvider;
import org.betterx.bclib.interfaces.TagProvider;

public abstract class BaseHangingSignBlock
extends CeilingHangingSignBlock
implements BlockModelProvider,
CustomItemProvider,
TagProvider {
    protected final Supplier<BaseWallHangingSignBlock> wallSign = () -> provider.create(BehaviourBuilders.createWallSign(color, (Block)this, flammable), type);
    private BlockItem customItem;
    private BaseWallHangingSignBlock wallSignBlock;

    protected BaseHangingSignBlock(WoodType type, MapColor color, boolean flammable, WallSignProvider provider) {
        super(BehaviourBuilders.createSign(color, flammable), type);
    }

    public BaseWallHangingSignBlock getWallSignBlock() {
        if (this.wallSignBlock == null) {
            this.wallSignBlock = this.wallSign.get();
        }
        return this.wallSignBlock;
    }

    public float m_276903_(BlockState blockState) {
        return RotationSegment.m_245107_((int)((Integer)blockState.m_61143_((Property)StandingSignBlock.f_56987_)));
    }

    @Override
    public BlockItem getCustomItem(ResourceLocation blockID, Item.Properties settings) {
        if (this.customItem == null) {
            this.customItem = new HangingSignItem((Block)this, (Block)this.getWallSignBlock(), settings.m_41487_(16));
        }
        return this.customItem;
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_243838_);
        itemTags.add((TagKey<Item>)ItemTags.f_244389_);
    }

    public static BaseHangingSignBlock from(WoodType type) {
        return new Wood(type);
    }

    @FunctionalInterface
    public static interface WallSignProvider {
        public BaseWallHangingSignBlock create(BlockBehaviour.Properties var1, WoodType var2);
    }

    public static class Wood
    extends BaseHangingSignBlock
    implements BehaviourWood {
        public Wood(WoodType type) {
            this(type, MapColor.f_283825_, true);
        }

        public Wood(BCLWoodTypeWrapper type) {
            this(type.type, type.color, type.flammable);
        }

        public Wood(WoodType type, MapColor color, boolean flammable) {
            super(type, color, flammable, BaseWallHangingSignBlock.Wood::new);
        }
    }

    public static class Metal
    extends BaseHangingSignBlock
    implements BehaviourMetal {
        public Metal(WoodType type) {
            this(type, MapColor.f_283825_, true);
        }

        public Metal(BCLWoodTypeWrapper type) {
            this(type.type, type.color, type.flammable);
        }

        public Metal(WoodType type, MapColor color, boolean flammable) {
            super(type, color, flammable, BaseWallHangingSignBlock.Stone::new);
        }
    }

    public static class Stone
    extends BaseHangingSignBlock
    implements BehaviourStone {
        public Stone(WoodType type) {
            this(type, MapColor.f_283825_, true);
        }

        public Stone(BCLWoodTypeWrapper type) {
            this(type.type, type.color, type.flammable);
        }

        public Stone(WoodType type, MapColor color, boolean flammable) {
            super(type, color, flammable, BaseWallHangingSignBlock.Stone::new);
        }
    }
}

