/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.blocks.BaseAnvilBlock;

public class LeveledAnvilBlock
extends BaseAnvilBlock {
    protected final int level;

    public LeveledAnvilBlock(MapColor color, int level) {
        super(color);
        this.level = level;
    }

    public static int getAnvilCraftingLevel(Block anvil) {
        if (anvil instanceof LeveledAnvilBlock) {
            LeveledAnvilBlock l = (LeveledAnvilBlock)anvil;
            return l.getCraftingLevel();
        }
        if (anvil == Blocks.f_50322_ || anvil == Blocks.f_50323_ || anvil == Blocks.f_50324_) {
            return Tiers.IRON.m_6604_() - 1;
        }
        return 0;
    }

    public static boolean canHandle(Block anvil, int level) {
        return LeveledAnvilBlock.getAnvilCraftingLevel(anvil) >= level;
    }

    public static List<Block> getAnvils() {
        return BuiltInRegistries.f_256975_.m_123024_().filter(b -> b instanceof LeveledAnvilBlock || b == Blocks.f_50322_).toList();
    }

    public static List<FormattedCharSequence> getNamesForLevel(int level) {
        MutableComponent names = LeveledAnvilBlock.getAnvils().stream().filter(b -> LeveledAnvilBlock.canHandle(b, level)).map(Block::m_49954_).reduce(null, (p, c) -> p == null ? c : p.m_7220_((Component)Component.m_237113_((String)", ")).m_7220_((Component)c));
        if (names == null) {
            return List.of();
        }
        return Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)names, 200);
    }

    public int getCraftingLevel() {
        return this.level;
    }
}

