/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.blockentities.BaseFurnaceBlockEntity;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.registry.BaseBlockEntities;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFurnaceBlock
extends FurnaceBlock
implements BlockModelProvider,
RenderLayerProvider {
    public BaseFurnaceBlock(Block source) {
        this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source).m_60953_(state -> (Boolean)state.m_61143_((Property)f_48684_) != false ? 13 : 0));
    }

    public BaseFurnaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BaseFurnaceBlockEntity(blockPos, blockState);
    }

    protected void m_7137_(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BaseFurnaceBlockEntity) {
            player.m_5893_((MenuProvider)blockEntity);
            player.m_36220_(Stats.f_12966_);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation blockId, BlockState blockState) {
        Optional<String> pattern;
        String blockName = blockId.m_135815_();
        HashMap textures = Maps.newHashMap();
        textures.put("%modid%", blockId.m_135827_());
        textures.put("%top%", blockName + "_top");
        textures.put("%side%", blockName + "_side");
        if (((Boolean)blockState.m_61143_((Property)f_48684_)).booleanValue()) {
            textures.put("%front%", blockName + "_front_on");
            textures.put("%glow%", blockName + "_glow");
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_FURNACE_LIT, textures);
        } else {
            textures.put("%front%", blockName + "_front");
            pattern = PatternsHelper.createJson(BasePatterns.BLOCK_FURNACE, textures);
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.m_49966_());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        String lit = (Boolean)blockState.m_61143_((Property)f_48684_) != false ? "_lit" : "";
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + lit);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createFacingModel(modelId, (Direction)blockState.m_61143_((Property)f_48683_), false, true);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList drop = Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof BaseFurnaceBlockEntity) {
            BaseFurnaceBlockEntity entity = (BaseFurnaceBlockEntity)blockEntity;
            for (int i = 0; i < entity.m_6643_(); ++i) {
                drop.add(entity.m_8020_(i));
            }
        }
        return drop;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BaseFurnaceBlock.createFurnaceTicker(level, blockEntityType, BaseBlockEntities.FURNACE);
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createFurnaceTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends AbstractFurnaceBlockEntity> blockEntityType2) {
        return level.f_46443_ ? null : BaseFurnaceBlock.m_152132_(blockEntityType, blockEntityType2, AbstractFurnaceBlockEntity::m_155013_);
    }

    public static class Stone
    extends BaseFurnaceBlock
    implements BehaviourStone {
        public Stone(Block source) {
            super(source);
        }

        public Stone(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

