/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCraftingTableBlock
extends CraftingTableBlock
implements BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseCraftingTableBlock> {
    protected BaseCraftingTableBlock(Block source) {
        this(BlockBehaviour.Properties.m_60926_((BlockBehaviour)source));
    }

    protected BaseCraftingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.m_49966_());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(final ResourceLocation blockId, BlockState blockState) {
        final String blockName = blockId.m_135815_();
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.BLOCK_SIDED, (Map<String, String>)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("%modid%", blockId.m_135827_());
                this.put("%particle%", blockName + "_front");
                this.put("%down%", blockName + "_bottom");
                this.put("%up%", blockName + "_top");
                this.put("%north%", blockName + "_front");
                this.put("%south%", blockName + "_side");
                this.put("%west%", blockName + "_front");
                this.put("%east%", blockName + "_side");
            }
        });
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add(CommonBlockTags.WORKBENCHES);
        itemTags.add(CommonItemTags.WORKBENCHES);
    }

    public static BaseCraftingTableBlock from(Block source) {
        return new Wood(source);
    }

    public static class Wood
    extends BaseCraftingTableBlock
    implements BehaviourWood {
        public Wood(Block source) {
            super(source);
        }

        public Wood(BlockBehaviour.Properties properties) {
            super(properties);
        }
    }
}

