/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.behaviours.interfaces.BehaviourGlass;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.util.BlocksHelper;

public abstract class BaseAttachedBlock
extends BaseBlockNotFull {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    protected BaseAttachedBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction[] directions;
        BlockState blockState = this.m_49966_();
        Level worldView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        for (Direction direction : directions = ctx.m_6232_()) {
            Direction direction2 = direction.m_122424_();
            if (!(blockState = (BlockState)blockState.m_61124_((Property)FACING, (Comparable)direction2)).m_60710_((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockPos = pos.m_121945_(direction.m_122424_());
        return BaseAttachedBlock.m_49863_((LevelReader)world, (BlockPos)blockPos, (Direction)direction) || world.m_8055_(blockPos).m_204336_(BlockTags.f_13035_);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public static class Glass
    extends BaseAttachedBlock
    implements BehaviourGlass {
        public Glass(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Metal
    extends BaseAttachedBlock
    implements BehaviourMetal {
        public Metal(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Stone
    extends BaseAttachedBlock
    implements BehaviourStone {
        public Stone(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Wood
    extends BaseAttachedBlock
    implements BehaviourWood {
        public Wood(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }
}

