/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import org.betterx.bclib.api.v3.levelgen.features.placement.PlacementModifiers;
import org.betterx.bclib.util.BlocksHelper;

public class FindSolidInDirection
extends PlacementModifier {
    public static final Codec<FindSolidInDirection> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_144637_((Codec)Direction.f_175356_.listOf()).fieldOf("dir").orElse(List.of(Direction.DOWN)).forGetter(a -> a.direction), (App)Codec.intRange((int)1, (int)32).fieldOf("dist").orElse((Object)12).forGetter(p -> p.maxSearchDistance), (App)Codec.BOOL.fieldOf("random_select").orElse((Object)true).forGetter(p -> p.randomSelect), (App)Codec.INT.fieldOf("offset_in_dir").orElse((Object)0).forGetter(p -> p.offsetInDir)).apply((Applicative)instance, FindSolidInDirection::new));
    protected static final FindSolidInDirection DOWN = new FindSolidInDirection(Direction.DOWN, 6, 0);
    protected static final FindSolidInDirection UP = new FindSolidInDirection(Direction.UP, 6, 0);
    private final List<Direction> direction;
    private final int maxSearchDistance;
    private final int offsetInDir;
    private final boolean randomSelect;
    private final IntProvider provider;

    public FindSolidInDirection(Direction direction, int maxSearchDistance, int offsetInDir) {
        this(List.of(direction), maxSearchDistance, false, offsetInDir);
    }

    public FindSolidInDirection(List<Direction> direction, int maxSearchDistance, int offsetInDir) {
        this(direction, maxSearchDistance, direction.size() > 1, offsetInDir);
    }

    public FindSolidInDirection(List<Direction> direction, int maxSearchDistance, boolean randomSelect, int offsetInDir) {
        this.direction = direction;
        this.maxSearchDistance = maxSearchDistance;
        this.provider = UniformInt.m_146622_((int)0, (int)(direction.size() - 1));
        this.randomSelect = randomSelect;
        this.offsetInDir = offsetInDir;
    }

    public static PlacementModifier down() {
        return DOWN;
    }

    public static PlacementModifier up() {
        return UP;
    }

    public static PlacementModifier down(int dist) {
        if (dist == FindSolidInDirection.DOWN.maxSearchDistance && 0 == FindSolidInDirection.DOWN.offsetInDir) {
            return DOWN;
        }
        return new FindSolidInDirection(Direction.DOWN, dist, 0);
    }

    public static PlacementModifier up(int dist) {
        if (dist == FindSolidInDirection.UP.maxSearchDistance && 0 == FindSolidInDirection.UP.offsetInDir) {
            return UP;
        }
        return new FindSolidInDirection(Direction.UP, dist, 0);
    }

    public static PlacementModifier down(int dist, int offset) {
        if (dist == FindSolidInDirection.DOWN.maxSearchDistance && 0 == FindSolidInDirection.DOWN.offsetInDir) {
            return DOWN;
        }
        return new FindSolidInDirection(Direction.DOWN, dist, offset);
    }

    public static PlacementModifier up(int dist, int offset) {
        if (dist == FindSolidInDirection.UP.maxSearchDistance && offset == FindSolidInDirection.UP.offsetInDir) {
            return UP;
        }
        return new FindSolidInDirection(Direction.UP, dist, offset);
    }

    public Direction randomDirection(RandomSource random) {
        return this.direction.get(this.provider.m_214085_(random));
    }

    public Stream<BlockPos> m_213676_(PlacementContext placementContext, RandomSource randomSource, BlockPos blockPos) {
        Stream.Builder<BlockPos> builder = Stream.builder();
        if (this.randomSelect) {
            this.submitSingle(placementContext, blockPos, builder, this.randomDirection(randomSource));
        } else {
            for (Direction d : this.direction) {
                this.submitSingle(placementContext, blockPos, builder, d);
            }
        }
        return builder.build();
    }

    private void submitSingle(PlacementContext placementContext, BlockPos blockPos, Stream.Builder<BlockPos> builder, Direction d) {
        BlockPos.MutableBlockPos POS = blockPos.m_122032_();
        int searchDist = d == Direction.EAST ? Math.min(this.maxSearchDistance, 15 - SectionPos.m_123207_((int)blockPos.m_123341_())) : (d == Direction.WEST ? Math.min(this.maxSearchDistance, SectionPos.m_123207_((int)blockPos.m_123341_())) : (d == Direction.SOUTH ? Math.min(this.maxSearchDistance, 15 - SectionPos.m_123207_((int)blockPos.m_123343_())) : (d == Direction.NORTH ? Math.min(this.maxSearchDistance, SectionPos.m_123207_((int)blockPos.m_123343_())) : this.maxSearchDistance)));
        if (BlocksHelper.findOnSurroundingSurface((LevelAccessor)placementContext.m_191831_(), POS, d, searchDist, BlocksHelper::isTerrain)) {
            if (this.offsetInDir != 0) {
                builder.add((BlockPos)POS.m_122175_(d, this.offsetInDir));
            } else {
                builder.add((BlockPos)POS);
            }
        }
    }

    public PlacementModifierType<?> m_183327_() {
        return PlacementModifiers.SOLID_IN_DIR;
    }
}

