/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLConfigureFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v3.levelgen.features.CommonPlacedFeatureBuilder;
import org.betterx.bclib.util.FullReferenceHolder;

public class BCLPlacedFeatureBuilder<F extends Feature<FC>, FC extends FeatureConfiguration>
extends CommonPlacedFeatureBuilder<F, FC, BCLPlacedFeatureBuilder<F, FC>> {
    private final ResourceLocation featureID;
    private GenerationStep.Decoration decoration = GenerationStep.Decoration.VEGETAL_DECORATION;
    private final BCLConfigureFeature<F, FC> cFeature;
    static final ConcurrentLinkedQueue<BCLFeature.Unregistered> UNBOUND_FEATURES = new ConcurrentLinkedQueue();

    private BCLPlacedFeatureBuilder(ResourceLocation featureID, BCLConfigureFeature<F, FC> cFeature) {
        this.featureID = featureID;
        this.cFeature = cFeature;
    }

    public BCLPlacedFeatureBuilder<F, FC> decoration(GenerationStep.Decoration decoration) {
        this.decoration = decoration;
        return this;
    }

    public static <F extends Feature<FC>, FC extends FeatureConfiguration> BCLPlacedFeatureBuilder<F, FC> place(ResourceLocation featureID, Holder<ConfiguredFeature<FC, F>> holder) {
        return BCLPlacedFeatureBuilder.place(featureID, BCLConfigureFeature.create(holder));
    }

    static <F extends Feature<FC>, FC extends FeatureConfiguration> BCLPlacedFeatureBuilder<F, FC> place(ResourceLocation featureID, BCLConfigureFeature<F, FC> cFeature) {
        return new BCLPlacedFeatureBuilder<F, FC>(featureID, cFeature);
    }

    @Override
    public BCLFeature.Unregistered<F, FC> build() {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)this.featureID);
        PlacedFeature pFeature = new PlacedFeature(this.cFeature.configuredFeature, List.copyOf(this.modifications));
        FullReferenceHolder<PlacedFeature> holder = FullReferenceHolder.create(Registries.f_256988_, this.featureID, pFeature);
        BCLFeature.Unregistered<F, FC> res = new BCLFeature.Unregistered<F, FC>(this.cFeature, holder, this.decoration);
        UNBOUND_FEATURES.add(res);
        return res;
    }

    public static void registerUnbound(BootstapContext<PlacedFeature> bootstrapContext) {
        UNBOUND_FEATURES.forEach(u -> u.register(bootstrapContext));
        UNBOUND_FEATURES.clear();
    }

    public static Holder<PlacedFeature> register(BootstapContext<PlacedFeature> bootstrapContext, Holder<PlacedFeature> holder) {
        return bootstrapContext.m_255272_((ResourceKey)holder.m_203543_().orElseThrow(), (Object)((PlacedFeature)holder.m_203334_()));
    }

    public BCLFeature<F, FC> buildAndRegister(BootstapContext<PlacedFeature> bootstapContext) {
        return this.build().register(bootstapContext);
    }
}

