/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.poi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.api.v2.poi.BCLPoiType;
import org.betterx.bclib.api.v2.poi.PoiTypeExtension;
import org.betterx.worlds.together.tag.v3.CommonPoiTags;
import org.jetbrains.annotations.ApiStatus;

public class PoiManager {
    private static final List<Holder<PoiType>> TYPES_WITH_TAGS = new ArrayList<Holder<PoiType>>(4);
    private static Map<BlockState, Holder<PoiType>> ORIGINAL_BLOCK_STATES = null;

    public static BCLPoiType register(ResourceLocation location, Set<BlockState> matchingStates, int maxTickets, int validRanges) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)location);
        PoiType type = PoiTypes.m_218084_((Registry)BuiltInRegistries.f_256941_, (ResourceKey)key, matchingStates, (int)maxTickets, (int)validRanges);
        return new BCLPoiType((ResourceKey<PoiType>)key, type, matchingStates, maxTickets, validRanges);
    }

    public static void setTag(ResourceKey<PoiType> type, TagKey<Block> tag) {
        Optional oHolder = BuiltInRegistries.f_256941_.m_203636_(type);
        if (oHolder.isPresent()) {
            PoiManager.setTag((PoiType)((Holder.Reference)oHolder.get()).m_203334_(), tag);
            PoiManager.didAddTagFor((Holder<PoiType>)((Holder)oHolder.get()), tag);
        }
    }

    private static void setTag(PoiType type, TagKey<Block> tag) {
        PoiType poiType = type;
        if (poiType instanceof PoiTypeExtension) {
            PoiTypeExtension ext = (PoiTypeExtension)poiType;
            ext.bcl_setTag(tag);
        }
    }

    @ApiStatus.Internal
    public static void registerAll() {
        PoiManager.setTag((ResourceKey<PoiType>)PoiTypes.f_218052_, CommonPoiTags.FISHERMAN_WORKSTATION);
        PoiManager.setTag((ResourceKey<PoiType>)PoiTypes.f_218051_, CommonPoiTags.FARMER_WORKSTATION);
    }

    private static void didAddTagFor(Holder<PoiType> type, TagKey<Block> tag) {
        TYPES_WITH_TAGS.remove(type);
        if (tag != null) {
            TYPES_WITH_TAGS.add(type);
        }
    }

    @ApiStatus.Internal
    public static void updateStates() {
        if (ORIGINAL_BLOCK_STATES == null) {
            ORIGINAL_BLOCK_STATES = new HashMap<BlockState, Holder<PoiType>>(PoiTypes.f_218070_);
        } else {
            PoiTypes.f_218070_.clear();
            PoiTypes.f_218070_.putAll(ORIGINAL_BLOCK_STATES);
        }
        for (Holder<PoiType> type : TYPES_WITH_TAGS) {
            PoiTypeExtension ex;
            TagKey<Block> tag;
            Object object = type.m_203334_();
            if (!(object instanceof PoiTypeExtension) || (tag = (ex = (PoiTypeExtension)object).bcl_getTag()) == null) continue;
            Registry registry = InternalBiomeAPI.worldRegistryAccess().m_175515_(tag.f_203867_());
            for (Holder block : registry.m_206058_(tag)) {
                for (BlockState state : ((Block)block.m_203334_()).m_49965_().m_61056_()) {
                    PoiTypes.f_218070_.put(state, type);
                }
            }
        }
    }
}

