/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.surface.rules;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.ThreadSafeLegacyRandomSource;
import org.betterx.bclib.api.v2.levelgen.surface.rules.VolumeNoiseCondition;
import org.betterx.bclib.mixin.common.SurfaceRulesContextAccessor;
import org.betterx.bclib.noise.OpenSimplexNoise;

public class VolumeThresholdCondition
extends VolumeNoiseCondition {
    private static final Map<Long, Context> NOISES = Maps.newHashMap();
    public static final Codec<VolumeThresholdCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").forGetter(p -> p.noiseContext.seed), (App)Codec.DOUBLE.fieldOf("threshold").orElse((Object)0.0).forGetter(p -> p.threshold), (App)FloatProvider.f_146502_.fieldOf("threshold_offset").orElse((Object)ConstantFloat.m_146458_((float)0.0f)).forGetter(p -> p.range), (App)Codec.DOUBLE.fieldOf("scale_x").orElse((Object)0.1).forGetter(p -> p.scaleX), (App)Codec.DOUBLE.fieldOf("scale_y").orElse((Object)0.1).forGetter(p -> p.scaleY), (App)Codec.DOUBLE.fieldOf("scale_z").orElse((Object)0.1).forGetter(p -> p.scaleZ)).apply((Applicative)instance, VolumeThresholdCondition::new));
    public static final KeyDispatchDataCodec<VolumeThresholdCondition> KEY_CODEC = KeyDispatchDataCodec.m_216236_(CODEC);
    public final Context noiseContext;
    public final double threshold;
    public final FloatProvider range;
    public final double scaleX;
    public final double scaleY;
    public final double scaleZ;

    public VolumeThresholdCondition(long noiseSeed, double threshold, FloatProvider range, double scaleX, double scaleY, double scaleZ) {
        this.threshold = threshold;
        this.range = range;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.noiseContext = NOISES.computeIfAbsent(noiseSeed, seed -> new Context((long)seed));
    }

    public double getValue(SurfaceRulesContextAccessor context) {
        return this.getValue(context.getBlockX(), context.getBlockY(), context.getBlockZ());
    }

    public double getValue(int xx, int yy, int zz) {
        double x = (double)xx * this.scaleX;
        double y = (double)yy * this.scaleY;
        double z = (double)zz * this.scaleZ;
        if (this.noiseContext.lastX == x && this.noiseContext.lastY == y && this.noiseContext.lastZ == z) {
            return this.noiseContext.lastValue + (double)this.range.m_214084_(this.noiseContext.random);
        }
        double value = this.noiseContext.noise.eval(x, y, z);
        this.noiseContext.lastX = x;
        this.noiseContext.lastZ = z;
        this.noiseContext.lastY = y;
        this.noiseContext.lastValue = value;
        return value + (double)this.range.m_214084_(this.noiseContext.random);
    }

    @Override
    public boolean test(SurfaceRulesContextAccessor context) {
        return this.getValue(context) > this.threshold;
    }

    @Override
    public KeyDispatchDataCodec<? extends SurfaceRules.ConditionSource> m_213794_() {
        return KEY_CODEC;
    }

    public static class Context {
        public final OpenSimplexNoise noise;
        public final RandomSource random;
        public final long seed;
        double lastX = -2.147483648E9;
        double lastY = -2.147483648E9;
        double lastZ = -2.147483648E9;
        double lastValue = 0.0;

        Context(long seed) {
            this.seed = seed;
            this.noise = new OpenSimplexNoise(seed);
            this.random = new ThreadSafeLegacyRandomSource(seed * 3L + 1L);
        }
    }
}

