/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class StructureWorld {
    private final Map<ChunkPos, Part> parts = Maps.newHashMap();
    private ChunkPos lastPos;
    private Part lastPart;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int minZ = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int maxZ = Integer.MIN_VALUE;

    public StructureWorld() {
    }

    public StructureWorld(CompoundTag tag) {
        this.minX = tag.m_128451_("minX");
        this.maxX = tag.m_128451_("maxX");
        this.minY = tag.m_128451_("minY");
        this.maxY = tag.m_128451_("maxY");
        this.minZ = tag.m_128451_("minZ");
        this.maxZ = tag.m_128451_("maxZ");
        ListTag map = tag.m_128437_("parts", 10);
        map.forEach(element -> {
            CompoundTag compound = (CompoundTag)element;
            Part part = new Part(compound);
            int x = compound.m_128451_("x");
            int z = compound.m_128451_("z");
            this.parts.put(new ChunkPos(x, z), part);
        });
    }

    public void setBlock(BlockPos pos, BlockState state) {
        ChunkPos cPos = new ChunkPos(pos);
        if (cPos.equals((Object)this.lastPos)) {
            this.lastPart.addBlock(pos, state);
            return;
        }
        Part part = this.parts.get(cPos);
        if (part == null) {
            part = new Part();
            this.parts.put(cPos, part);
            if (cPos.f_45578_ < this.minX) {
                this.minX = cPos.f_45578_;
            }
            if (cPos.f_45578_ > this.maxX) {
                this.maxX = cPos.f_45578_;
            }
            if (cPos.f_45579_ < this.minZ) {
                this.minZ = cPos.f_45579_;
            }
            if (cPos.f_45579_ > this.maxZ) {
                this.maxZ = cPos.f_45579_;
            }
        }
        if (pos.m_123342_() < this.minY) {
            this.minY = pos.m_123342_();
        }
        if (pos.m_123342_() > this.maxY) {
            this.maxY = pos.m_123342_();
        }
        part.addBlock(pos, state);
        this.lastPos = cPos;
        this.lastPart = part;
    }

    public boolean placeChunk(WorldGenLevel world, ChunkPos chunkPos) {
        Part part = this.parts.get(chunkPos);
        if (part != null) {
            ChunkAccess chunk = world.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
            part.placeChunk(chunk);
            return true;
        }
        return false;
    }

    public CompoundTag toBNT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("minX", this.minX);
        tag.m_128405_("maxX", this.maxX);
        tag.m_128405_("minY", this.minY);
        tag.m_128405_("maxY", this.maxY);
        tag.m_128405_("minZ", this.minZ);
        tag.m_128405_("maxZ", this.maxZ);
        ListTag map = new ListTag();
        tag.m_128365_("parts", (Tag)map);
        this.parts.forEach((pos, part) -> map.add((Object)part.toNBT(pos.f_45578_, pos.f_45579_)));
        return tag;
    }

    public BoundingBox getBounds() {
        if (this.minX == Integer.MAX_VALUE || this.maxX == Integer.MIN_VALUE || this.minZ == Integer.MAX_VALUE || this.maxZ == Integer.MIN_VALUE) {
            return BoundingBox.m_71044_();
        }
        return new BoundingBox(this.minX << 4, this.minY, this.minZ << 4, this.maxX << 4 | 0xF, this.maxY, this.maxZ << 4 | 0xF);
    }

    private static final class Part {
        Map<BlockPos, BlockState> blocks = Maps.newHashMap();

        public Part() {
        }

        public Part(CompoundTag tag) {
            ListTag map = tag.m_128437_("blocks", 10);
            ListTag map2 = tag.m_128437_("states", 10);
            BlockState[] states = new BlockState[map2.size()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)((CompoundTag)map2.get(i)));
            }
            map.forEach(element -> {
                CompoundTag block = (CompoundTag)element;
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)block.m_128469_("pos"));
                int stateID = block.m_128451_("state");
                BlockState state = stateID < states.length ? states[stateID] : Block.m_49803_((int)stateID);
                this.blocks.put(pos, state);
            });
        }

        void addBlock(BlockPos pos, BlockState state) {
            BlockPos inner = new BlockPos(pos.m_123341_() & 0xF, pos.m_123342_(), pos.m_123343_() & 0xF);
            this.blocks.put(inner, state);
        }

        void placeChunk(ChunkAccess chunk) {
            this.blocks.forEach((pos, state) -> chunk.m_6978_(pos, state, false));
        }

        CompoundTag toNBT(int x, int z) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", x);
            tag.m_128405_("z", z);
            ListTag map = new ListTag();
            tag.m_128365_("blocks", (Tag)map);
            ListTag stateMap = new ListTag();
            tag.m_128365_("states", (Tag)stateMap);
            int[] id = new int[1];
            HashMap states = Maps.newHashMap();
            this.blocks.forEach((pos, state) -> {
                int stateID = states.getOrDefault(states, -1);
                if (stateID < 0) {
                    int n = id[0];
                    id[0] = n + 1;
                    stateID = n;
                    states.put(state, stateID);
                    stateMap.add((Object)NbtUtils.m_129202_((BlockState)state));
                }
                CompoundTag block = new CompoundTag();
                block.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                block.m_128405_("state", stateID);
                map.add((Object)block);
            });
            return tag;
        }
    }
}

