/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.fabricmc.fabric.api.biome.v1.TheEndBiomes;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BCLBiomeRegistry {
    public static final ResourceKey<Registry<BCLBiome>> BCL_BIOMES_REGISTRY = BCLBiomeRegistry.createRegistryKey(WorldsTogether.makeID("worldgen/betterx/biome"));
    public static final ResourceKey<Registry<Codec<? extends BCLBiome>>> BCL_BIOME_CODEC_REGISTRY = BCLBiomeRegistry.createRegistryKey(WorldsTogether.makeID("worldgen/betterx/biome_codec"));
    public static Registry<Codec<? extends BCLBiome>> BIOME_CODECS = FabricRegistryBuilder.from((WritableRegistry)new MappedRegistry(BCL_BIOME_CODEC_REGISTRY, Lifecycle.stable())).attribute(RegistryAttribute.MODDED).buildAndRegister();
    public static MappedRegistry<BCLBiome> BUILTIN_BCL_BIOMES = new MappedRegistry(BCL_BIOMES_REGISTRY, Lifecycle.stable());
    public static final BCLBiome EMPTY_BIOME = new BCLBiome(Biomes.f_48173_.m_135782_());
    private static boolean didCreate = false;

    public static boolean isEmptyBiome(ResourceLocation l) {
        return l == null || Biomes.f_48173_.m_135782_().equals((Object)l);
    }

    public static boolean isEmptyBiome(BCLBiome b) {
        return b == null || b == EMPTY_BIOME;
    }

    public static <E extends BCLBiome> Codec<E> registerBiomeCodec(ResourceLocation location, KeyDispatchDataCodec<E> codec) {
        Registry.m_122965_(BIOME_CODECS, (ResourceLocation)location, (Object)codec.f_216232_());
        return codec.f_216232_();
    }

    @ApiStatus.Internal
    public static ResourceKey<BCLBiome> registerForDatagen(BCLBiome biome) {
        if (BUILTIN_BCL_BIOMES == null) {
            return biome.getBCLBiomeKey();
        }
        Registry.m_194579_(BUILTIN_BCL_BIOMES, biome.getBCLBiomeKey(), (Object)biome);
        return biome.getBCLBiomeKey();
    }

    public static void register(BCLBiome biome) {
        BCLBiomeRegistry.registerForDatagen(biome);
    }

    public static BCLBiome registerIfUnknown(Holder<Biome> biomeHolder, @NotNull BiomeAPI.BiomeType intendedType) {
        if (biomeHolder == null) {
            return null;
        }
        return BCLBiomeRegistry.registerIfUnknown((ResourceKey<Biome>)((ResourceKey)biomeHolder.m_203543_().orElse(null)), intendedType);
    }

    public static BCLBiome registerIfUnknown(ResourceKey<Biome> biomeKey, @NotNull BiomeAPI.BiomeType intendedType) {
        if (biomeKey != null && !BCLBiomeRegistry.hasBiome(biomeKey, BCLBiomeRegistry.registryOrNull())) {
            BCLBiome bclBiome = new BCLBiome(biomeKey.m_135782_(), intendedType);
            BCLBiomeRegistry.register(bclBiome);
            return bclBiome;
        }
        return null;
    }

    public static boolean hasBiome(ResourceKey<Biome> key, Registry<BCLBiome> bclBiomes) {
        return BCLBiomeRegistry.hasBiome(key.m_135782_(), bclBiomes);
    }

    public static boolean hasBiome(ResourceLocation loc, Registry<BCLBiome> bclBiomes) {
        if (loc == null) {
            return false;
        }
        if (bclBiomes != null && bclBiomes.m_7804_(loc)) {
            return true;
        }
        return BUILTIN_BCL_BIOMES.m_7804_(loc);
    }

    public static BCLBiome getBiome(ResourceKey<Biome> key, Registry<BCLBiome> bclBiomes) {
        return BCLBiomeRegistry.getBiome(key.m_135782_(), bclBiomes);
    }

    public static BCLBiome getBiome(ResourceLocation loc, Registry<BCLBiome> bclBiomes) {
        if (bclBiomes != null && bclBiomes.m_7804_(loc)) {
            return (BCLBiome)bclBiomes.m_7745_(loc);
        }
        return (BCLBiome)BUILTIN_BCL_BIOMES.m_7745_(loc);
    }

    public static BCLBiome getBiomeOrNull(ResourceLocation loc, Registry<BCLBiome> bclBiomes) {
        if (!BCLBiomeRegistry.hasBiome(loc, bclBiomes)) {
            return null;
        }
        return BCLBiomeRegistry.getBiome(loc, bclBiomes);
    }

    public static BCLBiome getBiomeOrNull(ResourceKey<Biome> key, Registry<BCLBiome> bclBiomes) {
        return BCLBiomeRegistry.getBiomeOrNull(key.m_135782_(), bclBiomes);
    }

    public static BCLBiome getBiomeOrEmpty(ResourceLocation loc, Registry<BCLBiome> bclBiomes) {
        if (!BCLBiomeRegistry.hasBiome(loc, bclBiomes)) {
            return EMPTY_BIOME;
        }
        return BCLBiomeRegistry.getBiome(loc, bclBiomes);
    }

    public static BCLBiome getBiomeOrEmpty(ResourceKey<Biome> key, Registry<BCLBiome> bclBiomes) {
        return BCLBiomeRegistry.getBiomeOrEmpty(key.m_135782_(), bclBiomes);
    }

    private static <T> ResourceKey<Registry<T>> createRegistryKey(ResourceLocation location) {
        return ResourceKey.m_135788_((ResourceLocation)location);
    }

    private static Codec<? extends BCLBiome> bootstrapCodecs(Registry<Codec<? extends BCLBiome>> registry) {
        return (Codec)Registry.m_122965_(registry, (ResourceLocation)BCLib.makeID("biome"), (Object)BCLBiome.KEY_CODEC.f_216232_());
    }

    public static Registry<BCLBiome> registryOrNull() {
        if (WorldBootstrap.getLastRegistryAccess() == null) {
            return null;
        }
        return WorldBootstrap.getLastRegistryAccess().m_6632_(BCL_BIOMES_REGISTRY).orElse(null);
    }

    public static Stream<ResourceKey<BCLBiome>> getAll(BiomeAPI.BiomeType dim) {
        HashSet result = new HashSet();
        Registry<BCLBiome> reg = BCLBiomeRegistry.registryOrNull();
        if (reg != null) {
            reg.m_6579_().stream().filter(e -> ((BCLBiome)e.getValue()).getIntendedType().is(dim)).map(e -> (ResourceKey)e.getKey()).forEach(k -> result.add(k));
        }
        if (BUILTIN_BCL_BIOMES != null) {
            BUILTIN_BCL_BIOMES.m_6579_().stream().filter(e -> ((BCLBiome)e.getValue()).getIntendedType().is(dim)).map(e -> (ResourceKey)e.getKey()).filter(k -> !result.contains(k)).forEach(k -> result.add(k));
        }
        return result.stream();
    }

    private static Registry<BCLBiome> getBclBiomesRegistry(@Nullable RegistryAccess access) {
        if (access != null) {
            return (Registry)access.m_6632_(BCL_BIOMES_REGISTRY).orElse(BUILTIN_BCL_BIOMES);
        }
        return BUILTIN_BCL_BIOMES;
    }

    @ApiStatus.Internal
    public static void register() {
        BCLBiomeRegistry.bootstrapCodecs(BIOME_CODECS);
    }

    @ApiStatus.Internal
    public static void bootstrap(BootstapContext<BCLBiome> ctx) {
    }

    private static void onBiomeLoad(Registry<BCLBiome> registry, int rawID, ResourceLocation id, BCLBiome biome) {
        if (!"minecraft".equals(id.m_135827_())) {
            if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_NETHER)) {
                for (Climate.ParameterPoint params : biome.parameterPoints) {
                    NetherBiomes.addNetherBiome(biome.getBiomeKey(), (Climate.ParameterPoint)params);
                }
            } else if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_END_CENTER)) {
                TheEndBiomes.addMainIslandBiome(biome.getBiomeKey(), (double)1.0);
            } else if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_END_BARRENS)) {
                TheEndBiomes.addBarrensBiome(biome.getParentBiome().getBiomeKey(), biome.getBiomeKey(), (double)1.0);
            } else if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_END_LAND)) {
                TheEndBiomes.addHighlandsBiome(biome.getBiomeKey(), (double)1.0);
                TheEndBiomes.addMidlandsBiome(biome.getBiomeKey(), biome.getBiomeKey(), (double)1.0);
            } else if (biome.getIntendedType().is(BiomeAPI.BiomeType.BCL_END_VOID)) {
                TheEndBiomes.addSmallIslandsBiome(biome.getBiomeKey(), (double)1.0);
            } else {
                BCLib.LOGGER.info("Did not manage biome " + biome);
            }
        }
    }

    static {
        DynamicRegistrySetupCallback.EVENT.register(registryManager -> {
            Optional oBCLBiomeRegistry = registryManager.asDynamicRegistryManager().m_6632_(BCL_BIOMES_REGISTRY);
            if (oBCLBiomeRegistry.isPresent()) {
                Registry registry = (Registry)oBCLBiomeRegistry.orElseThrow();
                RegistryEntryAddedCallback.event((Registry)((Registry)oBCLBiomeRegistry.get())).register((rawId, loc, biome) -> BCLBiomeRegistry.onBiomeLoad((Registry<BCLBiome>)registry, rawId, loc, biome));
            } else {
                BCLib.LOGGER.warning("No valid BCLBiome Registry available!", new Object[0]);
            }
        });
    }
}

