/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.interfaces.ChunkGeneratorAccessor;
import org.betterx.bclib.interfaces.NoiseGeneratorSettingsProvider;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.biomesource.MergeableBiomeSource;
import org.betterx.worlds.together.biomesource.ReloadableBiomeSource;
import org.betterx.worlds.together.chunkgenerator.EnforceableChunkGenerator;
import org.betterx.worlds.together.chunkgenerator.InjectableSurfaceRules;
import org.betterx.worlds.together.chunkgenerator.RestorableBiomeSource;
import org.betterx.worlds.together.world.BiomeSourceWithNoiseRelatedSettings;

public class BCLChunkGenerator
extends NoiseBasedChunkGenerator
implements RestorableBiomeSource<BCLChunkGenerator>,
InjectableSurfaceRules<BCLChunkGenerator>,
EnforceableChunkGenerator<BCLChunkGenerator> {
    public static final Codec<BCLChunkGenerator> CODEC = RecordCodecBuilder.create(builderInstance -> {
        RecordCodecBuilder biomeSourceCodec = BiomeSource.f_47888_.fieldOf("biome_source").forGetter(generator -> generator.f_62137_);
        RecordCodecBuilder settingsCodec = NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(generator -> generator.m_224341_());
        return builderInstance.group((App)biomeSourceCodec, (App)settingsCodec).apply((Applicative)builderInstance, builderInstance.stable(BCLChunkGenerator::new));
    });
    protected static final NoiseSettings NETHER_NOISE_SETTINGS_AMPLIFIED = NoiseSettings.m_224525_((int)0, (int)256, (int)1, (int)4);
    public static final ResourceKey<NoiseGeneratorSettings> AMPLIFIED_NETHER = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)BCLib.makeID("amplified_nether"));
    public final BiomeSource initialBiomeSource;

    public BCLChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> holder) {
        super(biomeSource, holder);
        this.initialBiomeSource = biomeSource;
        if (biomeSource instanceof BiomeSourceWithNoiseRelatedSettings) {
            BiomeSourceWithNoiseRelatedSettings bcl = (BiomeSourceWithNoiseRelatedSettings)biomeSource;
            if (holder.m_203633_()) {
                bcl.onLoadGeneratorSettings((NoiseGeneratorSettings)holder.m_203334_());
            }
        }
        if (WorldsTogether.RUNS_TERRABLENDER) {
            BCLib.LOGGER.info("Make sure features are loaded from terrablender:" + biomeSource.getClass().getName());
            this.rebuildFeaturesPerStep(biomeSource);
        }
    }

    private void rebuildFeaturesPerStep(BiomeSource biomeSource) {
        BCLChunkGenerator bCLChunkGenerator = this;
        if (bCLChunkGenerator instanceof org.betterx.bclib.mixin.common.ChunkGeneratorAccessor) {
            org.betterx.bclib.mixin.common.ChunkGeneratorAccessor acc = (org.betterx.bclib.mixin.common.ChunkGeneratorAccessor)((Object)bCLChunkGenerator);
            Function<Holder, BiomeGenerationSettings> function = hh -> ((Biome)hh.m_203334_()).m_47536_();
            acc.bcl_setFeaturesPerStep((Supplier<List<FeatureSorter.StepFeatureData>>)Suppliers.memoize(() -> FeatureSorter.m_220603_(List.copyOf(biomeSource.m_207840_()), hh -> ((BiomeGenerationSettings)function.apply((Holder)hh)).m_47818_(), (boolean)true)));
        }
    }

    @Override
    public void restoreInitialBiomeSource(ResourceKey<LevelStem> dimensionKey) {
        BCLChunkGenerator bCLChunkGenerator;
        if (this.initialBiomeSource != this.m_62218_() && (bCLChunkGenerator = this) instanceof org.betterx.bclib.mixin.common.ChunkGeneratorAccessor) {
            org.betterx.bclib.mixin.common.ChunkGeneratorAccessor acc = (org.betterx.bclib.mixin.common.ChunkGeneratorAccessor)((Object)bCLChunkGenerator);
            BiomeSource biomeSource = this.initialBiomeSource;
            if (biomeSource instanceof MergeableBiomeSource) {
                MergeableBiomeSource bs = (MergeableBiomeSource)biomeSource;
                acc.bcl_setBiomeSource((BiomeSource)bs.mergeWithBiomeSource(this.m_62218_()));
            } else {
                biomeSource = this.initialBiomeSource;
                if (biomeSource instanceof ReloadableBiomeSource) {
                    ReloadableBiomeSource bs = (ReloadableBiomeSource)biomeSource;
                    bs.reloadBiomes();
                }
            }
            this.rebuildFeaturesPerStep(this.m_62218_());
        }
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public String toString() {
        return "BCLib - Chunk Generator (" + Integer.toHexString(this.hashCode()) + ")";
    }

    public void appendFeaturesPerStep() {
    }

    @Override
    public Registry<LevelStem> enforceGeneratorInWorldGenSettings(RegistryAccess access, ResourceKey<LevelStem> dimensionKey, ResourceKey<DimensionType> dimensionTypeKey, ChunkGenerator loadedChunkGenerator, Registry<LevelStem> dimensionRegistry) {
        BCLib.LOGGER.info("Enforcing Correct Generator for " + dimensionKey.m_135782_().toString() + ".");
        BCLChunkGenerator referenceGenerator = this;
        if (loadedChunkGenerator instanceof ChunkGeneratorAccessor) {
            ChunkGeneratorAccessor generator = (ChunkGeneratorAccessor)loadedChunkGenerator;
            if (loadedChunkGenerator instanceof NoiseGeneratorSettingsProvider) {
                NoiseGeneratorSettingsProvider noiseProvider = (NoiseGeneratorSettingsProvider)loadedChunkGenerator;
                if (referenceGenerator instanceof NoiseGeneratorSettingsProvider) {
                    Object bs;
                    NoiseGeneratorSettingsProvider referenceProvider = (NoiseGeneratorSettingsProvider)((Object)referenceGenerator);
                    BiomeSource biomeSource = referenceGenerator.m_62218_();
                    if (biomeSource instanceof MergeableBiomeSource) {
                        MergeableBiomeSource mbs = (MergeableBiomeSource)biomeSource;
                        bs = mbs.mergeWithBiomeSource(loadedChunkGenerator.m_62218_());
                    } else {
                        bs = referenceGenerator.m_62218_();
                    }
                    referenceProvider.bclib_getNoiseGeneratorSettingHolders();
                    referenceGenerator = new BCLChunkGenerator((BiomeSource)bs, noiseProvider.bclib_getNoiseGeneratorSettingHolders());
                }
            }
        }
        return LevelGenUtil.replaceGenerator(dimensionKey, dimensionTypeKey, access, dimensionRegistry, (ChunkGenerator)referenceGenerator);
    }

    public static NoiseGeneratorSettings amplifiedNether(BootstapContext<NoiseGeneratorSettings> bootstapContext) {
        HolderGetter densityGetter = bootstapContext.m_255420_(Registries.f_257040_);
        return new NoiseGeneratorSettings(NETHER_NOISE_SETTINGS_AMPLIFIED, Blocks.f_50134_.m_49966_(), Blocks.f_49991_.m_49966_(), NoiseRouterData.m_254999_((HolderGetter)densityGetter, (HolderGetter)bootstapContext.m_255420_(Registries.f_256865_), (DensityFunction)NoiseRouterData.m_254915_((HolderGetter)densityGetter, (int)0, (int)256)), SurfaceRuleData.m_194812_(), List.of(), 32, false, false, false, true);
    }

    public static Map<String, Supplier<TypeTemplate>> addGeneratorDSL(Map<String, Supplier<TypeTemplate>> map) {
        if (map.containsKey("minecraft:flat")) {
            HashMap<String, Supplier<TypeTemplate>> nMap = new HashMap<String, Supplier<TypeTemplate>>(map);
            nMap.put("bclib:betterx", DSL::remainder);
            return nMap;
        }
        return map;
    }
}

