/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.datafixer;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.ZipException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.datafixer.MigrationProfile;
import org.betterx.bclib.api.v2.datafixer.Patch;
import org.betterx.bclib.api.v2.datafixer.PatchDidiFailException;
import org.betterx.bclib.client.gui.screens.AtomicProgressListener;
import org.betterx.bclib.client.gui.screens.ConfirmFixScreen;
import org.betterx.bclib.client.gui.screens.LevelFixErrorScreen;
import org.betterx.bclib.client.gui.screens.ProgressScreen;
import org.betterx.bclib.config.Configs;
import org.betterx.worlds.together.util.Logger;
import org.betterx.worlds.together.world.WorldConfig;
import org.jetbrains.annotations.NotNull;

public class DataFixerAPI {
    static final Logger LOGGER = new Logger("DataFixerAPI");
    static CompoundTag patchConfTag = null;

    private static boolean wrapCall(LevelStorageSource levelSource, String levelID, Function<LevelStorageSource.LevelStorageAccess, Boolean> runWithLevel) {
        LevelStorageSource.LevelStorageAccess levelStorageAccess;
        try {
            levelStorageAccess = levelSource.m_78260_(levelID);
        }
        catch (IOException e) {
            BCLib.LOGGER.warning("Failed to read level {} data", (Object)levelID, e);
            SystemToast.m_94852_((Minecraft)Minecraft.m_91087_(), (String)levelID);
            Minecraft.m_91087_().m_91152_(null);
            return true;
        }
        boolean returnValue = runWithLevel.apply(levelStorageAccess);
        try {
            levelStorageAccess.close();
        }
        catch (IOException e) {
            BCLib.LOGGER.warning("Failed to unlock access to level {}", (Object)levelID, e);
        }
        return returnValue;
    }

    public static boolean fixData(LevelStorageSource levelSource, String levelID, boolean showUI, Consumer<Boolean> onResume) {
        return DataFixerAPI.wrapCall(levelSource, levelID, levelStorageAccess -> DataFixerAPI.fixData(levelStorageAccess, showUI, onResume));
    }

    public static boolean fixData(LevelStorageSource.LevelStorageAccess levelStorageAccess, boolean showUI, Consumer<Boolean> onResume) {
        File levelPath = levelStorageAccess.m_78283_(LevelResource.f_78182_).toFile();
        return DataFixerAPI.fixData(levelPath, levelStorageAccess.m_78277_(), showUI, onResume);
    }

    public static void initializePatchData() {
        DataFixerAPI.getMigrationProfile().markApplied();
        WorldConfig.saveFile("bclib");
    }

    @Environment(value=EnvType.CLIENT)
    private static AtomicProgressListener showProgressScreen() {
        ProgressScreen ps = new ProgressScreen(Minecraft.m_91087_().f_91080_, (Component)Component.m_237115_((String)"title.bclib.datafixer.progress"), (Component)Component.m_237115_((String)"message.bclib.datafixer.progress"));
        Minecraft.m_91087_().m_91152_((Screen)ps);
        return ps;
    }

    private static boolean fixData(File dir, String levelID, boolean showUI, Consumer<Boolean> onResume) {
        MigrationProfile profile = DataFixerAPI.loadProfileIfNeeded(dir);
        BiConsumer<Boolean, Boolean> runFixes = (createBackup, applyFixes) -> {
            AtomicProgressListener progress = applyFixes.booleanValue() ? (showUI ? DataFixerAPI.showProgressScreen() : new AtomicProgressListener(){
                private long timeStamp = Util.m_137550_();
                private AtomicInteger counter = new AtomicInteger(0);

                @Override
                public void incAtomic(int maxProgress) {
                    int percentage = 100 * this.counter.incrementAndGet() / maxProgress;
                    if (Util.m_137550_() - this.timeStamp >= 1000L) {
                        this.timeStamp = Util.m_137550_();
                        BCLib.LOGGER.info("Patching... {}%", percentage);
                    }
                }

                @Override
                public void resetAtomic() {
                    this.counter = new AtomicInteger(0);
                }

                @Override
                public void m_7730_() {
                }

                @Override
                public void m_6307_(Component component) {
                    BCLib.LOGGER.info("Patcher Stage... {}%", component.getString());
                }
            }) : null;
            Supplier<State> runner = () -> {
                if (createBackup.booleanValue()) {
                    progress.m_6307_((Component)Component.m_237115_((String)"message.bclib.datafixer.progress.waitbackup"));
                    EditWorldScreen.m_101260_((LevelStorageSource)Minecraft.m_91087_().m_91392_(), (String)levelID);
                }
                if (applyFixes.booleanValue()) {
                    return DataFixerAPI.runDataFixes(dir, profile, progress);
                }
                return new State();
            };
            if (showUI) {
                Thread fixerThread = new Thread(() -> {
                    State state = (State)runner.get();
                    Minecraft.m_91087_().execute(() -> {
                        if (profile != null && showUI) {
                            if (state.didFail || state.hasError()) {
                                DataFixerAPI.showLevelFixErrorScreen(state, markFixed -> {
                                    if (markFixed) {
                                        profile.markApplied();
                                    }
                                    onResume.accept((Boolean)applyFixes);
                                });
                            } else {
                                onResume.accept((Boolean)applyFixes);
                            }
                        }
                    });
                });
                fixerThread.start();
            } else {
                State state = runner.get();
                if (state.hasError()) {
                    LOGGER.error("There were Errors while fixing the Level:");
                    LOGGER.error(state.getErrorMessage());
                }
            }
        };
        if (profile != null) {
            if (showUI) {
                DataFixerAPI.showBackupWarning(levelID, runFixes);
                return true;
            }
            BCLib.LOGGER.warning("Applying Fixes on Level", new Object[0]);
            runFixes.accept(false, true);
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static void showLevelFixErrorScreen(State state, LevelFixErrorScreen.Listener onContinue) {
        Minecraft.m_91087_().m_91152_((Screen)new LevelFixErrorScreen(Minecraft.m_91087_().f_91080_, state.getErrorMessages(), onContinue));
    }

    private static MigrationProfile loadProfileIfNeeded(File levelBaseDir) {
        if (!Configs.MAIN_CONFIG.applyPatches()) {
            LOGGER.info("World Patches are disabled");
            return null;
        }
        MigrationProfile profile = DataFixerAPI.getMigrationProfile();
        profile.runPrePatches(levelBaseDir);
        if (!profile.hasAnyFixes()) {
            LOGGER.info("Everything up to date");
            return null;
        }
        return profile;
    }

    @NotNull
    private static MigrationProfile getMigrationProfile() {
        CompoundTag patchConfig = WorldConfig.getCompoundTag("bclib", "patches");
        MigrationProfile profile = Patch.createMigrationData(patchConfig);
        return profile;
    }

    @Environment(value=EnvType.CLIENT)
    static void showBackupWarning(String levelID, BiConsumer<Boolean, Boolean> whenFinished) {
        Minecraft.m_91087_().m_91152_((Screen)new ConfirmFixScreen(null, whenFinished::accept));
    }

    private static State runDataFixes(File dir, MigrationProfile profile, AtomicProgressListener progress) {
        State state = new State();
        progress.resetAtomic();
        progress.m_6307_((Component)Component.m_237115_((String)"message.bclib.datafixer.progress.reading"));
        List<File> players = DataFixerAPI.getAllPlayers(dir);
        List<File> regions = DataFixerAPI.getAllRegions(dir, null);
        int maxProgress = players.size() + regions.size() + 4;
        progress.incAtomic(maxProgress);
        progress.m_6307_((Component)Component.m_237115_((String)"message.bclib.datafixer.progress.players"));
        players.parallelStream().forEach(file -> {
            DataFixerAPI.fixPlayer(profile, state, file);
            progress.incAtomic(maxProgress);
        });
        progress.m_6307_((Component)Component.m_237115_((String)"message.bclib.datafixer.progress.level"));
        DataFixerAPI.fixLevel(profile, state, dir);
        progress.incAtomic(maxProgress);
        progress.m_6307_((Component)Component.m_237115_((String)"message.bclib.datafixer.progress.worlddata"));
        try {
            profile.patchWorldData();
        }
        catch (PatchDidiFailException e) {
            state.didFail = true;
            state.addError("Failed fixing worldconfig (" + e.getMessage() + ")");
            BCLib.LOGGER.error(e.getMessage());
        }
        progress.incAtomic(maxProgress);
        progress.m_6307_((Component)Component.m_237115_((String)"message.bclib.datafixer.progress.regions"));
        regions.parallelStream().forEach(file -> {
            DataFixerAPI.fixRegion(profile, state, file);
            progress.incAtomic(maxProgress);
        });
        if (!state.didFail) {
            progress.m_6307_((Component)Component.m_237115_((String)"message.bclib.datafixer.progress.saving"));
            profile.markApplied();
            WorldConfig.saveFile("bclib");
        }
        progress.incAtomic(maxProgress);
        progress.m_7730_();
        return state;
    }

    private static void fixLevel(MigrationProfile profile, State state, File levelBaseDir) {
        try {
            CompoundTag dataTag;
            LOGGER.info("Inspecting level.dat in " + levelBaseDir);
            CompoundTag level = profile.getLevelDat(levelBaseDir);
            boolean[] changed = new boolean[]{profile.isLevelDatChanged()};
            if (profile.getPrePatchException() != null) {
                throw profile.getPrePatchException();
            }
            if (level.m_128441_("Data") && (dataTag = (CompoundTag)level.m_128423_("Data")).m_128441_("Player")) {
                CompoundTag player = (CompoundTag)dataTag.m_128423_("Player");
                DataFixerAPI.fixPlayerNbt(player, changed, profile);
            }
            if (changed[0]) {
                LOGGER.warning("Writing '{}'", profile.getLevelDatFile());
                NbtIo.m_128944_((CompoundTag)level, (File)profile.getLevelDatFile());
            }
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed fixing Level-Data.");
            state.addError("Failed fixing Level-Data in level.dat (" + e.getMessage() + ")");
            state.didFail = true;
            e.printStackTrace();
        }
    }

    private static void fixPlayer(MigrationProfile data, State state, File file) {
        try {
            LOGGER.info("Inspecting " + file);
            CompoundTag player = DataFixerAPI.readNbt(file);
            boolean[] changed = new boolean[]{false};
            DataFixerAPI.fixPlayerNbt(player, changed, data);
            if (changed[0]) {
                LOGGER.warning("Writing '{}'", file);
                NbtIo.m_128944_((CompoundTag)player, (File)file);
            }
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed fixing Player-Data.");
            state.addError("Failed fixing Player-Data in " + file.getName() + " (" + e.getMessage() + ")");
            state.didFail = true;
            e.printStackTrace();
        }
    }

    private static void fixPlayerNbt(CompoundTag player, boolean[] changed, MigrationProfile data) {
        ListTag inventory = player.m_128437_("Inventory", 10);
        DataFixerAPI.fixItemArrayWithID(inventory, changed, data, true);
        ListTag enderitems = player.m_128437_("EnderItems", 10);
        DataFixerAPI.fixItemArrayWithID(enderitems, changed, data, true);
        if (player.m_128441_("recipeBook")) {
            CompoundTag recipeBook = player.m_128469_("recipeBook");
            changed[0] = changed[0] | DataFixerAPI.fixStringIDList(recipeBook, "recipes", data);
            changed[0] = changed[0] | DataFixerAPI.fixStringIDList(recipeBook, "toBeDisplayed", data);
        }
    }

    static boolean fixStringIDList(CompoundTag root, String name, MigrationProfile data) {
        boolean _changed = false;
        if (root.m_128441_(name)) {
            ListTag items = root.m_128437_(name, 8);
            ListTag newItems = new ListTag();
            for (Tag tag : items) {
                StringTag str = (StringTag)tag;
                String replace = data.replaceStringFromIDs(str.m_7916_());
                if (replace != null) {
                    _changed = true;
                    newItems.add((Object)StringTag.m_129297_((String)replace));
                    continue;
                }
                newItems.add((Object)tag);
            }
            if (_changed) {
                root.m_128365_(name, (Tag)newItems);
            }
        }
        return _changed;
    }

    private static void fixRegion(MigrationProfile data, State state, File file) {
        try {
            Path path = file.toPath();
            LOGGER.info("Inspecting " + path);
            boolean[] changed = new boolean[1];
            RegionFile region = new RegionFile(path, path.getParent(), true);
            for (int x = 0; x < 32; ++x) {
                for (int z = 0; z < 32; ++z) {
                    ChunkPos pos = new ChunkPos(x, z);
                    changed[0] = false;
                    if (!region.m_63682_(pos) || state.didFail) continue;
                    DataInputStream input = region.m_63645_(pos);
                    CompoundTag root = NbtIo.m_128928_((DataInput)input);
                    input.close();
                    ListTag tileEntities = root.m_128469_("Level").m_128437_("TileEntities", 10);
                    DataFixerAPI.fixItemArrayWithID(tileEntities, changed, data, true);
                    ListTag entities = root.m_128437_("Entities", 10);
                    DataFixerAPI.fixItemArrayWithID(entities, changed, data, true);
                    ListTag sections = root.m_128469_("Level").m_128437_("Sections", 10);
                    sections.forEach(tag -> {
                        ListTag palette = ((CompoundTag)tag).m_128437_("Palette", 10);
                        palette.forEach(blockTag -> {
                            CompoundTag blockTagCompound = (CompoundTag)blockTag;
                            changed[0] = changed[0] | data.replaceStringFromIDs(blockTagCompound, "Name");
                        });
                        try {
                            changed[0] = changed[0] | data.patchBlockState(palette, ((CompoundTag)tag).m_128437_("BlockStates", 4));
                        }
                        catch (PatchDidiFailException e) {
                            BCLib.LOGGER.error("Failed fixing BlockState in " + pos);
                            state.addError("Failed fixing BlockState in " + pos + " (" + e.getMessage() + ")");
                            state.didFail = true;
                            changed[0] = false;
                            e.printStackTrace();
                        }
                    });
                    if (!changed[0]) continue;
                    LOGGER.warning("Writing '{}': {}/{}", file, x, z);
                    DataOutputStream output = region.m_63678_(pos);
                    NbtIo.m_128941_((CompoundTag)root, (DataOutput)output);
                    output.close();
                }
            }
            region.close();
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed fixing Region.");
            state.addError("Failed fixing Region in " + file.getName() + " (" + e.getMessage() + ")");
            state.didFail = true;
            e.printStackTrace();
        }
    }

    static CompoundTag getPatchData() {
        if (patchConfTag == null) {
            patchConfTag = WorldConfig.getCompoundTag("bclib", "patches");
        }
        return patchConfTag;
    }

    static void fixItemArrayWithID(ListTag items, boolean[] changed, MigrationProfile data, boolean recursive) {
        items.forEach(inTag -> DataFixerAPI.fixID((CompoundTag)inTag, changed, data, recursive));
    }

    static void fixID(CompoundTag inTag, boolean[] changed, MigrationProfile data, boolean recursive) {
        CompoundTag entityTag;
        CompoundTag tag = inTag;
        changed[0] = changed[0] | data.replaceStringFromIDs(tag, "id");
        if (tag.m_128441_("Item")) {
            CompoundTag item = (CompoundTag)tag.m_128423_("Item");
            DataFixerAPI.fixID(item, changed, data, recursive);
        }
        if (recursive && tag.m_128441_("Items")) {
            DataFixerAPI.fixItemArrayWithID(tag.m_128437_("Items", 10), changed, data, true);
        }
        if (recursive && tag.m_128441_("Inventory")) {
            ListTag inventory = tag.m_128437_("Inventory", 10);
            DataFixerAPI.fixItemArrayWithID(inventory, changed, data, true);
        }
        if (tag.m_128441_("tag") && (entityTag = (CompoundTag)tag.m_128423_("tag")).m_128441_("BlockEntityTag")) {
            CompoundTag blockEntityTag = (CompoundTag)entityTag.m_128423_("BlockEntityTag");
            DataFixerAPI.fixID(blockEntityTag, changed, data, recursive);
        }
    }

    private static List<File> getAllPlayers(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        if (!(dir = new File(dir, "playerdata")).exists() || !dir.isDirectory()) {
            return list;
        }
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".dat")) continue;
            list.add(file);
        }
        return list;
    }

    private static List<File> getAllRegions(File dir, List<File> list) {
        if (list == null) {
            list = new ArrayList<File>();
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                DataFixerAPI.getAllRegions(file, list);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".mca")) continue;
            list.add(file);
        }
        return list;
    }

    public static void registerPatch(Supplier<Patch> patch) {
        Patch.getALL().add(patch.get());
    }

    private static CompoundTag readNbt(File file) throws IOException {
        try {
            return NbtIo.m_128937_((File)file);
        }
        catch (EOFException | ZipException e) {
            return NbtIo.m_128953_((File)file);
        }
    }

    static class State {
        public boolean didFail = false;
        protected ArrayList<String> errors = new ArrayList();

        State() {
        }

        public void addError(String s) {
            this.errors.add(s);
        }

        public boolean hasError() {
            return this.errors.size() > 0;
        }

        public String getErrorMessage() {
            return this.errors.stream().reduce("", (a, b) -> a + "  - " + b + "\n");
        }

        public String[] getErrorMessages() {
            String[] res = new String[this.errors.size()];
            return this.errors.toArray(res);
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void call();
    }
}

