/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange.handler;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.betterx.bclib.api.v2.dataexchange.ConnectorClientside;
import org.betterx.bclib.api.v2.dataexchange.ConnectorServerside;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.dataexchange.DataHandlerDescriptor;

public abstract class DataExchange {
    private static DataExchangeAPI instance;
    protected ConnectorServerside server;
    protected ConnectorClientside client;
    protected final Set<DataHandlerDescriptor> descriptors = new HashSet<DataHandlerDescriptor>();
    private final boolean didLoadSyncFolder = false;

    protected static DataExchangeAPI getInstance() {
        if (instance == null) {
            instance = new DataExchangeAPI();
        }
        return instance;
    }

    protected abstract ConnectorClientside clientSupplier(DataExchange var1);

    protected abstract ConnectorServerside serverSupplier(DataExchange var1);

    protected DataExchange() {
    }

    public Set<DataHandlerDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public static DataHandlerDescriptor getDescriptor(ResourceLocation identifier) {
        return DataExchange.getInstance().descriptors.stream().filter(d -> d.equals(identifier)).findFirst().orElse(null);
    }

    @Environment(value=EnvType.CLIENT)
    protected void initClientside() {
        if (this.client != null) {
            return;
        }
        this.client = this.clientSupplier(this);
        ClientPlayConnectionEvents.INIT.register(this.client::onPlayInit);
        ClientPlayConnectionEvents.JOIN.register(this.client::onPlayReady);
        ClientPlayConnectionEvents.DISCONNECT.register(this.client::onPlayDisconnect);
    }

    protected void initServerSide() {
        if (this.server != null) {
            return;
        }
        this.server = this.serverSupplier(this);
        ServerPlayConnectionEvents.INIT.register(this.server::onPlayInit);
        ServerPlayConnectionEvents.JOIN.register(this.server::onPlayReady);
        ServerPlayConnectionEvents.DISCONNECT.register(this.server::onPlayDisconnect);
    }

    @Environment(value=EnvType.CLIENT)
    public static void prepareClientside() {
        DataExchangeAPI api = DataExchange.getInstance();
        api.initClientside();
    }

    public static void prepareServerside() {
        DataExchangeAPI api = DataExchange.getInstance();
        api.initServerSide();
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendOnEnter() {
        DataExchange.getInstance().descriptors.forEach(desc -> {
            BaseDataHandler h;
            if (desc.sendBeforeEnter && !(h = desc.JOIN_INSTANCE.get()).getOriginatesOnServer()) {
                DataExchange.getInstance().client.sendToServer(h);
            }
        });
    }
}

