/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.advancement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.advancement.Display;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.bclib.items.complex.EquipmentSet;
import org.betterx.bclib.items.complex.EquipmentSlot;

public class AdvancementManager {
    private static final Map<ResourceLocation, Advancement.Builder> ADVANCEMENTS = new LinkedHashMap<ResourceLocation, Advancement.Builder>();

    public static void register(ResourceLocation id, Advancement.Builder builder) {
        ADVANCEMENTS.put(id, builder);
    }

    public static void registerAllDataGen(List<String> namespaces, Consumer<Advancement> consumer) {
        Advancement ROOT_RECIPE = Advancement.Builder.m_138353_().m_138386_("impossible", (CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()).m_138403_(RecipeBuilder.f_236353_);
        HashMap<ResourceLocation, Advancement> BUILT = new HashMap<ResourceLocation, Advancement>();
        for (Map.Entry<ResourceLocation, Advancement.Builder> entry : ADVANCEMENTS.entrySet()) {
            ResourceLocation loc = entry.getKey();
            if (namespaces != null && !namespaces.contains(loc.m_135827_())) continue;
            Advancement.Builder builder = entry.getValue();
            if (builder.m_138392_(locToAdd -> {
                if (locToAdd.equals((Object)RecipeBuilder.f_236353_)) {
                    return ROOT_RECIPE;
                }
                return (Advancement)BUILT.get(locToAdd);
            })) {
                Advancement adv = builder.m_138403_(loc);
                BUILT.put(loc, adv);
                consumer.accept(adv);
                continue;
            }
            BCLib.LOGGER.error("Unable to build Advancement " + loc);
        }
    }

    public static class DisplayBuilder {
        Builder base;
        final Display display = new Display();

        DisplayBuilder reset(Builder base) {
            this.base = base;
            this.display.reset();
            return this;
        }

        public DisplayBuilder background(ResourceLocation value) {
            this.display.background = value;
            return this;
        }

        public DisplayBuilder icon(ItemLike value) {
            this.display.icon = new ItemStack(value);
            return this;
        }

        public DisplayBuilder icon(ItemStack value) {
            this.display.icon = value;
            return this;
        }

        public DisplayBuilder title(Component value) {
            this.display.title = value;
            return this;
        }

        public DisplayBuilder description(Component value) {
            this.display.description = value;
            return this;
        }

        public DisplayBuilder showToast() {
            this.display.showToast = true;
            return this;
        }

        public DisplayBuilder hideToast() {
            this.display.showToast = false;
            return this;
        }

        public DisplayBuilder hidden() {
            this.display.hidden = true;
            return this;
        }

        public DisplayBuilder visible() {
            this.display.hidden = false;
            return this;
        }

        public DisplayBuilder announceToChat() {
            this.display.announceChat = true;
            return this;
        }

        public DisplayBuilder hideFromChat() {
            this.display.announceChat = false;
            return this;
        }

        public DisplayBuilder frame(FrameType type) {
            this.display.frame = type;
            return this;
        }

        public DisplayBuilder challenge() {
            return this.frame(FrameType.CHALLENGE);
        }

        public DisplayBuilder task() {
            return this.frame(FrameType.TASK);
        }

        public DisplayBuilder goal() {
            return this.frame(FrameType.GOAL);
        }

        public Builder endDisplay() {
            this.base.display(this.display.build());
            return this.base;
        }
    }

    public static class Builder {
        private static final ThreadLocal<DisplayBuilder> DISPLAY_BUILDER = ThreadLocal.withInitial(DisplayBuilder::new);
        private static final ResourceLocation RECIPES_ROOT = RecipeBuilder.f_236353_;
        private final Advancement.Builder builder = new OrderedBuilder();
        private final ResourceLocation id;
        private final AdvancementType type;
        private boolean canBuild = true;

        private Builder(ResourceLocation id, AdvancementType type) {
            ResourceLocation ID;
            if (type == AdvancementType.RECIPE_DECORATIONS) {
                ID = new ResourceLocation(id.m_135827_(), "recipes/decorations/" + id.m_135815_());
                this.builder.m_138396_(RECIPES_ROOT);
            } else if (type == AdvancementType.RECIPE_TOOL) {
                ID = new ResourceLocation(id.m_135827_(), "recipes/tools/" + id.m_135815_());
                this.builder.m_138396_(RECIPES_ROOT);
            } else {
                ID = id;
            }
            this.id = ID;
            this.type = type;
        }

        public static Builder createEmptyCopy(Builder builder) {
            return new Builder(builder.id, builder.type);
        }

        public static Builder create(ResourceLocation id) {
            return new Builder(id, AdvancementType.REGULAR);
        }

        public static Builder create(ResourceLocation id, AdvancementType type) {
            return new Builder(id, type);
        }

        public static Builder create(Item icon) {
            return Builder.create((ItemLike)icon, AdvancementType.REGULAR);
        }

        public static Builder create(ItemStack icon) {
            return Builder.create(icon, AdvancementType.REGULAR);
        }

        public static Builder create(ItemLike icon, AdvancementType type) {
            return Builder.create(new ItemStack(icon), type);
        }

        public static Builder create(ItemStack icon, AdvancementType type) {
            return Builder.create(icon, type, (DisplayBuilder displayBuilder) -> {});
        }

        public static Builder create(Item icon, AdvancementType type, Consumer<DisplayBuilder> displayAdapter) {
            return Builder.create(new ItemStack((ItemLike)icon), type, displayAdapter);
        }

        public static Builder create(ItemStack icon, AdvancementType type, Consumer<DisplayBuilder> displayAdapter) {
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)icon.m_41720_());
            boolean canBuild = true;
            if (id == null || icon.m_150930_(Items.f_41852_)) {
                canBuild = false;
                id = BuiltInRegistries.f_257033_.m_122315_();
            }
            String baseName = "advancements." + id.m_135827_() + "." + id.m_135815_() + ".";
            Builder b = new Builder(id, type);
            DisplayBuilder displayBuilder = b.startDisplay(icon, (Component)Component.m_237115_((String)(baseName + "title")), (Component)Component.m_237115_((String)(baseName + "description")));
            if (displayAdapter != null) {
                displayAdapter.accept(displayBuilder);
            }
            b = displayBuilder.endDisplay();
            b.canBuild = canBuild;
            return b;
        }

        public static <C extends Container, T extends Recipe<C>> Builder createRecipe(T recipe, AdvancementType type) {
            Item item = recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_41720_();
            return Builder.create(item, type, (DisplayBuilder displayBuilder) -> displayBuilder.hideToast().hideFromChat()).addRecipeUnlockCriterion("has_the_recipe", recipe).startReward().addRecipe(recipe.m_6423_()).endReward().requirements(RequirementsStrategy.f_15979_);
        }

        public Builder parent(Advancement advancement) {
            this.builder.m_138398_(advancement);
            return this;
        }

        public Builder parent(ResourceLocation resourceLocation) {
            this.builder.m_138396_(resourceLocation);
            return this;
        }

        public DisplayBuilder startDisplay(ItemLike icon) {
            String baseName = "advancements." + this.id.m_135827_() + "." + this.id.m_135815_() + ".";
            return this.startDisplay(icon, (Component)Component.m_237115_((String)(baseName + "title")), (Component)Component.m_237115_((String)(baseName + "description")));
        }

        public DisplayBuilder startDisplay(ItemLike icon, Component title, Component description) {
            return this.startDisplay(new ItemStack(icon), title, description);
        }

        public DisplayBuilder startDisplay(ItemStack icon, Component title, Component description) {
            if (icon == null) {
                this.canBuild = false;
            } else {
                ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)icon.m_41720_());
                if (id == null) {
                    this.canBuild = false;
                }
            }
            DisplayBuilder dp = DISPLAY_BUILDER.get().reset(this);
            return dp.icon(icon).title(title).description(description);
        }

        Builder display(DisplayInfo displayInfo) {
            this.builder.m_138358_(displayInfo);
            return this;
        }

        public Builder awardRecipe(ItemLike ... items) {
            RewardsBuilder rewardBuilder = this.startReward();
            for (ItemLike item : items) {
                ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
                if (id == null) continue;
                rewardBuilder.addRecipe(id);
            }
            return rewardBuilder.endReward();
        }

        public RewardsBuilder startReward() {
            return new RewardsBuilder(this);
        }

        public Builder rewards(AdvancementRewards advancementRewards) {
            this.builder.m_138356_(advancementRewards);
            return this;
        }

        public Builder rewardXP(int xp) {
            return this.rewards(AdvancementRewards.Builder.m_10005_((int)500).m_10004_());
        }

        public Builder addCriterion(String string, CriterionTriggerInstance criterionTriggerInstance) {
            this.builder.m_138383_(string, new Criterion(criterionTriggerInstance));
            return this;
        }

        public Builder addCriterion(String string, Criterion criterion) {
            this.builder.m_138383_(string, criterion);
            return this;
        }

        public Builder addAtStructureCriterion(String name, BCLStructure<?> structure) {
            return this.addAtStructureCriterion(name, structure.structureKey);
        }

        public Builder addAtStructureCriterion(String name, ResourceKey<Structure> structure) {
            return this.addCriterion(name, (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_220589_(structure)));
        }

        public <C extends Container, T extends Recipe<C>> Builder addRecipeUnlockCriterion(String name, T recipe) {
            return this.addCriterion(name, (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipe.m_6423_()));
        }

        public Builder addInventoryChangedCriterion(String name, ItemLike ... items) {
            return this.addCriterion(name, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])items));
        }

        public Builder addInventoryChangedAnyCriterion(String name, ItemLike ... items) {
            InventoryChangeTrigger.TriggerInstance trigger = InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(null, Arrays.stream(items).map(i -> i.m_5456_()).collect(Collectors.toSet()), MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)});
            return this.addCriterion(name, (CriterionTriggerInstance)trigger);
        }

        public Builder addInventoryChangedCriterion(String name, TagKey<Item> tag) {
            return this.addCriterion(name, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(tag, null, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)}));
        }

        public Builder addEquipmentSetSlotCriterion(EquipmentSet set, EquipmentSlot slot) {
            return this.addInventoryChangedCriterion(set.baseName + "_" + slot, new ItemLike[]{set.getSlot(slot)});
        }

        public Builder addArmorSetCriterion(EquipmentSet set) {
            return this.addEquipmentSetSlotCriterion(set, EquipmentSet.HELMET_SLOT).addEquipmentSetSlotCriterion(set, EquipmentSet.CHESTPLATE_SLOT).addEquipmentSetSlotCriterion(set, EquipmentSet.LEGGINGS_SLOT).addEquipmentSetSlotCriterion(set, EquipmentSet.BOOTS_SLOT);
        }

        public Builder addToolSetCriterion(EquipmentSet set) {
            return this.addEquipmentSetSlotCriterion(set, EquipmentSet.PICKAXE_SLOT).addEquipmentSetSlotCriterion(set, EquipmentSet.AXE_SLOT).addEquipmentSetSlotCriterion(set, EquipmentSet.SHOVEL_SLOT).addEquipmentSetSlotCriterion(set, EquipmentSet.SWORD_SLOT).addEquipmentSetSlotCriterion(set, EquipmentSet.HOE_SLOT);
        }

        public Builder addWoodCriterion(WoodenComplexMaterial mat) {
            return this.addInventoryChangedAnyCriterion("got_" + mat.getBaseName(), new ItemLike[]{mat.getBlock(WoodSlots.LOG), mat.getBlock(WoodSlots.BARK), mat.getBlock(WoodSlots.PLANKS)});
        }

        public Builder addVisitBiomesCriterion(List<ResourceKey<Biome>> list) {
            for (ResourceKey<Biome> resourceKey : list) {
                this.addCriterion(resourceKey.m_135782_().toString(), (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222635_((LocationPredicate)LocationPredicate.m_52634_(resourceKey)));
            }
            return this;
        }

        public Builder requirements(RequirementsStrategy requirementsStrategy) {
            this.builder.m_138360_(requirementsStrategy);
            return this;
        }

        public Builder requirements(String[][] strings) {
            this.builder.m_143951_(strings);
            return this;
        }

        public Builder printDebugJson() {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BCLib.LOGGER.info(gson.toJson((JsonElement)this.builder.m_138400_()));
            return this;
        }

        public ResourceLocation build() {
            AdvancementManager.register(this.id, this.builder);
            return this.id;
        }
    }

    public static enum AdvancementType {
        REGULAR,
        RECIPE_DECORATIONS,
        RECIPE_TOOL;

    }

    public static class RewardsBuilder {
        private final Builder calle;
        private final AdvancementRewards.Builder builder = new AdvancementRewards.Builder();

        private RewardsBuilder(Builder calle) {
            this.calle = calle;
        }

        public RewardsBuilder addExperience(int i) {
            this.builder.m_10007_(i);
            return this;
        }

        public RewardsBuilder addLootTable(ResourceLocation resourceLocation) {
            this.builder.m_144824_(resourceLocation);
            return this;
        }

        public RewardsBuilder addRecipe(ResourceLocation resourceLocation) {
            this.builder.m_10011_(resourceLocation);
            return this;
        }

        public RewardsBuilder runs(ResourceLocation resourceLocation) {
            this.builder.m_144828_(resourceLocation);
            return this;
        }

        public Builder endReward() {
            this.calle.rewards(this.builder.m_10004_());
            return this.calle;
        }
    }

    static class OrderedBuilder
    extends Advancement.Builder {
        OrderedBuilder() {
            super(false);
        }
    }
}

