/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.utils;

import java.util.function.Function;
import net.lopymine.pe.ParticleEffects;
import net.lopymine.pe.modmenu.yacl.simple.SimpleContent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ModMenuUtils {
    private ModMenuUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getOptionKey(String optionId) {
        return String.format("%s.modmenu.option.%s", "particle-effects", optionId);
    }

    public static String getCategoryKey(String categoryId) {
        return String.format("%s.modmenu.category.%s", "particle-effects", categoryId);
    }

    public static String getGroupKey(String groupId) {
        return String.format("%s.modmenu.group.%s", "particle-effects", groupId);
    }

    public static Component getName(String key) {
        return Component.m_237115_((String)(key + ".name"));
    }

    public static Component getDescription(String key) {
        return Component.m_237115_((String)(key + ".description"));
    }

    public static ResourceLocation getContentId(SimpleContent content, String optionId) {
        return ParticleEffects.id(String.format("textures/config/%s/%s.%s", content.getFolder(), optionId, content.getFileExtension()));
    }

    public static Component getModTitle() {
        return ParticleEffects.text("modmenu.title", new Object[0]);
    }

    public static Function<Boolean, Component> getEnabledOrDisabledFormatter() {
        return state -> ParticleEffects.text("modmenu.formatter.enabled_or_disabled." + state, new Object[0]);
    }

    public static Component getNoConfigScreenMessage() {
        return ParticleEffects.text("modmenu.no_config_library_screen.message", new Object[0]);
    }
}

